/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.weightedinventory.WeightedInventoryMod;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.WithConditions;

public final class ArmorSlot {
    public static final ResourceKey<Registry<ArmorSlot>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)WeightedInventoryMod.modLoc("armor_slot"));
    public static final Codec<ArmorSlot> DIRECT_CODEC = ExtraCodecs.catchDecoderException((Codec)RecordCodecBuilder.create(apply -> apply.group((App)ResourceLocation.CODEC.listOf().fieldOf("armorItems").forGetter(ArmorSlot::armorIds), (App)Codec.FLOAT.fieldOf("slotsPerPiece").forGetter(ArmorSlot::slotsPerPiece)).apply((Applicative)apply, ArmorSlot::new)));
    public static final Codec<Optional<WithConditions<ArmorSlot>>> CONDITIONAL_CODEC = ConditionalOps.createConditionalCodecWithConditions(DIRECT_CODEC);
    private final List<ResourceLocation> armorIds;
    private final List<Holder.Reference<Item>> armorItems;
    private final float slotsPerPiece;

    public ArmorSlot(List<ResourceLocation> armorIds, List<Holder.Reference<Item>> armorItems, float slotsPerPiece) {
        this.armorIds = armorIds;
        this.armorItems = armorItems;
        this.slotsPerPiece = slotsPerPiece;
    }

    public ArmorSlot(List<ResourceLocation> armorIds, float slotsPerPiece) {
        this(armorIds, armorIds.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getHolder(arg_0)).filter(Optional::isPresent).map(Optional::get).toList(), slotsPerPiece);
    }

    public static ArmorSlot createSlot(List<Holder.Reference<Item>> armorItems, float slotsPerPiece) {
        return new ArmorSlot(armorItems.stream().map(reference -> reference.key().location()).toList(), slotsPerPiece);
    }

    public List<ResourceLocation> armorIds() {
        return this.armorIds;
    }

    public List<Holder.Reference<Item>> armorItems() {
        return this.armorItems;
    }

    public float slotsPerPiece() {
        return this.slotsPerPiece;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ArmorSlot that = (ArmorSlot)obj;
        return Objects.equals(this.armorIds, that.armorIds) && Float.floatToIntBits(this.slotsPerPiece) == Float.floatToIntBits(that.slotsPerPiece);
    }

    public int hashCode() {
        return Objects.hash(this.armorIds, Float.valueOf(this.slotsPerPiece));
    }

    public String toString() {
        return "ArmorSlot[armorItems=" + String.valueOf(this.armorIds) + ", slotsPerPiece=" + this.slotsPerPiece + "]";
    }
}

