/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.registry;

import com.mrbysco.weightedinventory.WeightedInventoryMod;
import com.mrbysco.weightedinventory.config.WeightedConfig;
import com.mrbysco.weightedinventory.registry.ArmorSlot;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ArmorSlotRegistry {
    private static final Map<Item, Float> itemSlotCache = new HashMap<Item, Float>();
    private static final Map<ResourceLocation, ArmorSlot> armorSlotMap = new HashMap<ResourceLocation, ArmorSlot>();

    public static float getSlots(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0.0f;
        }
        if (itemSlotCache.containsKey(stack.getItem())) {
            return itemSlotCache.get(stack.getItem()).floatValue();
        }
        for (ArmorSlot armorSlot : armorSlotMap.values()) {
            for (Holder.Reference<Item> armorItem : armorSlot.armorItems()) {
                if (!armorItem.is((Holder)stack.getItem().builtInRegistryHolder())) continue;
                float slots = armorSlot.slotsPerPiece();
                itemSlotCache.put(stack.getItem(), Float.valueOf(slots));
                return slots;
            }
        }
        return ((Double)WeightedConfig.COMMON.defaultSlotCount.get()).floatValue();
    }

    @SubscribeEvent
    public static void onNewRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(ArmorSlot.REGISTRY_KEY, ArmorSlot.DIRECT_CODEC, ArmorSlot.DIRECT_CODEC);
    }

    public static void onTagsUpdated(OnDatapackSyncEvent event) {
        RegistryAccess.Frozen registryAccess = event.getPlayerList().getServer().registryAccess();
        itemSlotCache.clear();
        armorSlotMap.clear();
        Registry biomePlaceRegistry = registryAccess.registryOrThrow(ArmorSlot.REGISTRY_KEY);
        biomePlaceRegistry.entrySet().forEach(key -> armorSlotMap.put(((ResourceKey)key.getKey()).location(), (ArmorSlot)key.getValue()));
        WeightedInventoryMod.LOGGER.info("Loaded unlocked armor slots: {} ", (Object)armorSlotMap.size());
    }
}

