/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.util;

import com.mrbysco.weightedinventory.WeightedInventoryMod;
import com.mrbysco.weightedinventory.config.WeightedConfig;
import com.mrbysco.weightedinventory.registry.ArmorAttributeRegistry;
import java.util.Locale;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;

public class UnlockHelper {
    public static final ResourceLocation BASE_UNLOCKED_ID = WeightedInventoryMod.modLoc("base_unlocked");

    public static boolean isUnlocked(int index, int unlockedSlots) {
        if (unlockedSlots > 0) {
            return index - 9 < unlockedSlots;
        }
        return false;
    }

    public static int getUnlockedSlots(Player player) {
        if (WeightedConfig.COMMON.disableInCreative.getAsBoolean() && player.isCreative()) {
            return 27;
        }
        AttributeInstance modifier = player.getAttribute(ArmorAttributeRegistry.UNLOCKED);
        if (modifier != null) {
            return Mth.clamp((int)Mth.floor((double)modifier.getValue()), (int)0, (int)27);
        }
        return 0;
    }

    public static int getUnlockedFreeSlot(Player player, NonNullList<ItemStack> items) {
        int unlockedCount = UnlockHelper.getUnlockedSlots(player) + 9;
        int slots = Mth.clamp((int)unlockedCount, (int)0, (int)items.size());
        if (slots == 0) {
            return -1;
        }
        for (int i = 0; i < slots; ++i) {
            if (!((ItemStack)items.get(i)).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static AttributeModifier createModifier(EquipmentSlot slot, float slots) {
        return new AttributeModifier(BASE_UNLOCKED_ID.withSuffix("_" + slot.getName().toLowerCase(Locale.ROOT)), (double)slots, AttributeModifier.Operation.ADD_VALUE);
    }

    public static EquipmentSlot getEquipmentSlotForItem(ItemStack stack) {
        EquipmentSlot slot = stack.getEquipmentSlot();
        if (slot != null) {
            return slot;
        }
        Equipable equipable = Equipable.get((ItemStack)stack);
        if (equipable != null) {
            return equipable.getEquipmentSlot();
        }
        return EquipmentSlot.MAINHAND;
    }
}

