/*
 * Decompiled with CFR 0.152.
 */
package agusev.peepochat.client;

import agusev.peepochat.client.PaintDirectMessage;
import agusev.peepochat.client.UpdateScreen;
import agusev.peepochat.client.VersionChecker;
import agusev.peepochat.client.config.PeepochatConfig;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class PeepochatClient
implements ClientModInitializer {
    public void onInitializeClient() {
        VersionChecker.VersionResponse response = VersionChecker.checkForUpdate("0.6-mc1.21.3");
        if (response != null && response.has_update) {
            AtomicBoolean updateScreenShown = new AtomicBoolean(false);
            ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
                if (screen instanceof class_442 && !updateScreenShown.get()) {
                    updateScreenShown.set(true);
                    client.method_1507((class_437)new UpdateScreen(screen, response));
                }
            });
        }
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            String rawMessage = this.getRawMessageContent(message);
            if (rawMessage.startsWith("\u2709\u2709\u2709")) {
                boolean isMessageForMe = !(rawMessage = rawMessage.substring(5).trim()).startsWith("\u0412\u044b \u2192");
                String[] parts = rawMessage.split("\u2192");
                String messageText = parts.length > 1 ? parts[1].split("]: ")[1].trim() : "";
                boolean isMessageForMeResult = isMessageForMe;
                String username = isMessageForMeResult ? parts[0].trim() : (parts.length > 1 ? parts[1].split("]: ")[0].trim() : "");
                class_310 client = class_310.method_1551();
                assert (client.field_1724 != null);
                class_5250 text = username.equals("PWGoood") ? PaintDirectMessage.PaintText(isMessageForMeResult, username, messageText, 16622884, 0xFBFF00, PeepochatConfig.getInstance().selectedOption.equals("peepochat.config.option.color_scheme.2_colors")) : (username.equals(client.field_1724.method_5477().method_54160()) ? PaintDirectMessage.PaintText(isMessageForMeResult, username, messageText, 0xC5C5C5, 0x393939, PeepochatConfig.getInstance().selectedOption.equals("peepochat.config.option.color_scheme.2_colors")) : PaintDirectMessage.PaintText(isMessageForMeResult, username, messageText, PeepochatConfig.getInstance().customColor1, PeepochatConfig.getInstance().customColor2, PeepochatConfig.getInstance().selectedOption.equals("peepochat.config.option.color_scheme.2_colors")));
                client.field_1724.method_7353((class_2561)text, false);
                return false;
            }
            if (rawMessage.startsWith("\u2709\u2709") && !rawMessage.startsWith("\u2709\u2709\u2709")) {
                return true;
            }
            return this.shouldAllowMessage(rawMessage);
        });
    }

    private boolean shouldAllowMessage(String message) {
        if (!PeepochatConfig.getInstance().enableFilter) {
            return true;
        }
        String username = this.extractUsername(message);
        return !message.startsWith("[+]") && !message.startsWith("[-]") || this.isFriend(username);
    }

    private boolean isFriend(String username) {
        return PeepochatConfig.getInstance().friendList.contains(username);
    }

    private String extractUsername(String message) {
        if (message.matches(".*\\[([+-])\\].*")) {
            String username = message.replaceAll(".*\\[([+-])\\]\\s*([^\u00a7\\s]+).*", "$2");
            if (username.isEmpty()) {
                return "";
            }
            return username;
        }
        return "";
    }

    private String getRawMessageContent(class_2561 message) {
        return message.getString();
    }

    private void appendTextContent(class_2561 text, StringBuilder builder) {
        builder.append(text.getString());
        for (class_2561 sibling : text.method_10855()) {
            builder.append(sibling.getString());
        }
    }
}

