/*
 * Decompiled with CFR 0.152.
 */
package agusev.peepochat.client;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class VersionChecker {
    private static final String API_URL = "https://peepochat.agusev2311.ru:443/api/version";
    private static final Gson gson = new Gson();

    public static VersionResponse checkForUpdate(String clientVersion) {
        try {
            String responseLine;
            URL url = new URL(API_URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; utf-8");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            String jsonInputString = "{\"version\": \"" + clientVersion + "\"}";
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = jsonInputString.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            BufferedReader br = responseCode == 200 ? new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder response = new StringBuilder();
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine.trim());
            }
            br.close();
            if (responseCode != 200) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f: " + response.toString());
                return null;
            }
            VersionResponse versionResponse = (VersionResponse)gson.fromJson(response.toString(), VersionResponse.class);
            return versionResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class VersionResponse {
        public String version_status;
        public boolean has_update;
        public String changelog;
        public String new_version_link;
    }
}

