/*
 * Decompiled with CFR 0.152.
 */
package agusev.peepochat.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class PeepochatConfig {
    private static PeepochatConfig INSTANCE;
    private static final Gson GSON;
    private static final Path CONFIG_PATH;
    public boolean enableFilter = true;
    public List<String> friendList = new ArrayList<String>();
    public String selectedOption = "peepochat.config.option.color_scheme.2_colors";
    public int customColor1 = 6809849;
    public int customColor2 = 2282478;

    public static PeepochatConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PeepochatConfig();
            INSTANCE.load();
        }
        return INSTANCE;
    }

    public void load() {
        block8: {
            try {
                if (CONFIG_PATH.toFile().exists()) {
                    try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                        PeepochatConfig loaded = (PeepochatConfig)GSON.fromJson((Reader)reader, PeepochatConfig.class);
                        this.enableFilter = loaded.enableFilter;
                        this.friendList = loaded.friendList;
                        this.selectedOption = loaded.selectedOption;
                        this.customColor1 = loaded.customColor1;
                        this.customColor2 = loaded.customColor2;
                        break block8;
                    }
                }
                this.save();
            }
            catch (IOException e) {
                System.err.println("Error loading config: " + e.getMessage());
            }
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Error saving config: " + e.getMessage());
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("peepochat.json");
    }
}

