/*
 * Decompiled with CFR 0.152.
 */
package su.plo.replayvoice;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.replaymod.recording.ReplayModRecording;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.security.KeyPair;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_745;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import su.plo.replayvoice.CameraUtil;
import su.plo.replayvoice.ReplayTimeSupplier;
import su.plo.replayvoice.network.ClientNetworkHandler;
import su.plo.replayvoice.network.CodecManager;
import su.plo.replayvoice.network.DummyUdpClient;
import su.plo.replayvoice.network.NetworkHelper;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.AddonLoaderScope;
import su.plo.voice.api.addon.ClientAddonsLoader;
import su.plo.voice.api.addon.InjectPlasmoVoice;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureEvent;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureInitializeEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceWriteEvent;
import su.plo.voice.api.client.event.audio.source.AudioSourceResetEvent;
import su.plo.voice.api.client.event.connection.ConnectionKeyPairGenerateEvent;
import su.plo.voice.api.client.event.connection.UdpClientPacketReceivedEvent;
import su.plo.voice.api.client.event.connection.UdpClientPacketSendEvent;
import su.plo.voice.api.client.event.render.HudActivationRenderEvent;
import su.plo.voice.api.client.event.render.VoiceDistanceRenderEvent;
import su.plo.voice.api.client.event.socket.UdpClientClosedEvent;
import su.plo.voice.api.client.event.socket.UdpClientConnectEvent;
import su.plo.voice.api.client.socket.UdpClient;
import su.plo.voice.api.client.time.SystemTimeSupplier;
import su.plo.voice.api.client.time.TimeSupplier;
import su.plo.voice.api.event.EventCancellable;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.clientbound.SelfAudioInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;
import xyz.breadloaf.replaymodinterface.ReplayInterface;

@Addon(id="pv-addon-replaymod", scope=AddonLoaderScope.CLIENT, version="2.1.2", authors={"Apehum"})
public class ReplayVoiceAddon
implements ClientModInitializer,
AddonInitializer {
    public static ReplayVoiceAddon INSTANCE = new ReplayVoiceAddon();
    public static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 SELF_AUDIO_PACKET = class_2960.method_12829((String)"plasmo:voice/v2/self_audio");
    public static final class_2960 SELF_AUDIO_INFO_PACKET = class_2960.method_12829((String)"plasmo:voice/v2/self_audio_info");
    public static final class_2960 SOURCE_AUDIO_PACKET = class_2960.method_12829((String)"plasmo:voice/v2/source_audio");
    public static final class_2960 KEYPAIR_PACKET = class_2960.method_12829((String)"plasmo:voice/v2/keypair");
    private final class_310 minecraft = class_310.method_1551();
    @InjectPlasmoVoice
    public PlasmoVoiceClient voiceClient;

    public void onAddonInitialize() {
        ClientNetworkHandler network = new ClientNetworkHandler(this.voiceClient);
        ClientPlayNetworking.registerGlobalReceiver(CodecManager.getCodec(SOURCE_AUDIO_PACKET).getType(), (payload, context) -> network.handleSourceAudioPacket(payload.data()));
        ClientPlayNetworking.registerGlobalReceiver(CodecManager.getCodec(SELF_AUDIO_INFO_PACKET).getType(), (payload, context) -> network.handleSelfAudioInfoPacket(payload.data()));
        ClientPlayNetworking.registerGlobalReceiver(CodecManager.getCodec(SELF_AUDIO_PACKET).getType(), (payload, context) -> network.handleSelfAudioPacket(payload.data()));
        ClientPlayNetworking.registerGlobalReceiver(CodecManager.getCodec(KEYPAIR_PACKET).getType(), (payload, context) -> network.handleKeyPairPacket(payload.data()));
    }

    public void onInitializeClient() {
        INSTANCE = this;
        ClientAddonsLoader.INSTANCE.load((Object)this);
    }

    @EventSubscribe
    public void onDistanceRender(@NotNull VoiceDistanceRenderEvent event) {
        if (!ReplayInterface.INSTANCE.isInReplayEditor || event.isCancelled()) {
            return;
        }
        if (!CameraUtil.isReplayRecorder()) {
            event.setCancelled(true);
        }
    }

    @EventSubscribe
    public void onAudioCapture(@NotNull AudioCaptureEvent event) {
        if (!ReplayInterface.INSTANCE.isInReplayEditor) {
            return;
        }
        event.setCancelled(true);
    }

    @EventSubscribe
    public void onHudActivationRender(@NotNull HudActivationRenderEvent event) {
        if (!ReplayInterface.INSTANCE.isInReplayEditor || event.isRender()) {
            return;
        }
        if (!CameraUtil.isReplayRecorder()) {
            return;
        }
        class_745 player = (class_745)class_310.method_1551().method_1560();
        boolean isActivated = this.voiceClient.getSourceManager().getAllSelfSourceInfos().stream().filter(sourceInfo -> sourceInfo.getSelfSourceInfo().getPlayerId().equals(player.method_5667()) && sourceInfo.getSelfSourceInfo().getActivationId().equals(event.getActivation().getId())).anyMatch(sourceInfo -> this.voiceClient.getSourceManager().getSourceById(sourceInfo.getSelfSourceInfo().getSourceInfo().getId()).map(ClientAudioSource::isActivated).orElse(false));
        event.setRender(isActivated);
    }

    @EventSubscribe
    public void onSourceAudioPacketReceived(@NotNull UdpClientPacketReceivedEvent event) {
        if (!ReplayInterface.INSTANCE.isReplayModActive()) {
            return;
        }
        if (event.getPacket() instanceof SourceAudioPacket) {
            this.record(SOURCE_AUDIO_PACKET, event.getPacket());
        } else if (event.getPacket() instanceof SelfAudioInfoPacket) {
            this.record(SELF_AUDIO_INFO_PACKET, event.getPacket());
        }
    }

    @EventSubscribe
    public void onSourceWrite(@NotNull AlSourceWriteEvent event) {
        event.getSource().getDevice().runInContextAsync(() -> event.getSource().setPitch((float)ReplayInterface.getCurrentSpeed()));
    }

    @EventSubscribe
    public void onUdpPacketSend(@NotNull UdpClientPacketSendEvent event) {
        if (!ReplayInterface.INSTANCE.isReplayModActive() || this.minecraft.field_1724 == null || !(event.getPacket() instanceof PlayerAudioPacket)) {
            return;
        }
        PlayerAudioPacket packet = (PlayerAudioPacket)event.getPacket();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        try {
            packet.write(out);
        }
        catch (IOException e) {
            LOGGER.error("Failed tto encode packet", (Throwable)e);
            return;
        }
        ReplayModRecording.instance.getConnectionEventHandler().getPacketListener().save(NetworkHelper.createS2CPacket(SELF_AUDIO_PACKET, out.toByteArray()));
    }

    @EventSubscribe
    public void onEncryptionInitialize(@NotNull ConnectionKeyPairGenerateEvent event) {
        if (!ReplayInterface.INSTANCE.isReplayModActive()) {
            return;
        }
        KeyPair keyPair = event.getKeyPair();
        byte[] publicKey = keyPair.getPublic().getEncoded();
        byte[] privateKey = keyPair.getPrivate().getEncoded();
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_53002(publicKey.length);
        buf.method_52983(publicKey);
        buf.method_53002(privateKey.length);
        buf.method_52983(privateKey);
        ReplayModRecording.instance.getConnectionEventHandler().getPacketListener().save(NetworkHelper.createS2CPacket(KEYPAIR_PACKET, ByteBufUtil.getBytes((ByteBuf)buf)));
    }

    @EventSubscribe
    public void onUdpClientConnect(@NotNull UdpClientConnectEvent event) {
        if (!ReplayInterface.INSTANCE.isInReplayEditor) {
            return;
        }
        this.voiceClient.setTimeSupplier((TimeSupplier)new ReplayTimeSupplier());
        DummyUdpClient udpClient = new DummyUdpClient(this.voiceClient, event.getConnectionPacket().getSecret());
        this.voiceClient.getEventBus().register((Object)this, (Object)udpClient);
        this.voiceClient.getUdpClientManager().setClient((UdpClient)udpClient);
        event.setCancelled(true);
    }

    @EventSubscribe
    public void onUdpClientDisconnect(@NotNull UdpClientClosedEvent event) {
        if (!(this.voiceClient.getTimeSupplier() instanceof ReplayTimeSupplier)) {
            return;
        }
        this.voiceClient.setTimeSupplier((TimeSupplier)new SystemTimeSupplier());
    }

    @EventSubscribe
    public void onAudioCaptureInitialize(@NotNull AudioCaptureInitializeEvent event) {
        this.cancelCaptureEvent((EventCancellable)event);
    }

    @EventSubscribe
    public void onSourceReset(@NotNull AudioSourceResetEvent event) {
        if (!ReplayInterface.INSTANCE.isInReplayEditor) {
            return;
        }
        if (!event.getCause().equals((Object)AudioSourceResetEvent.Cause.SOURCE_STOPPED)) {
            return;
        }
        event.setCancelled(true);
    }

    private boolean cancelCaptureEvent(@NotNull EventCancellable event) {
        if (event.isCancelled() || ReplayInterface.INSTANCE.isInReplayEditor) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    private void record(@NotNull class_2960 resourceLocation, @NotNull Packet<?> packet) {
        try {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            packet.write(out);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ReplayInterface.INSTANCE.sendFakePacket(resourceLocation, buf);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to serialize packet: {}", (Object)e.getMessage());
        }
    }
}

