/*
 * Decompiled with CFR 0.152.
 */
package su.plo.replayvoice.render;

import com.replaymod.lib.org.apache.commons.exec.CommandLine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import su.plo.replayvoice.ReplayVoiceAddon;

public final class FfmpegAudioWriter
implements AutoCloseable {
    @NotNull
    private final Process process;
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final OutputStream outputStream;

    public FfmpegAudioWriter(@NotNull String ffmpegCommand, @NotNull File outputFile, @NotNull String outputFormat, int sampleRate, int channels) {
        ArrayList<Object> commandArguments = new ArrayList<Object>();
        commandArguments.add("-y");
        commandArguments.add("-f s16le");
        commandArguments.add("-ar " + sampleRate);
        commandArguments.add("-ac " + channels);
        commandArguments.add("-i -");
        commandArguments.add("-c:a " + outputFormat);
        commandArguments.add(outputFile.getName());
        CharSequence[] commandLine = new CommandLine(ffmpegCommand).addArguments(String.join((CharSequence)" ", commandArguments), false).toStrings();
        ReplayVoiceAddon.LOGGER.info("Starting ffmpeg process: {}", (Object)String.join((CharSequence)" ", commandLine));
        try {
            this.process = new ProcessBuilder((String[])commandLine).directory(outputFile.getParentFile()).redirectErrorStream(true).start();
            this.inputStream = this.process.getInputStream();
            this.outputStream = this.process.getOutputStream();
        }
        catch (IOException e) {
            ReplayVoiceAddon.LOGGER.info("Failed to create ffmpeg process", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void write(byte[] samples) {
        try {
            this.outputStream.write(samples);
            byte[] available = new byte[this.inputStream.available()];
            this.inputStream.read(available);
        }
        catch (IOException e) {
            ReplayVoiceAddon.LOGGER.info("Failed to write to ffmpeg stdin", (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.outputStream.flush();
            this.outputStream.close();
            this.inputStream.close();
            this.process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            ReplayVoiceAddon.LOGGER.info("Failed to exit ffmpeg process", (Throwable)e);
        }
        this.process.destroy();
    }
}

