/*
 * Decompiled with CFR 0.152.
 */
package su.plo.replayvoice.network;

import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import su.plo.replayvoice.CameraUtil;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.clientbound.SelfAudioInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

public class ClientNetworkHandler {
    private static final int MAX_PACKETS = 50;
    private final PlasmoVoiceClient voiceClient;
    private final Map<Long, Integer> packetIndex = Maps.newHashMap();
    private final List<PlayerAudioPacket> packets = new ArrayList<PlayerAudioPacket>();
    private int currentPacketIndex = 0;

    public void handleKeyPairPacket(byte[] data) {
        ByteArrayDataInput buf = ByteStreams.newDataInput((byte[])data);
        byte[] publicKey = new byte[buf.readInt()];
        buf.readFully(publicKey);
        byte[] privateKey = new byte[buf.readInt()];
        buf.readFully(privateKey);
        this.voiceClient.getServerConnection().ifPresent(connection -> {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKey);
                PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKey);
                connection.setKeyPair(new KeyPair(keyFactory.generatePublic(publicKeySpec), keyFactory.generatePrivate(privateKeySpec)));
            }
            catch (Exception e) {
                LogManager.getLogger().error("Failed to generate RSA public key: {}", (Object)e.toString());
                e.printStackTrace();
            }
        });
    }

    public void handleSelfAudioPacket(byte[] data) {
        PlayerAudioPacket currentPacket;
        PlayerAudioPacket packet;
        try {
            packet = (PlayerAudioPacket)this.getPacket(data, PlayerAudioPacket.class);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return;
        }
        PlayerAudioPacket playerAudioPacket = currentPacket = this.packets.size() > this.currentPacketIndex ? this.packets.get(this.currentPacketIndex) : null;
        if (currentPacket != null) {
            this.packetIndex.remove(currentPacket.getSequenceNumber());
        }
        if (this.packets.size() > this.currentPacketIndex) {
            this.packets.set(this.currentPacketIndex, packet);
        } else {
            this.packets.add(packet);
        }
        this.packetIndex.put(packet.getSequenceNumber(), this.currentPacketIndex);
        this.currentPacketIndex = (this.currentPacketIndex + 1) % 50;
    }

    public void handleSelfAudioInfoPacket(byte[] data) {
        SelfAudioInfoPacket packet;
        try {
            packet = (SelfAudioInfoPacket)this.getPacket(data, SelfAudioInfoPacket.class);
        }
        catch (Exception ignored) {
            return;
        }
        boolean shouldPlay = this.voiceClient.getSourceManager().getSelfSourceInfo(packet.getSourceId()).map(selfSourceInfo -> {
            if (!CameraUtil.isReplayRecorder() && selfSourceInfo.getSelfSourceInfo().getSourceInfo() instanceof DirectSourceInfo) {
                return false;
            }
            if (this.voiceClient.getSourceManager().getSourceById(packet.getSourceId(), false).isPresent()) {
                return true;
            }
            this.voiceClient.getSourceManager().createOrUpdateSource(selfSourceInfo.getSelfSourceInfo().getSourceInfo());
            return true;
        }).orElse(true);
        this.voiceClient.getSourceManager().getSourceById(packet.getSourceId(), false).ifPresent(source -> {
            if (source.isActivated() && !shouldPlay) {
                source.closeAsync();
            } else if (!shouldPlay) {
                return;
            }
            Optional<byte[]> packetData = packet.getData();
            if (!packetData.isPresent()) {
                if (packet.getSequenceNumber() == 0L) {
                    return;
                }
                int index = this.packetIndex.getOrDefault(packet.getSequenceNumber(), -1);
                if (index == -1) {
                    return;
                }
                packetData = Optional.of(this.packets.get(index).getData());
            }
            packetData.ifPresent(bytes -> source.process(new SourceAudioPacket(packet.getSequenceNumber(), source.getSourceInfo().getState(), bytes, packet.getSourceId(), packet.getDistance())));
        });
    }

    public void handleSourceAudioPacket(byte[] data) {
        SourceAudioPacket packet;
        try {
            packet = (SourceAudioPacket)this.getPacket(data, SourceAudioPacket.class);
        }
        catch (Exception ignored) {
            return;
        }
        this.voiceClient.getSourceManager().getSourceById(packet.getSourceId()).ifPresent(source -> {
            if (source.getSourceInfo().getState() != packet.getSourceState()) {
                return;
            }
            source.process(packet);
        });
    }

    private <T extends Packet<?>> T getPacket(byte[] data, Class<?> packetClass) throws Exception {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        Packet packet = (Packet)packetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        packet.read(in);
        return (T)packet;
    }

    public ClientNetworkHandler(PlasmoVoiceClient voiceClient) {
        this.voiceClient = voiceClient;
    }
}

