/*
 * Decompiled with CFR 0.152.
 */
package su.plo.replayvoice.render;

import com.replaymod.render.rendering.VideoRenderer;
import java.io.File;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.openal.SOFTLoopback;
import su.plo.replayvoice.render.FfmpegAudioWriter;
import su.plo.replayvoice.render.VoiceAudioRender;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AlContextOutputDevice;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.util.AudioUtil;

public class LoopbackAudioRender
implements AutoCloseable {
    @NotNull
    private final PlasmoVoiceClient voiceClient;
    @NotNull
    private final VideoRenderer videoRenderer;
    private FfmpegAudioWriter writer;
    private int frameSize;
    private short[] shortsBuffer;
    private boolean initialized = false;

    public synchronized void render() {
        if (!this.initialized) {
            this.initializeWriter();
            return;
        }
        AlContextOutputDevice outputDevice = this.voiceClient.getDeviceManager().getOutputDevice().orElse(null);
        if (outputDevice == null) {
            return;
        }
        long devicePointer = outputDevice.getDevicePointer();
        outputDevice.runInContextBlocking(() -> {
            SOFTLoopback.alcRenderSamplesSOFT((long)devicePointer, (short[])this.shortsBuffer, (int)this.frameSize);
            this.writer.write(AudioUtil.shortsToBytes((short[])this.shortsBuffer));
        });
    }

    @Override
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            return;
        }
        this.writer.close();
    }

    private void initializeWriter() {
        ServerInfo serverInfo = this.voiceClient.getServerInfo().orElse(null);
        if (serverInfo == null) {
            return;
        }
        VoiceAudioRender.reloadDevice();
        File outputVideoFile = this.videoRenderer.getRenderSettings().getOutputFile();
        File outputFolder = outputVideoFile.getParentFile();
        String[] outputFileNameSplit = outputVideoFile.getName().split("\\.");
        String outputFileName = String.join((CharSequence)".", Arrays.copyOf(outputFileNameSplit, outputFileNameSplit.length - 1)) + "-voice.aac";
        String ffmpegCommand = this.videoRenderer.getRenderSettings().getExportCommandOrDefault();
        int sampleRate = serverInfo.getVoiceInfo().getCaptureInfo().getSampleRate();
        int fps = this.videoRenderer.getRenderSettings().getFramesPerSecond();
        this.frameSize = sampleRate / fps;
        int channels = 2;
        this.shortsBuffer = new short[this.frameSize * channels];
        this.writer = new FfmpegAudioWriter(ffmpegCommand, new File(outputFolder, outputFileName), "aac", sampleRate, channels);
        this.initialized = true;
    }

    public LoopbackAudioRender(@NotNull PlasmoVoiceClient voiceClient, @NotNull VideoRenderer videoRenderer) {
        if (voiceClient == null) {
            throw new NullPointerException("voiceClient is marked non-null but is null");
        }
        if (videoRenderer == null) {
            throw new NullPointerException("videoRenderer is marked non-null but is null");
        }
        this.voiceClient = voiceClient;
        this.videoRenderer = videoRenderer;
    }
}

