/*
 * Decompiled with CFR 0.152.
 */
package xyz.breadloaf.replaymodinterface;

import com.replaymod.extras.ReplayModExtras;
import com.replaymod.extras.playeroverview.PlayerOverview;
import com.replaymod.pathing.properties.TimestampProperty;
import com.replaymod.recording.ReplayModRecording;
import com.replaymod.render.rendering.VideoRenderer;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replaystudio.pathing.impl.TimelineImpl;
import com.replaymod.replaystudio.pathing.path.Keyframe;
import com.replaymod.replaystudio.pathing.path.Path;
import com.replaymod.replaystudio.pathing.path.Timeline;
import com.replaymod.replaystudio.pathing.property.Property;
import com.replaymod.simplepathing.ReplayModSimplePathing;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import su.plo.replayvoice.network.NetworkHelper;
import xyz.breadloaf.replaymodinterface.mixin.accessor.ConnectionEventHandlerAccessor;
import xyz.breadloaf.replaymodinterface.mixin.accessor.GuiPathingAccessor;

public class ReplayInterface
implements ClientModInitializer {
    public static Logger logger = LogManager.getLogger((String)"ReplayInterface");
    public static ReplayInterface INSTANCE;
    public boolean isInReplayEditor;
    @Nullable
    public ReplayHandler replayHandler;
    public boolean skipping;
    public boolean isRendering;
    @Nullable
    public VideoRenderer videoRenderer;

    public ReplayInterface() {
        if (INSTANCE == null) {
            INSTANCE = this;
        }
    }

    public void onInitializeClient() {
    }

    public boolean isReplayModActive() {
        return ((ConnectionEventHandlerAccessor)ReplayModRecording.instance.getConnectionEventHandler()).getRecordingEventHandler() != null;
    }

    public void sendFakePacket(class_2960 resourceLocation, class_2540 packetData) {
        this.sendFakePacket(NetworkHelper.createS2CPacket(resourceLocation, ByteBufUtil.getBytes((ByteBuf)packetData)));
    }

    public void sendFakePacket(class_2596<?> packet) {
        if (ReplayModRecording.instance.getConnectionEventHandler() != null) {
            ReplayModRecording.instance.getConnectionEventHandler().getPacketListener().save(packet);
        }
    }

    public boolean isPlayerHidden(UUID uuid) {
        Optional playerOverview = ReplayModExtras.instance.get(PlayerOverview.class);
        return playerOverview.map(overview -> overview.isHidden(uuid)).orElse(false);
    }

    public static double getCurrentSpeed() {
        ReplayHandler replayHandler = ReplayInterface.INSTANCE.replayHandler;
        if (replayHandler == null) {
            return 1.0;
        }
        if (replayHandler.getReplaySender().isAsyncMode()) {
            return replayHandler.getReplaySender().getReplaySpeed();
        }
        Timeline tl = ReplayModSimplePathing.instance.getCurrentTimeline().getTimeline();
        if (!(tl instanceof TimelineImpl)) {
            return 1.0;
        }
        TimelineImpl timeline = (TimelineImpl)tl;
        if (!(ReplayModSimplePathing.instance.getGuiPathing() instanceof GuiPathingAccessor)) {
            return 1.0;
        }
        GuiPathingAccessor guiPathingAccessor = (GuiPathingAccessor)ReplayModSimplePathing.instance.getGuiPathing();
        long currentRealtime = ReplayInterface.INSTANCE.isRendering ? (long)ReplayInterface.INSTANCE.videoRenderer.getVideoTime() : guiPathingAccessor.getPlayer().getTimePassed();
        List paths = timeline.getPaths();
        for (Path path : paths) {
            Collection keyframes = path.getKeyframes();
            TimeKeyframe last = null;
            for (Keyframe keyframe : keyframes) {
                Optional value = keyframe.getValue((Property)TimestampProperty.PROPERTY);
                if (!value.isPresent()) continue;
                long realtimeKeyframe = keyframe.getTime();
                long mcKeyframe = ((Integer)value.get()).intValue();
                TimeKeyframe current = new TimeKeyframe(realtimeKeyframe, mcKeyframe);
                if (realtimeKeyframe >= currentRealtime) {
                    if (last == null) {
                        return 0.0;
                    }
                    double mcDuration = mcKeyframe - last.mcKeyframe;
                    double realtimeDuration = realtimeKeyframe - last.realtimeKeyframe;
                    return mcDuration / realtimeDuration;
                }
                last = current;
            }
        }
        return 1.0;
    }

    public static class TimeKeyframe {
        long realtimeKeyframe;
        long mcKeyframe;

        public TimeKeyframe(long realtimeKeyframe, long mcKeyframe) {
            this.realtimeKeyframe = realtimeKeyframe;
            this.mcKeyframe = mcKeyframe;
        }
    }
}

