/*
 * Decompiled with CFR 0.152.
 */
package com.outrightwings.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.outrightwings.data.FeatureData;
import com.outrightwings.data.SaplingOverrides;
import com.outrightwings.growth.TreeOverrideFinder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.slf4j.Logger;

public class SingleTreeDataReloadListener
extends class_4080<SaplingOverrides>
implements IdentifiableResourceReloadListener {
    protected String directory = "sapling_overrides/single";
    private final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();

    protected SaplingOverrides prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        SaplingOverrides saplingOverrides = new SaplingOverrides();
        for (Map.Entry entry : resourceManager.method_14488(this.directory, location -> location.method_12832().endsWith(".json")).entrySet()) {
            class_2960 resourcelocation = (class_2960)entry.getKey();
            String s = resourcelocation.method_12832();
            String[] parts = s.split("/");
            String namespace = parts[2];
            String saplingName = parts[3].replace(".json", "");
            class_2960 saplingLocation = new class_2960(namespace, saplingName);
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    JsonObject json = (JsonObject)class_3518.method_15276((Gson)this.gson, (Reader)reader, JsonObject.class);
                    if (json != null) {
                        boolean replace = json.get("replace").getAsBoolean();
                        HashMap<String, FeatureData> biomeFeatureMap = new HashMap<String, FeatureData>();
                        for (Map.Entry jentry : json.get("values").getAsJsonObject().entrySet()) {
                            ArrayList<String> features = new ArrayList<String>();
                            ArrayList<Integer> weights = new ArrayList<Integer>();
                            String biomeID = (String)jentry.getKey();
                            JsonElement value = (JsonElement)jentry.getValue();
                            if (value.isJsonArray()) {
                                JsonArray jsonArray = value.getAsJsonArray();
                                for (JsonElement element : jsonArray) {
                                    JsonObject object = element.getAsJsonObject();
                                    features.add(object.get("feature").getAsString());
                                    weights.add(object.get("weight").getAsInt());
                                }
                            } else if (value.isJsonPrimitive()) {
                                features.add(((JsonElement)jentry.getValue()).getAsString());
                                weights.add(1);
                            }
                            FeatureData data = new FeatureData(features, weights);
                            biomeFeatureMap.put(biomeID, data);
                        }
                        if (replace) {
                            saplingOverrides.put(saplingLocation.toString(), biomeFeatureMap);
                            continue;
                        }
                        Map<String, FeatureData> previous = saplingOverrides.getBiomeFeaturesOfSapling(saplingLocation.toString());
                        if (previous != null) {
                            previous.putAll(biomeFeatureMap);
                            continue;
                        }
                        saplingOverrides.put(saplingLocation.toString(), biomeFeatureMap);
                        continue;
                    }
                    LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)saplingLocation, (Object)resourcelocation);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{saplingLocation, resourcelocation, jsonparseexception});
            }
        }
        return saplingOverrides;
    }

    protected void apply(SaplingOverrides data, class_3300 resourceManager, class_3695 profilerFiller) {
        TreeOverrideFinder.initSingle(data);
    }

    public class_2960 getFabricId() {
        return new class_2960("treeplacer:single_tree_data");
    }
}

