/*
 * Decompiled with CFR 0.152.
 */
package net.bagaja.simpletimer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.storage.LevelResource;

public class TimeTracker {
    public static long currentWorldTicks = 0L;
    public static int userColor = 0xFFAA00;
    public static float userScale = 1.0f;
    public static int userXOffset = 0;
    public static int userYOffset = 0;
    private static boolean hasClipboard = false;
    private static int clipColor;
    private static float clipScale;
    private static int clipX;
    private static int clipY;
    private static String serverIP;
    private static final String MP_FILENAME = "simpletimer_servers.properties";
    private static final Properties mpDataStore;

    public static void tick() {
        if (Minecraft.m_91087_().f_91074_ != null && !Minecraft.m_91087_().m_91104_()) {
            ++currentWorldTicks;
        }
    }

    public static void copySettings() {
        clipColor = userColor;
        clipScale = userScale;
        clipX = userXOffset;
        clipY = userYOffset;
        hasClipboard = true;
    }

    public static void pasteSettings() {
        if (!hasClipboard) {
            return;
        }
        userColor = clipColor;
        userScale = clipScale;
        userXOffset = clipX;
        userYOffset = clipY;
        TimeTracker.save();
    }

    public static boolean hasClipboardData() {
        return hasClipboard;
    }

    public static void resetSettings() {
        userColor = 0xFFAA00;
        userScale = 1.0f;
        userXOffset = 0;
        userYOffset = 0;
        TimeTracker.save();
    }

    public static void reset() {
        currentWorldTicks = 0L;
        serverIP = "menu";
    }

    public static void loadWorldData() {
        currentWorldTicks = 0L;
        userScale = 1.0f;
        userXOffset = 0;
        userYOffset = 0;
        userColor = 0xFFAA00;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91092_() != null) {
            Path worldPath = mc.m_91092_().m_129843_(LevelResource.f_78182_).resolve("simpletimer_data.txt");
            if (Files.exists(worldPath, new LinkOption[0])) {
                try {
                    String content = Files.readString(worldPath);
                    TimeTracker.parseDataString(content);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (mc.m_91089_() != null) {
            TimeTracker.loadMpData();
            serverIP = mc.m_91089_().f_105363_.replaceAll("[^a-zA-Z0-9.-]", "_");
            String data = mpDataStore.getProperty("data_" + serverIP, "");
            if (!data.isEmpty()) {
                TimeTracker.parseDataString(data);
            }
        }
    }

    public static void save() {
        Minecraft mc = Minecraft.m_91087_();
        String data = currentWorldTicks + ":" + userColor + ":" + userScale + ":" + userXOffset + ":" + userYOffset;
        if (mc.m_91092_() != null) {
            try {
                Path worldPath = mc.m_91092_().m_129843_(LevelResource.f_78182_).resolve("simpletimer_data.txt");
                Files.writeString(worldPath, (CharSequence)data, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (mc.m_91089_() != null && !serverIP.equals("menu")) {
            mpDataStore.setProperty("data_" + serverIP, data);
            TimeTracker.saveMpData();
        }
    }

    private static void parseDataString(String content) {
        try {
            String[] parts = content.trim().split(":");
            currentWorldTicks = Long.parseLong(parts[0]);
            if (parts.length > 1) {
                userColor = Integer.parseInt(parts[1]);
            }
            if (parts.length > 2) {
                userScale = Float.parseFloat(parts[2]);
            }
            if (parts.length > 3) {
                userXOffset = Integer.parseInt(parts[3]);
            }
            if (parts.length > 4) {
                userYOffset = Integer.parseInt(parts[4]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void loadMpData() {
        block8: {
            try {
                Path path = Paths.get(MP_FILENAME, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) break block8;
                try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
                    mpDataStore.load(input);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void saveMpData() {
        try {
            Path path = Paths.get(MP_FILENAME, new String[0]);
            try (OutputStream output = Files.newOutputStream(path, new OpenOption[0]);){
                mpDataStore.store(output, "SimpleTimer Server Data");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getFormattedTime() {
        long totalSeconds = currentWorldTicks / 20L;
        long h = totalSeconds / 3600L;
        long m = totalSeconds % 3600L / 60L;
        long s = totalSeconds % 60L;
        if (h == 0L) {
            return String.format("%02d:%02d", m, s);
        }
        return String.format("%02d:%02d:%02d", h, m, s);
    }

    static {
        serverIP = "menu";
        mpDataStore = new Properties();
    }
}

