/*
 * Decompiled with CFR 0.152.
 */
package net.bagaja.simpletimer;

import java.util.function.Consumer;
import net.bagaja.simpletimer.TimeTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class TimerScreen
extends Screen {
    public TimerScreen() {
        super((Component)Component.m_237113_((String)"Timer Settings"));
    }

    protected void m_7856_() {
        this.m_169413_();
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 5;
        int color = TimeTracker.userColor;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        this.m_142416_((GuiEventListener)new SettingSlider(centerX - 100, startY, 200, 20, "Red", r, 0, 255, val -> this.updateColor((int)val, -1, -1)));
        this.m_142416_((GuiEventListener)new SettingSlider(centerX - 100, startY + 24, 200, 20, "Green", g, 0, 255, val -> this.updateColor(-1, (int)val, -1)));
        this.m_142416_((GuiEventListener)new SettingSlider(centerX - 100, startY + 48, 200, 20, "Blue", b, 0, 255, val -> this.updateColor(-1, -1, (int)val)));
        int posStartY = startY + 80;
        this.m_142416_((GuiEventListener)new SettingSlider(centerX - 100, posStartY, 200, 20, "Size", (int)(TimeTracker.userScale * 10.0f), 5, 30, val -> {
            TimeTracker.userScale = (float)val.intValue() / 10.0f;
            TimeTracker.save();
        }));
        this.m_142416_((GuiEventListener)new SettingSlider(centerX - 100, posStartY + 24, 200, 20, "Position X", TimeTracker.userXOffset, -200, 200, val -> {
            TimeTracker.userXOffset = val;
            TimeTracker.save();
        }));
        this.m_142416_((GuiEventListener)new SettingSlider(centerX - 100, posStartY + 48, 200, 20, "Position Y", TimeTracker.userYOffset, -200, 200, val -> {
            TimeTracker.userYOffset = val;
            TimeTracker.save();
        }));
        int clipboardY = this.f_96544_ - 55;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Copy Settings"), btn -> {
            TimeTracker.copySettings();
            this.m_7856_();
        }).m_252987_(centerX - 105, clipboardY, 100, 20).m_253136_());
        Button pasteBtn = Button.m_253074_((Component)Component.m_237113_((String)"Paste Settings"), btn -> {
            TimeTracker.pasteSettings();
            this.m_7856_();
        }).m_252987_(centerX + 5, clipboardY, 100, 20).m_253136_();
        pasteBtn.f_93623_ = TimeTracker.hasClipboardData();
        this.m_142416_((GuiEventListener)pasteBtn);
        int bottomY = this.f_96544_ - 30;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset Defaults"), btn -> {
            TimeTracker.resetSettings();
            this.m_7856_();
        }).m_252987_(centerX - 105, bottomY, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close & Save"), btn -> this.m_7379_()).m_252987_(centerX + 5, bottomY, 100, 20).m_253136_());
    }

    private void updateColor(int newR, int newG, int newB) {
        int color = TimeTracker.userColor;
        int r = newR == -1 ? color >> 16 & 0xFF : newR;
        int g = newG == -1 ? color >> 8 & 0xFF : newG;
        int b = newB == -1 ? color & 0xFF : newB;
        TimeTracker.userColor = r << 16 | g << 8 | b;
        TimeTracker.save();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        int previewX = this.f_96543_ / 2 + 110;
        int previewY = this.f_96544_ / 5;
        guiGraphics.m_280509_(previewX - 2, previewY - 2, previewX + 32, previewY + 70, -1);
        guiGraphics.m_280509_(previewX - 1, previewY - 1, previewX + 31, previewY + 69, -16777216);
        int fullAlphaColor = 0xFF000000 | TimeTracker.userColor;
        guiGraphics.m_280509_(previewX, previewY, previewX + 30, previewY + 68, fullAlphaColor);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    static class SettingSlider
    extends AbstractSliderButton {
        private final String label;
        private final int min;
        private final int max;
        private final Consumer<Integer> onApply;

        public SettingSlider(int x, int y, int width, int height, String label, int currentVal, int min, int max, Consumer<Integer> onApply) {
            super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
            this.label = label;
            this.min = min;
            this.max = max;
            this.onApply = onApply;
            if (currentVal < min) {
                currentVal = min;
            }
            if (currentVal > max) {
                currentVal = max;
            }
            this.f_93577_ = (double)(currentVal - min) / (double)(max - min);
            this.m_5695_();
        }

        protected void m_5695_() {
            int val = (int)((double)this.min + this.f_93577_ * (double)(this.max - this.min));
            if (this.label.equals("Size")) {
                this.m_93666_((Component)Component.m_237113_((String)(this.label + ": " + (float)val / 10.0f + "x")));
            } else {
                this.m_93666_((Component)Component.m_237113_((String)(this.label + ": " + val)));
            }
        }

        protected void m_5697_() {
            int val = (int)((double)this.min + this.f_93577_ * (double)(this.max - this.min));
            this.onApply.accept(val);
        }
    }
}

