/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.devices.CondenserManager;
import org.Little_100.projecte.devices.EnergyCollector;
import org.Little_100.projecte.devices.EnergyCollectorGUI;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EnergyCollectorManager {
    private final ProjectE plugin;
    private final Map<String, CollectorData> collectors = new ConcurrentHashMap<String, CollectorData>();
    private final Map<UUID, String> openCollectors = new HashMap<UUID, String>();

    public EnergyCollectorManager(ProjectE plugin) {
        this.plugin = plugin;
        this.startEmcGeneration();
    }

    public void addCollector(Location location, UUID ownerUUID, int type, UUID armorStandUUID) {
        String locationKey = EnergyCollectorManager.getLocationKey(location);
        CollectorData data = new CollectorData(ownerUUID, armorStandUUID, type);
        long savedEmc = this.plugin.getDatabaseManager().loadCollectorEmc(locationKey);
        ItemStack[] savedInventory = this.plugin.getDatabaseManager().loadCollectorInventory(locationKey, EnergyCollector.getInventorySize(type));
        data.storedEmc = savedEmc;
        data.inventory = savedInventory;
        this.collectors.put(locationKey, data);
        this.plugin.getDatabaseManager().saveCollectorData(locationKey, ownerUUID, type, data.storedEmc, data.inventory);
    }

    public void removeCollector(Location location) {
        String locationKey = EnergyCollectorManager.getLocationKey(location);
        CollectorData data = this.collectors.remove(locationKey);
        if (data != null) {
            this.plugin.getDatabaseManager().saveCollectorData(locationKey, data.ownerUUID, data.type, data.storedEmc, data.inventory);
        }
        this.plugin.getDatabaseManager().deleteCollectorData(locationKey);
    }

    public void openCollectorGUI(Player player, Location location) {
        String locationKey = EnergyCollectorManager.getLocationKey(location);
        CollectorData data = this.collectors.get(locationKey);
        if (data == null) {
            int type = this.plugin.getDatabaseManager().loadCollectorType(locationKey);
            UUID owner = this.plugin.getDatabaseManager().getCollectorOwner(locationKey);
            if (owner != null) {
                data = new CollectorData(owner, null, type);
                data.storedEmc = this.plugin.getDatabaseManager().loadCollectorEmc(locationKey);
                data.inventory = this.plugin.getDatabaseManager().loadCollectorInventory(locationKey, EnergyCollector.getInventorySize(type));
                this.collectors.put(locationKey, data);
            } else {
                return;
            }
        }
        this.openCollectors.put(player.getUniqueId(), locationKey);
        EnergyCollectorGUI gui = new EnergyCollectorGUI(this.plugin, player, location, data);
        gui.open();
    }

    public void closeCollectorGUI(Player player, long storedEmc, ItemStack[] inventory) {
        CollectorData data;
        UUID playerUUID = player.getUniqueId();
        String locationKey = this.openCollectors.remove(playerUUID);
        if (locationKey != null && (data = this.collectors.get(locationKey)) != null) {
            data.storedEmc = storedEmc;
            data.inventory = inventory;
            this.plugin.getDatabaseManager().saveCollectorData(locationKey, data.ownerUUID, data.type, storedEmc, inventory);
        }
    }

    public boolean isCollectorOpen(Player player) {
        return this.openCollectors.containsKey(player.getUniqueId());
    }

    private void startEmcGeneration() {
        this.plugin.getSchedulerAdapter().runTimer(() -> {
            for (Map.Entry<String, CollectorData> entry : this.collectors.entrySet()) {
                String locationKey = entry.getKey();
                CollectorData data = entry.getValue();
                try {
                    Location location = this.parseLocationKey(locationKey);
                    if (location == null || location.getWorld() == null || !location.getWorld().isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4)) continue;
                    this.plugin.getSchedulerAdapter().runTaskAt(location, () -> {
                        try {
                            Block aboveBlock = location.getBlock().getRelative(0, 1, 0);
                            byte lightLevel = aboveBlock.getLightLevel();
                            long baseEmcRate = EnergyCollector.getEmcRate(data.type);
                            double lightMultiplier = Math.max(0.1, (double)lightLevel / 15.0);
                            long emcGenerated = (long)((double)baseEmcRate * lightMultiplier);
                            data.storedEmc += emcGenerated;
                            this.transferEmcToAdjacentCondensers(location, data);
                            this.processItemUpgrades(data);
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Error generating EMC for collector at " + locationKey + ": " + e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error processing collector at " + locationKey + ": " + e.getMessage());
                }
            }
            if (System.currentTimeMillis() % 60000L < 1000L) {
                this.saveAllCollectors();
            }
        }, 20L, 20L);
    }

    private void processItemUpgrades(CollectorData data) {
    }

    private void transferEmcToAdjacentCondensers(Location location, CollectorData data) {
        BlockFace[] faces;
        if (data.storedEmc <= 0L) {
            return;
        }
        Block block = location.getBlock();
        for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
            Block adjacent = block.getRelative(face);
            if (adjacent.getType() != Material.BEACON) continue;
            Location adjacentLocation = adjacent.getLocation();
            CondenserManager.CondenserState condenserState = this.plugin.getCondenserManager().getCondenserState(adjacentLocation);
            if (condenserState == null) continue;
            condenserState.addEmc(data.storedEmc);
            data.storedEmc = 0L;
            return;
        }
    }

    private void saveAllCollectors() {
        for (Map.Entry<String, CollectorData> entry : this.collectors.entrySet()) {
            String locationKey = entry.getKey();
            CollectorData data = entry.getValue();
            this.plugin.getDatabaseManager().saveCollectorData(locationKey, data.ownerUUID, data.type, data.storedEmc, data.inventory);
        }
    }

    public void shutdown() {
        this.saveAllCollectors();
        this.plugin.getLogger().info("Energy Collector Manager shutdown complete. Saved " + this.collectors.size() + " collectors.");
    }

    public static String getLocationKey(Location location) {
        return location.getWorld().getName() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    private Location parseLocationKey(String locationKey) {
        try {
            String[] parts = locationKey.split(",");
            if (parts.length != 4) {
                return null;
            }
            return new Location(this.plugin.getServer().getWorld(parts[0]), (double)Integer.parseInt(parts[1]), (double)Integer.parseInt(parts[2]), (double)Integer.parseInt(parts[3]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class CollectorData {
        public UUID ownerUUID;
        public UUID armorStandUUID;
        public int type;
        public long storedEmc;
        public ItemStack[] inventory;

        public CollectorData(UUID ownerUUID, UUID armorStandUUID, int type) {
            this.ownerUUID = ownerUUID;
            this.armorStandUUID = armorStandUUID;
            this.type = type;
            this.storedEmc = 0L;
            this.inventory = new ItemStack[EnergyCollector.getInventorySize(type)];
        }
    }
}

