/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.gui.ToolChargeGUI;
import org.Little_100.projecte.tools.ToolManager;
import org.Little_100.projecte.util.Constants;
import org.Little_100.projecte.util.InventoryViewHelper;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ToolChargeGUIListener
implements Listener {
    private final ProjectE plugin;

    public ToolChargeGUIListener(ProjectE plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int oldCharge;
        int newCharge;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory clickedInventory = event.getClickedInventory();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedInventory == null || clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        String expectedTitle = this.plugin.getLanguageManager().get("clientside.tool_charge_gui.title");
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[DEBUG] GUI\u70b9\u51fb\u4e8b\u4ef6\u89e6\u53d1\uff0c\u6807\u9898: " + InventoryViewHelper.getTitle((InventoryEvent)event) + ", \u671f\u671b: " + expectedTitle);
        }
        if (!InventoryViewHelper.getTitle((InventoryEvent)event).equals(expectedTitle)) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[DEBUG] \u786e\u8ba4\u662f\u5de5\u5177\u754c\u9762\uff0c\u53d6\u6d88\u4e8b\u4ef6");
        }
        event.setCancelled(true);
        ItemMeta clickedMeta = clickedItem.getItemMeta();
        if (clickedMeta == null) {
            return;
        }
        PersistentDataContainer clickedContainer = clickedMeta.getPersistentDataContainer();
        ItemStack tool = player.getInventory().getItemInMainHand();
        ToolManager toolManager = this.plugin.getToolManager();
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[DEBUG] \u70b9\u51fb\u7684\u7269\u54c1meta keys: " + String.valueOf(clickedContainer.getKeys()));
            this.plugin.getLogger().info("[DEBUG] \u624b\u6301\u5de5\u5177: " + String.valueOf(tool != null ? tool.getType() : "null"));
        }
        if (!toolManager.isProjectETool(tool)) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[DEBUG] \u624b\u6301\u7269\u54c1\u4e0d\u662fProjectE\u5de5\u5177\uff0c\u8df3\u8fc7");
            }
            return;
        }
        ItemMeta toolMeta = tool.getItemMeta();
        if (toolMeta == null) {
            return;
        }
        PersistentDataContainer toolContainer = toolMeta.getPersistentDataContainer();
        if (clickedContainer.has(Constants.CHARGE_LEVEL_KEY, PersistentDataType.INTEGER) && (newCharge = ((Integer)clickedContainer.getOrDefault(Constants.CHARGE_LEVEL_KEY, PersistentDataType.INTEGER, (Object)0)).intValue()) != (oldCharge = ((Integer)toolContainer.getOrDefault(Constants.CHARGE_KEY, PersistentDataType.INTEGER, (Object)0)).intValue())) {
            if (toolManager.isDarkMatterShovel(tool) && newCharge > 1) {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            toolContainer.set(Constants.CHARGE_KEY, PersistentDataType.INTEGER, (Object)newCharge);
            tool.setItemMeta(toolMeta);
            this.updateDurability(tool, newCharge);
            toolManager.updateToolEfficiency(tool);
            if (toolManager.isRedMatterHammer(tool)) {
                toolManager.updateHammerAttackDamage(tool);
            }
            if (toolManager.isDarkMatterSword(tool) || toolManager.isRedMatterSword(tool)) {
                toolManager.updateSwordAttackDamage(tool);
            }
            if (toolManager.isRedMatterKatar(tool)) {
                toolManager.updateKatarAttackDamage(tool);
            }
            if (newCharge > oldCharge) {
                player.playSound(player.getLocation(), "projecte:custom.pecharge", 1.0f, 1.0f);
            } else {
                player.playSound(player.getLocation(), "projecte:custom.peuncharge", 1.0f, 1.0f);
            }
            new ToolChargeGUI(this.plugin, player, tool).open();
            player.getInventory().setItemInMainHand(tool);
        }
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[DEBUG] \u68c0\u67e5\u662f\u5426\u6709KATAR_MODE_KEY: " + clickedContainer.has(Constants.KATAR_MODE_KEY, PersistentDataType.INTEGER));
            this.plugin.getLogger().info("[DEBUG] \u662f\u5426\u662f\u62f3\u5251: " + toolManager.isRedMatterKatar(tool));
        }
        if (clickedContainer.has(Constants.KATAR_MODE_KEY, PersistentDataType.INTEGER)) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[DEBUG] \u68c0\u6d4b\u5230\u62f3\u5251\u6a21\u5f0f\u5207\u6362\u70b9\u51fb");
            }
            int newMode = (Integer)clickedContainer.get(Constants.KATAR_MODE_KEY, PersistentDataType.INTEGER);
            int oldMode = (Integer)toolContainer.getOrDefault(Constants.KATAR_MODE_KEY, PersistentDataType.INTEGER, (Object)0);
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[DEBUG] \u5f53\u524d\u6a21\u5f0f: " + oldMode + ", \u65b0\u6a21\u5f0f: " + newMode);
            }
            if (newMode != oldMode) {
                if (this.plugin.getConfig().getBoolean("debug")) {
                    this.plugin.getLogger().info("[DEBUG] \u6a21\u5f0f\u4e0d\u540c\uff0c\u5f00\u59cb\u5207\u6362");
                }
                toolContainer.set(Constants.KATAR_MODE_KEY, PersistentDataType.INTEGER, (Object)newMode);
                tool.setItemMeta(toolMeta);
                toolManager.updateLore(tool);
                toolManager.updateKatarAttackDamage(tool);
                player.getInventory().setItemInMainHand(tool);
                String modeName = newMode == 0 ? this.plugin.getLanguageManager().get("clientside.red_matter_katar.mode_all") : this.plugin.getLanguageManager().get("clientside.red_matter_katar.mode_hostile");
                player.sendMessage(this.plugin.getLanguageManager().get("clientside.red_matter_katar.mode_prefix") + " " + modeName);
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.5f);
                new ToolChargeGUI(this.plugin, player, player.getInventory().getItemInMainHand()).open();
            }
        }
    }

    private void updateDurability(ItemStack tool, int newCharge) {
        ItemMeta meta = tool.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return;
        }
        Damageable damageable = (Damageable)meta;
        ToolManager toolManager = this.plugin.getToolManager();
        short maxDurability = tool.getType().getMaxDurability();
        int newDamage = 0;
        if (toolManager.isRedMatterTool(tool)) {
            switch (newCharge) {
                case 0: {
                    newDamage = maxDurability - 2;
                    break;
                }
                case 1: {
                    newDamage = maxDurability * 2 / 3;
                    break;
                }
                case 2: {
                    newDamage = maxDurability / 3;
                    break;
                }
                case 3: {
                    newDamage = maxDurability / 4;
                    break;
                }
                case 4: {
                    newDamage = 1;
                }
            }
        } else {
            switch (newCharge) {
                case 0: {
                    newDamage = maxDurability - 2;
                    break;
                }
                case 1: {
                    newDamage = maxDurability / 2;
                    break;
                }
                case 2: {
                    newDamage = 1;
                }
            }
        }
        damageable.setDamage(newDamage);
        tool.setItemMeta(meta);
        toolManager.updateLore(tool);
    }
}

