/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.tools;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.managers.EmcManager;
import org.Little_100.projecte.util.Constants;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.Little_100.projecte.util.ItemUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DiviningRod {
    private final ProjectE plugin;
    private final NamespacedKey lowKey;
    private final NamespacedKey mediumKey;
    private final NamespacedKey highKey;
    private ItemStack lowDiviningRod;
    private ItemStack mediumDiviningRod;
    private ItemStack highDiviningRod;

    public DiviningRod(ProjectE plugin) {
        this.plugin = plugin;
        this.lowKey = new NamespacedKey((Plugin)plugin, "low_divining_rod");
        this.mediumKey = new NamespacedKey((Plugin)plugin, "medium_divining_rod");
        this.highKey = new NamespacedKey((Plugin)plugin, "high_divining_rod");
        this.createDiviningRodItems();
    }

    private void createDiviningRodItems() {
        this.lowDiviningRod = this.createDiviningRodItem("item.low_divining_rod.name", 1, List.of("item.low_divining_rod.lore1", "item.low_divining_rod.lore2"), this.lowKey, "low_divining_rod");
        this.mediumDiviningRod = this.createDiviningRodItem("item.medium_divining_rod.name", 2, List.of("item.medium_divining_rod.lore1", "item.medium_divining_rod.lore2"), this.mediumKey, "medium_divining_rod");
        this.highDiviningRod = this.createDiviningRodItem("item.high_divining_rod.name", 3, List.of("item.high_divining_rod.lore1", "item.high_divining_rod.lore2"), this.highKey, "high_divining_rod");
    }

    private ItemStack createDiviningRodItem(String displayNameKey, int customModelData, List<String> loreKeys, NamespacedKey key, String id) {
        ItemStack item = new ItemStack(Material.STICK);
        ItemMeta meta = (item = CustomModelDataUtil.setCustomModelDataBoth(item, id, customModelData)).getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get(displayNameKey));
            List translatedLore = loreKeys.stream().map(this.plugin.getLanguageManager()::get).collect(Collectors.toList());
            meta.setLore(translatedLore);
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(Constants.ID_KEY, PersistentDataType.STRING, (Object)id);
            container.set(key, PersistentDataType.BYTE, (Object)1);
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack getLowDiviningRod() {
        return this.lowDiviningRod.clone();
    }

    public ItemStack getMediumDiviningRod() {
        return this.mediumDiviningRod.clone();
    }

    public ItemStack getHighDiviningRod() {
        return this.highDiviningRod.clone();
    }

    public void setDiviningRodEmcValues() {
        EmcManager emcManager = this.plugin.getEmcManager();
        File configFile = new File(this.plugin.getDataFolder(), "custommoditememc.yml");
        if (!configFile.exists()) {
            this.plugin.getLogger().warning("custommoditememc.yml not found, custom divining rod EMC values will not be loaded.");
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        String lowKey = emcManager.getItemKey(this.getLowDiviningRod());
        long lowEmc = config.getLong("low_divining_rod", 12L);
        emcManager.registerEmc(lowKey, lowEmc);
        String mediumKey = emcManager.getItemKey(this.getMediumDiviningRod());
        long mediumEmc = config.getLong("medium_divining_rod", 68L);
        emcManager.registerEmc(mediumKey, mediumEmc);
        String highKey = emcManager.getItemKey(this.getHighDiviningRod());
        long highEmc = config.getLong("high_divining_rod", 1668L);
        emcManager.registerEmc(highKey, highEmc);
    }

    public boolean isLowDiviningRod(ItemStack item) {
        return ItemUtils.isProjectEItem(item, "low_divining_rod");
    }

    public boolean isMediumDiviningRod(ItemStack item) {
        return ItemUtils.isProjectEItem(item, "medium_divining_rod");
    }

    public boolean isHighDiviningRod(ItemStack item) {
        return ItemUtils.isProjectEItem(item, "high_divining_rod");
    }
}

