/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.accessories;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.Little_100.projecte.accessories.BodyStone;
import org.Little_100.projecte.accessories.LifeStone;
import org.Little_100.projecte.accessories.MindStone;
import org.Little_100.projecte.accessories.SoulStone;
import org.Little_100.projecte.util.Constants;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class AccessoryListener
implements Listener {
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player;
        ItemStack item;
        if (event.getRightClicked().getType() == EntityType.HORSE && this.isAccessory(item = (player = event.getPlayer()).getInventory().getItem(event.getHand()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        long cooldownTime;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || !event.getAction().name().contains("RIGHT_CLICK")) {
            return;
        }
        String id = this.getAccessoryId(item);
        if (id == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < (cooldownTime = this.cooldowns.getOrDefault(player.getUniqueId(), 0L).longValue())) {
            return;
        }
        switch (id) {
            case "body_stone": {
                BodyStone.activate(player, item);
                break;
            }
            case "soul_stone": {
                SoulStone.activate(player, item);
                break;
            }
            case "life_stone": {
                LifeStone.activate(player, item);
                break;
            }
            case "mind_stone": {
                MindStone.activate(player, item);
            }
        }
        this.cooldowns.put(player.getUniqueId(), now + 250L);
    }

    private String getAccessoryId(ItemStack item) {
        String id;
        NamespacedKey key;
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer data = meta.getPersistentDataContainer();
        if (data.has(key = Constants.ID_KEY, PersistentDataType.STRING) && ("body_stone".equals(id = (String)data.get(key, PersistentDataType.STRING)) || "soul_stone".equals(id) || "life_stone".equals(id) || "mind_stone".equals(id))) {
            return id;
        }
        return null;
    }

    private boolean isAccessory(ItemStack item) {
        return this.getAccessoryId(item) != null;
    }
}

