/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.devices.AlchemicalChestGUI;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AlchemicalChestManager {
    private final ProjectE plugin;
    private final Map<String, UUID> chestOwners = new HashMap<String, UUID>();
    private final Map<UUID, String> openChests = new HashMap<UUID, String>();

    public AlchemicalChestManager(ProjectE plugin) {
        this.plugin = plugin;
    }

    public void addChest(Location location, UUID ownerUUID) {
        String locationKey = AlchemicalChestManager.getLocationKey(location);
        this.chestOwners.put(locationKey, ownerUUID);
        ItemStack[] existingContents = this.plugin.getDatabaseManager().loadChestInventory(locationKey);
        this.plugin.getDatabaseManager().saveChestInventory(locationKey, ownerUUID, existingContents);
    }

    public void removeChest(Location location) {
        String locationKey = AlchemicalChestManager.getLocationKey(location);
        this.chestOwners.remove(locationKey);
        this.plugin.getDatabaseManager().deleteChestInventory(locationKey);
    }

    public void openChestGUI(Player player, Location location) {
        String locationKey = AlchemicalChestManager.getLocationKey(location);
        this.openChests.put(player.getUniqueId(), locationKey);
        ItemStack[] contents = this.plugin.getDatabaseManager().loadChestInventory(locationKey);
        AlchemicalChestGUI gui = new AlchemicalChestGUI(this.plugin, player, location, contents);
        gui.open();
    }

    public void closeChestGUI(Player player, ItemStack[] contents) {
        UUID playerUUID = player.getUniqueId();
        String locationKey = this.openChests.remove(playerUUID);
        if (locationKey != null) {
            UUID ownerUUID = this.chestOwners.get(locationKey);
            if (ownerUUID == null && (ownerUUID = this.plugin.getDatabaseManager().getChestOwner(locationKey)) == null) {
                ownerUUID = playerUUID;
            }
            this.plugin.getDatabaseManager().saveChestInventory(locationKey, ownerUUID, contents);
        }
    }

    public boolean isChestOpen(Player player) {
        return this.openChests.containsKey(player.getUniqueId());
    }

    public String getOpenChestLocation(Player player) {
        return this.openChests.get(player.getUniqueId());
    }

    public static String getLocationKey(Location location) {
        return location.getWorld().getName() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    public void loadChestData() {
    }

    public void saveAllChests() {
    }
}

