/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import java.util.HashSet;
import java.util.Iterator;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class ServerLoadListener
implements Listener {
    private final ProjectE plugin;

    public ServerLoadListener(ProjectE plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onServerLoad(ServerLoadEvent event) {
        if (event.getType() != ServerLoadEvent.LoadType.STARTUP) {
            return;
        }
        this.plugin.getLogger().info("Server fully loaded. Recalculating EMC for PDC items...");
        this.plugin.getSchedulerAdapter().runTaskLater(() -> {
            try {
                this.recalculatePdcItemsEmc();
                this.plugin.getLogger().info("PDC items EMC recalculation completed.");
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error during PDC items EMC recalculation: " + e.getMessage());
                e.printStackTrace();
            }
        }, 20L);
    }

    private void recalculatePdcItemsEmc() {
        int pdcRecipesFound = 0;
        boolean debug = this.plugin.getConfig().getBoolean("debug");
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            try {
                Recipe recipe = (Recipe)recipeIterator.next();
                if (recipe.getResult() == null || recipe.getResult().getType().isAir() || !this.plugin.getEmcManager().isPdcItem(recipe.getResult())) continue;
                ++pdcRecipesFound;
                if (!debug) continue;
                String itemKey = this.plugin.getEmcManager().getItemKey(recipe.getResult());
                this.plugin.getLogger().info("[PDC Recipe Found] " + itemKey);
            }
            catch (Exception recipe) {}
        }
        if (pdcRecipesFound > 0) {
            this.plugin.getLogger().info("Found " + pdcRecipesFound + " PDC recipes. Starting EMC calculation...");
            HashSet<String> calculatedItems = new HashSet<String>();
            for (int i = 0; i < 5; ++i) {
                this.plugin.getLogger().info("PDC EMC calculation iteration " + (i + 1) + "...");
                boolean changed = false;
                recipeIterator = Bukkit.recipeIterator();
                while (recipeIterator.hasNext()) {
                    try {
                        Recipe recipe = (Recipe)recipeIterator.next();
                        if (recipe.getResult() == null || recipe.getResult().getType().isAir() || !this.plugin.getEmcManager().isPdcItem(recipe.getResult())) continue;
                        String itemKey = this.plugin.getEmcManager().getItemKey(recipe.getResult());
                        long oldEmc = this.plugin.getDatabaseManager().getEmc(itemKey);
                        long recipeEmc = this.plugin.getVersionAdapter().calculateRecipeEmc(recipe, this.plugin.getConfig().getString("TransmutationTable.EMC.divisionStrategy", "floor"));
                        if (debug && recipeEmc == 0L && oldEmc == 0L) {
                            this.plugin.getLogger().warning("[PDC EMC Debug] Cannot calculate EMC for: " + itemKey);
                            this.plugin.getLogger().warning("  Recipe type: " + recipe.getClass().getSimpleName());
                            if (recipe instanceof ShapedRecipe) {
                                this.plugin.getLogger().warning("  Ingredients:");
                                ShapedRecipe shaped = (ShapedRecipe)recipe;
                                for (ItemStack ingredient : shaped.getIngredientMap().values()) {
                                    if (ingredient == null || ingredient.getType().isAir()) continue;
                                    ingKey = this.plugin.getEmcManager().getItemKey(ingredient);
                                    ingEmc = this.plugin.getDatabaseManager().getEmc(ingKey);
                                    this.plugin.getLogger().warning("    - " + ingKey + ": " + ingEmc + " EMC");
                                }
                            } else if (recipe instanceof ShapelessRecipe) {
                                this.plugin.getLogger().warning("  Ingredients:");
                                ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
                                for (ItemStack ingredient : shapeless.getIngredientList()) {
                                    if (ingredient == null || ingredient.getType().isAir()) continue;
                                    ingKey = this.plugin.getEmcManager().getItemKey(ingredient);
                                    ingEmc = this.plugin.getDatabaseManager().getEmc(ingKey);
                                    this.plugin.getLogger().warning("    - " + ingKey + ": " + ingEmc + " EMC");
                                }
                            }
                        }
                        if (recipeEmc <= 0L) continue;
                        String strategy = this.plugin.getConfig().getString("TransmutationTable.EMC.recipeConflictStrategy", "lowest");
                        boolean shouldUpdate = false;
                        if (oldEmc <= 0L) {
                            shouldUpdate = true;
                        } else if ("lowest".equals(strategy) && recipeEmc < oldEmc) {
                            shouldUpdate = true;
                        } else if ("highest".equals(strategy) && recipeEmc > oldEmc) {
                            shouldUpdate = true;
                        }
                        if (!shouldUpdate) continue;
                        this.plugin.getDatabaseManager().setEmc(itemKey, recipeEmc);
                        changed = true;
                        calculatedItems.add(itemKey);
                        if (!debug) continue;
                        this.plugin.getLogger().info("[PDC EMC Calculated] " + itemKey + " = " + recipeEmc + " EMC");
                    }
                    catch (Exception recipe) {}
                }
                if (changed) continue;
                this.plugin.getLogger().info("PDC EMC values stabilized, calculation ended early.");
                break;
            }
            this.plugin.getLogger().info("PDC items EMC calculation completed. " + calculatedItems.size() + " unique items calculated.");
            int uncalculatedCount = 0;
            recipeIterator = Bukkit.recipeIterator();
            while (recipeIterator.hasNext()) {
                try {
                    Recipe recipe = (Recipe)recipeIterator.next();
                    if (recipe.getResult() == null || recipe.getResult().getType().isAir() || !this.plugin.getEmcManager().isPdcItem(recipe.getResult())) continue;
                    String itemKey = this.plugin.getEmcManager().getItemKey(recipe.getResult());
                    long emc = this.plugin.getDatabaseManager().getEmc(itemKey);
                    if (emc > 0L) continue;
                    ++uncalculatedCount;
                    if (!debug) continue;
                    this.plugin.getLogger().warning("[PDC EMC] Item without EMC: " + itemKey);
                }
                catch (Exception exception) {}
            }
            if (uncalculatedCount > 0) {
                this.plugin.getLogger().warning("Warning: " + uncalculatedCount + " PDC items still don't have EMC values.");
                this.plugin.getLogger().warning("This may be due to missing ingredient EMC or circular dependencies.");
                if (!debug) {
                    this.plugin.getLogger().warning("Enable debug mode in config.yml to see which items are affected.");
                }
            }
        } else {
            this.plugin.getLogger().info("No PDC recipes found. Skipping PDC EMC calculation.");
        }
    }
}

