/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.Little_100.projecte.EmcManager;
import org.Little_100.projecte.LanguageManager;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.TransmutationTable.NoEmcItemGUI;
import org.Little_100.projecte.TransmutationTable.TransmutationGUI;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.StringUtil;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final ProjectE plugin;
    private final Map<String, Map<String, String>> openTableCommands = new HashMap<String, Map<String, String>>();
    private final DatabaseManager databaseManager;
    private final EmcManager emcManager;
    private final LanguageManager languageManager;

    public CommandManager(ProjectE plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
        this.emcManager = plugin.getEmcManager();
        this.languageManager = plugin.getLanguageManager();
        this.loadCommands();
    }

    private void loadCommands() {
        YamlConfiguration commandsConfig;
        File commandsFile = new File(this.plugin.getDataFolder(), "command.yml");
        if (!commandsFile.exists()) {
            this.plugin.saveResource("command.yml", false);
        }
        if ((commandsConfig = YamlConfiguration.loadConfiguration((File)commandsFile)).isConfigurationSection("OpenTransmutationTable")) {
            for (String key : commandsConfig.getConfigurationSection("OpenTransmutationTable").getKeys(false)) {
                String command = commandsConfig.getString("OpenTransmutationTable." + key + ".command").replace("/", "");
                String permission = commandsConfig.getString("OpenTransmutationTable." + key + ".permission");
                String permissionMessage = commandsConfig.getString("OpenTransmutationTable." + key + ".permission-message");
                HashMap<String, String> commandData = new HashMap<String, String>();
                commandData.put("permission", permission);
                commandData.put("permission-message", permissionMessage);
                this.openTableCommands.put(command, commandData);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String commandName = command.getName().toLowerCase();
        String[] newArgs = args;
        if (this.openTableCommands.containsKey(commandName)) {
            return this.handleOpenTable(sender, commandName);
        }
        if (command.getName().equalsIgnoreCase("projecte")) {
            if (args.length == 0) {
                this.sendHelp(sender);
                return true;
            }
            String subCommand = args[0].toLowerCase();
            String fullCommand = "projecte " + subCommand;
            if (this.openTableCommands.containsKey(fullCommand)) {
                return this.handleOpenTable(sender, fullCommand);
            }
            switch (subCommand) {
                case "reload": {
                    return this.handleReload(sender);
                }
                case "setemc": {
                    return this.handleSetEmc(sender, args);
                }
                case "debug": {
                    return this.handleDebug(sender);
                }
                case "give": {
                    return this.handleGiveEmc(sender, args);
                }
                case "noemcitem": {
                    return this.handleNoEmcItem(sender);
                }
                case "bag": {
                    return this.handleBag(sender, args);
                }
                case "lang": {
                    return this.handleLang(sender, args);
                }
                case "report": {
                    return this.handleReport(sender);
                }
                case "nbtdebug": {
                    return this.handleNbtDebug(sender);
                }
                case "guitest": {
                    return this.handleGuiTest(sender, args);
                }
            }
            this.sendHelp(sender);
            return true;
        }
        return false;
    }

    private boolean handleOpenTable(CommandSender sender, String commandName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        Player player = (Player)sender;
        Map<String, String> commandData = this.openTableCommands.get(commandName);
        String permission = commandData.get("permission");
        if (!(permission.equalsIgnoreCase("default") || player.hasPermission("projecte.command." + permission) || permission.equalsIgnoreCase("op") && player.isOp())) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)commandData.get("permission-message")));
            return true;
        }
        new TransmutationGUI(player).open();
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.languageManager.get("serverside.command.help.header"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.reload"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.setemc"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.give"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.debug"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.noemcitem"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.bag_list"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.lang"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.report"));
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("projecte.command.reload")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        this.plugin.reloadPlugin();
        sender.sendMessage(this.languageManager.get("serverside.command.reload_success"));
        return true;
    }

    private boolean handleSetEmc(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        if (!sender.hasPermission("projecte.command.setemc")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        if (args.length != 2) {
            sender.sendMessage(this.languageManager.get("serverside.command.set_emc.usage"));
            return true;
        }
        Player player = (Player)sender;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType().isAir()) {
            sender.sendMessage(this.languageManager.get("serverside.command.set_emc.hold_item"));
            return true;
        }
        try {
            long emc = Long.parseLong(args[1]);
            if (emc <= 0L) {
                sender.sendMessage(this.languageManager.get("serverside.command.set_emc.must_be_positive"));
                return true;
            }
            String itemKey = this.plugin.getVersionAdapter().getItemKey(itemInHand);
            this.databaseManager.setEmc(itemKey, emc);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", itemKey);
            placeholders.put("emc", String.valueOf(emc));
            sender.sendMessage(this.languageManager.get("serverside.command.set_emc.success", placeholders));
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("value", args[1]);
            sender.sendMessage(this.languageManager.get("serverside.command.set_emc.invalid_value", placeholders));
        }
        return true;
    }

    private boolean handleDebug(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        if (!sender.hasPermission("projecte.command.debug")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        Player player = (Player)sender;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType().isAir()) {
            sender.sendMessage(this.languageManager.get("serverside.command.set_emc.hold_item"));
            return true;
        }
        String itemKey = this.plugin.getVersionAdapter().getItemKey(itemInHand);
        long emc = this.emcManager.getEmc(itemKey);
        boolean learned = this.databaseManager.isLearned(player.getUniqueId(), itemKey);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("item", itemKey);
        sender.sendMessage(this.languageManager.get("serverside.command.debug.header", placeholders));
        placeholders.put("emc", String.valueOf(emc));
        sender.sendMessage(this.languageManager.get("serverside.command.debug.emc_value", placeholders));
        placeholders.put("learned", learned ? "Yes" : "No");
        sender.sendMessage(this.languageManager.get("serverside.command.debug.is_learned", placeholders));
        List recipes = Bukkit.getRecipesFor((ItemStack)itemInHand);
        if (recipes.isEmpty()) {
            sender.sendMessage(this.languageManager.get("serverside.command.debug.no_recipe"));
        } else {
            placeholders.put("count", String.valueOf(recipes.size()));
            sender.sendMessage(this.languageManager.get("serverside.command.debug.recipe_found", placeholders));
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                HashMap<String, String> recipePlaceholders = new HashMap<String, String>();
                recipePlaceholders.put("index", String.valueOf(i + 1));
                sender.sendMessage(this.languageManager.get("serverside.command.debug.recipe_header", recipePlaceholders));
                String divisionStrategy = this.plugin.getConfig().getString("TransmutationTable.EMC.divisionStrategy", "floor").toLowerCase();
                List<String> debugInfo = this.plugin.getVersionAdapter().getRecipeDebugInfo(recipe, divisionStrategy);
                for (String line : debugInfo) {
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + line);
                }
            }
        }
        sender.sendMessage(this.languageManager.get("serverside.command.debug.footer"));
        return true;
    }

    private boolean handleGiveEmc(CommandSender sender, String[] args) {
        long amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        if (!sender.hasPermission("projecte.command.give")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        if (args.length != 3) {
            sender.sendMessage(this.languageManager.get("serverside.command.give_emc.usage"));
            return true;
        }
        Player senderPlayer = (Player)sender;
        Player targetPlayer = Bukkit.getPlayer((String)args[1]);
        if (targetPlayer == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", args[1]);
            sender.sendMessage(this.languageManager.get("serverside.command.give_emc.player_not_found", placeholders));
            return true;
        }
        if (targetPlayer.equals((Object)senderPlayer)) {
            sender.sendMessage(this.languageManager.get("serverside.command.give_emc.cant_give_self"));
            return true;
        }
        try {
            amount = Long.parseLong(args[2]);
            if (amount <= 0L) {
                sender.sendMessage(this.languageManager.get("serverside.command.give_emc.must_be_positive"));
                return true;
            }
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", args[2]);
            sender.sendMessage(this.languageManager.get("serverside.command.give_emc.invalid_amount", placeholders));
            return true;
        }
        double feePercentage = this.plugin.getConfig().getDouble("TransmutationTable.transfer-fee-percentage", 0.0);
        long fee = (long)((double)amount * (feePercentage / 100.0));
        long totalDeduction = amount + fee;
        long senderEmc = this.databaseManager.getPlayerEmc(senderPlayer.getUniqueId());
        if (senderEmc < totalDeduction) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("total", String.valueOf(totalDeduction));
            placeholders.put("fee", String.valueOf(fee));
            sender.sendMessage(this.languageManager.get("serverside.command.give_emc.not_enough_emc", placeholders));
            return true;
        }
        long targetEmc = this.databaseManager.getPlayerEmc(targetPlayer.getUniqueId());
        this.databaseManager.setPlayerEmc(senderPlayer.getUniqueId(), senderEmc - totalDeduction);
        this.databaseManager.setPlayerEmc(targetPlayer.getUniqueId(), targetEmc + amount);
        HashMap<String, String> senderPlaceholders = new HashMap<String, String>();
        senderPlaceholders.put("player", targetPlayer.getName());
        senderPlaceholders.put("amount", String.valueOf(amount));
        senderPlaceholders.put("fee", String.valueOf(fee));
        senderPlayer.sendMessage(this.languageManager.get("serverside.command.give_emc.give_success", senderPlaceholders));
        HashMap<String, String> targetPlaceholders = new HashMap<String, String>();
        targetPlaceholders.put("player", senderPlayer.getName());
        targetPlaceholders.put("amount", String.valueOf(amount));
        targetPlayer.sendMessage(this.languageManager.get("serverside.command.give_emc.receive_success", targetPlaceholders));
        return true;
    }

    private boolean handleNoEmcItem(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        if (!sender.hasPermission("projecte.command.noemcitem")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        Player player = (Player)sender;
        ArrayList<ItemStack> noEmcItems = new ArrayList<ItemStack>();
        for (Material material : Material.values()) {
            if (!material.isItem() || material.isAir() || material.name().startsWith("LEGACY_")) continue;
            ItemStack item = new ItemStack(material);
            String itemKey = this.plugin.getVersionAdapter().getItemKey(item);
            if (this.emcManager.getEmc(itemKey) != 0L) continue;
            noEmcItems.add(item);
        }
        if (noEmcItems.isEmpty()) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_emc_item.all_have_emc"));
            return true;
        }
        new NoEmcItemGUI(noEmcItems, 0).openInventory(player);
        return true;
    }

    private boolean handleBag(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        if (!sender.hasPermission("projecte.command.bag")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        if (args.length < 2 || !args[1].equalsIgnoreCase("list")) {
            sender.sendMessage(this.languageManager.get("serverside.command.bag.usage"));
            return true;
        }
        Player player = (Player)sender;
        List<String> bagColors = this.databaseManager.getBagColors(player.getUniqueId());
        if (bagColors.isEmpty()) {
            sender.sendMessage(this.languageManager.get("serverside.command.bag.no_bags"));
            return true;
        }
        sender.sendMessage(this.languageManager.get("serverside.command.bag.list_header"));
        for (String colorName : bagColors) {
            try {
                ChatColor chatColor = ChatColor.valueOf((String)colorName.toUpperCase());
                sender.sendMessage(String.valueOf(chatColor) + "- " + colorName);
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(String.valueOf(ChatColor.WHITE) + "- " + colorName);
            }
        }
        return true;
    }

    private boolean handleLang(CommandSender sender, String[] args) {
        if (!sender.hasPermission("projecte.command.lang")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.languageManager.get("serverside.command.lang.usage"));
            return true;
        }
        String action = args[1].toLowerCase();
        if (action.equals("list")) {
            sender.sendMessage(this.languageManager.get("serverside.command.lang.list_header"));
            File langFolder = this.plugin.getDataFolder();
            File[] files = langFolder.listFiles((dir, name) -> name.endsWith(".yml") && !name.equals("config.yml"));
            if (files != null) {
                for (File file : files) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "- " + file.getName().replace(".yml", ""));
                }
            }
            return true;
        }
        if (action.equals("set")) {
            if (args.length < 3) {
                sender.sendMessage(this.languageManager.get("serverside.command.lang.usage"));
                return true;
            }
            ArrayList<String> newLangs = new ArrayList<String>(Arrays.asList(args).subList(2, args.length));
            for (String lang : newLangs) {
                File langFile = new File(this.plugin.getDataFolder(), lang + ".yml");
                if (langFile.exists()) continue;
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("file", lang + ".yml");
                sender.sendMessage(this.languageManager.get("serverside.command.lang.file_not_found", placeholders));
                return true;
            }
            this.plugin.getConfig().set("language", newLangs);
            this.plugin.saveConfig();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("languages", String.join((CharSequence)", ", newLangs));
            sender.sendMessage(this.languageManager.get("serverside.command.lang.set_success", placeholders));
            return true;
        }
        sender.sendMessage(this.languageManager.get("serverside.command.lang.usage"));
        return true;
    }

    private boolean handleReport(CommandSender sender) {
        sender.sendMessage(this.languageManager.get("serverside.command.report.message"));
        return true;
    }

    private boolean handleNbtDebug(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be executed by a player.");
            return true;
        }
        Player player = (Player)sender;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType().isAir()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please hold an item in your hand to execute this command.");
            return true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ChatColor.AQUA).append("[NBT Debug]").append("\n");
        sb.append(ChatColor.GRAY).append("Type: ").append(item.getType().name()).append("\n");
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            sb.append(ChatColor.GRAY).append("DisplayName: ").append(meta.hasDisplayName() ? meta.getDisplayName() : "None").append("\n");
            sb.append(ChatColor.GRAY).append("Lore: ").append(meta.hasLore() ? meta.getLore() : "None").append("\n");
            if (meta.hasCustomModelData()) {
                try {
                    sb.append(ChatColor.GRAY).append("CustomModelData: ").append(meta.getCustomModelData()).append("\n");
                }
                catch (IllegalStateException e) {
                    sb.append(ChatColor.GRAY).append("CustomModelData: Exists but cannot be read (").append(e.getMessage()).append(")\n");
                }
            } else {
                sb.append(ChatColor.GRAY).append("CustomModelData: None\n");
            }
            sb.append(ChatColor.GRAY).append("PDC: ");
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            Set keys = pdc.getKeys();
            if (keys.isEmpty()) {
                sb.append("None\n");
            } else {
                sb.append("\n");
                for (NamespacedKey key : keys) {
                    sb.append("  - ").append(key.toString()).append(": ");
                    if (!(this.tryAppendPdcValue(sb, pdc, key, PersistentDataType.STRING, "String") || this.tryAppendPdcValue(sb, pdc, key, PersistentDataType.INTEGER, "Integer") || this.tryAppendPdcValue(sb, pdc, key, PersistentDataType.LONG, "Long") || this.tryAppendPdcValue(sb, pdc, key, PersistentDataType.DOUBLE, "Double") || this.tryAppendPdcValue(sb, pdc, key, PersistentDataType.FLOAT, "Float") || this.tryAppendPdcValue(sb, pdc, key, PersistentDataType.BYTE, "Byte") || this.tryAppendPdcValue(sb, pdc, key, PersistentDataType.SHORT, "Short"))) {
                        sb.append("Exists (unknown or complex type)");
                    }
                    sb.append("\n");
                }
            }
        } else {
            sb.append(ChatColor.GRAY).append("No ItemMeta\n");
        }
        player.sendMessage(sb.toString());
        return true;
    }

    private <T, Z> boolean tryAppendPdcValue(StringBuilder sb, PersistentDataContainer pdc, NamespacedKey key, PersistentDataType<T, Z> type, String typeName) {
        if (pdc.has(key, type)) {
            try {
                Object value = pdc.get(key, type);
                sb.append(value).append(" (").append(typeName).append(")");
                return true;
            }
            catch (Exception e) {
                sb.append("Error reading (").append(typeName).append("): ").append(e.getMessage());
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("projecte") && args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>(Arrays.asList("reload", "setemc", "debug", "give", "noemcitem", "bag", "lang", "report", "nbtdebug", "guitest"));
            for (String cmd : this.openTableCommands.keySet()) {
                if (!cmd.startsWith("projecte ")) continue;
                subCommands.add(cmd.split(" ")[1]);
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], subCommands, new ArrayList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("give")) {
                ArrayList<String> playerNames = new ArrayList<String>();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    playerNames.add(player.getName());
                }
                return (List)StringUtil.copyPartialMatches((String)args[1], playerNames, new ArrayList());
            }
            if (args[0].equalsIgnoreCase("bag")) {
                return (List)StringUtil.copyPartialMatches((String)args[1], Collections.singletonList("list"), new ArrayList());
            }
            if (args[0].equalsIgnoreCase("lang")) {
                return (List)StringUtil.copyPartialMatches((String)args[1], Arrays.asList("list", "set"), new ArrayList());
            }
            if (args[0].equalsIgnoreCase("guitest")) {
                return (List)StringUtil.copyPartialMatches((String)args[1], Collections.singletonList("<rows>"), new ArrayList());
            }
        }
        if (args.length >= 3 && args[0].equalsIgnoreCase("lang") && args[1].equalsIgnoreCase("set")) {
            ArrayList<String> langFiles = new ArrayList<String>();
            File langFolder = this.plugin.getDataFolder();
            File[] files = langFolder.listFiles((dir, name) -> name.endsWith(".yml") && !name.equals("config.yml"));
            if (files != null) {
                for (File file : files) {
                    langFiles.add(file.getName().replace(".yml", ""));
                }
            }
            return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], langFiles, new ArrayList());
        }
        return new ArrayList<String>();
    }

    private boolean handleGuiTest(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be executed by a player.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /projecte guitest <rows>");
            return true;
        }
        Player player = (Player)sender;
        try {
            int rows = Integer.parseInt(args[1]);
            int size = rows * 9;
            Inventory testGui = Bukkit.createInventory(null, (int)size, (String)("Test GUI (" + rows + " rows)"));
            player.openInventory(testGui);
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number: " + args[1]);
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Error creating GUI: " + e.getMessage());
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Hint: The size of a chest GUI must be a multiple of 9.");
        }
        return true;
    }
}

