/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.util.List;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.storage.DatabaseManager;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CovalenceDust {
    private final ProjectE plugin;
    private final boolean isModernVersion;
    private final NamespacedKey lowKey;
    private final NamespacedKey mediumKey;
    private final NamespacedKey highKey;
    private ItemStack lowCovalenceDust;
    private ItemStack mediumCovalenceDust;
    private ItemStack highCovalenceDust;

    public CovalenceDust(ProjectE plugin) {
        this.plugin = plugin;
        this.isModernVersion = this.isVersion1_21_4OrNewer();
        this.lowKey = new NamespacedKey((Plugin)plugin, "low_covalence_dust");
        this.mediumKey = new NamespacedKey((Plugin)plugin, "medium_covalence_dust");
        this.highKey = new NamespacedKey((Plugin)plugin, "high_covalence_dust");
        this.createCovalenceDustItems();
    }

    private boolean isVersion1_21_4OrNewer() {
        try {
            String version = Bukkit.getServer().getBukkitVersion().split("-")[0];
            String[] versionParts = version.split("\\.");
            if (versionParts.length >= 2) {
                int major = Integer.parseInt(versionParts[0]);
                int minor = Integer.parseInt(versionParts[1]);
                if (major > 1) {
                    return true;
                }
                if (major == 1 && minor > 21) {
                    return true;
                }
                if (major == 1 && minor == 21 && versionParts.length >= 3) {
                    int patch = Integer.parseInt(versionParts[2]);
                    return patch >= 4;
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not parse version number, using legacy mode: " + e.getMessage());
        }
        return false;
    }

    private void createCovalenceDustItems() {
        this.lowCovalenceDust = this.createCovalenceDustItem(Material.GLOWSTONE_DUST, "item.low_covalence_dust.name", 1, List.of("item.low_covalence_dust.lore1", "item.low_covalence_dust.lore2"), this.lowKey, "low_covalence_dust");
        this.mediumCovalenceDust = this.createCovalenceDustItem(Material.GLOWSTONE_DUST, "item.medium_covalence_dust.name", 2, List.of("item.medium_covalence_dust.lore1", "item.medium_covalence_dust.lore2"), this.mediumKey, "medium_covalence_dust");
        this.highCovalenceDust = this.createCovalenceDustItem(Material.GLOWSTONE_DUST, "item.high_covalence_dust.name", 3, List.of("item.high_covalence_dust.lore1", "item.high_covalence_dust.lore2"), this.highKey, "high_covalence_dust");
    }

    private ItemStack createCovalenceDustItem(Material material, String displayNameKey, int customModelData, List<String> loreKeys, NamespacedKey key, String id) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = (item = CustomModelDataUtil.setCustomModelData(item, customModelData)).getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get(displayNameKey));
            List<String> translatedLore = loreKeys.stream().map(this.plugin.getLanguageManager()::get).toList();
            meta.setLore(translatedLore);
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(key, PersistentDataType.BYTE, (Object)1);
            container.set(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING, (Object)id);
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack getLowCovalenceDust() {
        return this.lowCovalenceDust.clone();
    }

    public ItemStack getMediumCovalenceDust() {
        return this.mediumCovalenceDust.clone();
    }

    public ItemStack getHighCovalenceDust() {
        return this.highCovalenceDust.clone();
    }

    public void setCovalenceDustEmcValues() {
        DatabaseManager db = this.plugin.getDatabaseManager();
        File configFile = new File(this.plugin.getDataFolder(), "custommoditememc.yml");
        YamlConfiguration config = null;
        if (configFile.exists()) {
            config = YamlConfiguration.loadConfiguration((File)configFile);
            this.plugin.getLogger().info("Loaded custom EMC values from custommoditememc.yml");
        } else {
            this.plugin.getLogger().info("custommoditememc.yml not found, using default EMC values");
        }
        long lowEmc = config != null ? config.getLong("low_covalence_dust", 1L) : 1L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getLowCovalenceDust()), lowEmc);
        long mediumEmc = config != null ? config.getLong("medium_covalence_dust", 8L) : 8L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getMediumCovalenceDust()), mediumEmc);
        long highEmc = config != null ? config.getLong("high_covalence_dust", 208L) : 208L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getHighCovalenceDust()), highEmc);
    }

    public boolean isLowCovalenceDust(ItemStack item) {
        return this.isCovalenceDust(item, this.lowKey, "low_covalence_dust");
    }

    public boolean isMediumCovalenceDust(ItemStack item) {
        return this.isCovalenceDust(item, this.mediumKey, "medium_covalence_dust");
    }

    public boolean isHighCovalenceDust(ItemStack item) {
        return this.isCovalenceDust(item, this.highKey, "high_covalence_dust");
    }

    private boolean isCovalenceDust(ItemStack item, NamespacedKey key, String id) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        boolean hasKey = container.has(key, PersistentDataType.BYTE);
        boolean hasId = container.has(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING);
        String foundId = (String)container.get(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING);
        return hasKey && hasId && id.equals(foundId);
    }
}

