/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.Tools;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.Tools.Divining_Rod;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;

public class DiviningRodListener
implements Listener {
    private final ProjectE plugin;
    private final Divining_Rod diviningRod;
    private final Map<UUID, Integer> playerModes = new HashMap<UUID, Integer>();

    public DiviningRodListener(ProjectE plugin) {
        this.plugin = plugin;
        this.diviningRod = plugin.getDiviningRod();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        Action action = event.getAction();
        if (action == Action.RIGHT_CLICK_BLOCK && !player.isSneaking() && (this.diviningRod.isLowDiviningRod(item) || this.diviningRod.isMediumDiviningRod(item) || this.diviningRod.isHighDiviningRod(item))) {
            event.setCancelled(true);
            this.scanBlocks(player, item, event.getClickedBlock().getLocation());
        }
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        ItemStack item;
        Player player = event.getPlayer();
        if (player.isSneaking() && (this.diviningRod.isMediumDiviningRod(item = player.getInventory().getItemInMainHand()) || this.diviningRod.isHighDiviningRod(item))) {
            this.cycleScanMode(player, item);
        }
    }

    private void cycleScanMode(Player player, ItemStack item) {
        UUID playerUUID = player.getUniqueId();
        int currentMode = this.playerModes.getOrDefault(playerUUID, 0);
        int maxModes = 1;
        if (this.diviningRod.isMediumDiviningRod(item)) {
            maxModes = 2;
        } else if (this.diviningRod.isHighDiviningRod(item)) {
            maxModes = 3;
        }
        int nextMode = (currentMode + 1) % maxModes;
        this.playerModes.put(playerUUID, nextMode);
        String modeName = this.getModeName(nextMode);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Scan mode changed to: " + modeName);
    }

    private String getModeName(int mode) {
        switch (mode) {
            case 0: {
                return "3x3x3";
            }
            case 1: {
                return "16x3x3";
            }
            case 2: {
                return "64x3x3";
            }
        }
        return "Unknown";
    }

    private void scanBlocks(Player player, ItemStack item, Location center) {
        int mode = 0;
        mode = this.diviningRod.isLowDiviningRod(item) ? 0 : this.playerModes.getOrDefault(player.getUniqueId(), 0);
        int[] dimensions = this.getScanDimensions(mode);
        int halfX = dimensions[0] / 2;
        int halfY = dimensions[1] / 2;
        int halfZ = dimensions[2] / 2;
        long totalEmc = 0L;
        int blockCount = 0;
        for (int x = -halfX; x <= halfX; ++x) {
            for (int y = -halfY; y <= halfY; ++y) {
                for (int z = -halfZ; z <= halfZ; ++z) {
                    Block block = center.clone().add((double)x, (double)y, (double)z).getBlock();
                    if (block.getType() == Material.AIR) continue;
                    ItemStack blockStack = new ItemStack(block.getType());
                    String itemKey = this.plugin.getEmcManager().getItemKey(blockStack);
                    long emc = this.plugin.getEmcManager().getEmc(itemKey);
                    if (emc <= 0L) continue;
                    totalEmc += emc;
                    ++blockCount;
                }
            }
        }
        if (blockCount > 0) {
            long averageEmc = totalEmc / (long)blockCount;
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Scan Results:");
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Total Blocks: " + blockCount);
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Average EMC: " + averageEmc);
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No blocks with EMC found in the area.");
        }
    }

    private int[] getScanDimensions(int mode) {
        switch (mode) {
            case 0: {
                return new int[]{3, 3, 3};
            }
            case 1: {
                return new int[]{16, 3, 3};
            }
            case 2: {
                return new int[]{64, 3, 3};
            }
        }
        return new int[]{3, 3, 3};
    }
}

