/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.Tools;

import java.util.List;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.storage.DatabaseManager;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Divining_Rod {
    private final ProjectE plugin;
    private final NamespacedKey lowKey;
    private final NamespacedKey mediumKey;
    private final NamespacedKey highKey;
    private ItemStack lowDiviningRod;
    private ItemStack mediumDiviningRod;
    private ItemStack highDiviningRod;

    public Divining_Rod(ProjectE plugin) {
        this.plugin = plugin;
        this.lowKey = new NamespacedKey((Plugin)plugin, "low_divining_rod");
        this.mediumKey = new NamespacedKey((Plugin)plugin, "medium_divining_rod");
        this.highKey = new NamespacedKey((Plugin)plugin, "high_divining_rod");
        this.createDiviningRodItems();
    }

    private void createDiviningRodItems() {
        this.lowDiviningRod = this.createDiviningRodItem("item.low_divining_rod.name", 1, List.of("item.low_divining_rod.lore1", "item.low_divining_rod.lore2"), this.lowKey, "low_divining_rod");
        this.mediumDiviningRod = this.createDiviningRodItem("item.medium_divining_rod.name", 2, List.of("item.medium_divining_rod.lore1", "item.medium_divining_rod.lore2"), this.mediumKey, "medium_divining_rod");
        this.highDiviningRod = this.createDiviningRodItem("item.high_divining_rod.name", 3, List.of("item.high_divining_rod.lore1", "item.high_divining_rod.lore2"), this.highKey, "high_divining_rod");
    }

    private ItemStack createDiviningRodItem(String displayNameKey, int customModelData, List<String> loreKeys, NamespacedKey key, String id) {
        ItemStack item = new ItemStack(Material.STICK);
        ItemMeta meta = (item = CustomModelDataUtil.setCustomModelData(item, customModelData)).getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get(displayNameKey));
            List<String> translatedLore = loreKeys.stream().map(this.plugin.getLanguageManager()::get).toList();
            meta.setLore(translatedLore);
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(key, PersistentDataType.BYTE, (Object)1);
            container.set(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING, (Object)id);
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack getLowDiviningRod() {
        return this.lowDiviningRod.clone();
    }

    public ItemStack getMediumDiviningRod() {
        return this.mediumDiviningRod.clone();
    }

    public ItemStack getHighDiviningRod() {
        return this.highDiviningRod.clone();
    }

    public void setDiviningRodEmcValues() {
        DatabaseManager db = this.plugin.getDatabaseManager();
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getLowDiviningRod()), 12L);
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getMediumDiviningRod()), 76L);
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getHighDiviningRod()), 1740L);
    }

    public boolean isLowDiviningRod(ItemStack item) {
        return this.isDiviningRod(item, this.lowKey, "low_divining_rod");
    }

    public boolean isMediumDiviningRod(ItemStack item) {
        return this.isDiviningRod(item, this.mediumKey, "medium_divining_rod");
    }

    public boolean isHighDiviningRod(ItemStack item) {
        return this.isDiviningRod(item, this.highKey, "high_divining_rod");
    }

    private boolean isDiviningRod(ItemStack item, NamespacedKey key, String id) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        boolean hasKey = container.has(key, PersistentDataType.BYTE);
        boolean hasId = container.has(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING);
        String foundId = (String)container.get(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING);
        return hasKey && hasId && id.equals(foundId);
    }
}

