/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.util;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class CustomModelDataUtil {
    private static Boolean useNewApi = null;
    private static final Map<String, Integer> STRING_TO_INT_MAPPING = new HashMap<String, Integer>();
    private static final Map<Integer, String> INT_TO_STRING_MAPPING = new HashMap<Integer, String>();

    public static boolean isNewApiSupported() {
        if (useNewApi == null) {
            try {
                Class.forName("org.bukkit.inventory.meta.components.CustomModelDataComponent");
                useNewApi = true;
            }
            catch (ClassNotFoundException e) {
                useNewApi = false;
            }
        }
        return useNewApi;
    }

    public static ItemStack setCustomModelData(ItemStack item, String modelId) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        Integer intValue = STRING_TO_INT_MAPPING.get(modelId);
        if (intValue == null) {
            try {
                intValue = Integer.parseInt(modelId);
            }
            catch (NumberFormatException e) {
                intValue = 0;
            }
        }
        return CustomModelDataUtil.setCustomModelDataBoth(item, modelId, intValue);
    }

    public static ItemStack setCustomModelData(ItemStack item, int intValue) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        String modelId = INT_TO_STRING_MAPPING.getOrDefault(intValue, String.valueOf(intValue));
        return CustomModelDataUtil.setCustomModelDataBoth(item, modelId, intValue);
    }

    public static ItemStack setNewCustomModelData(ItemStack item, String modelId) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        try {
            CustomModelDataUtil.setNewApiModelData(meta, modelId);
            item.setItemMeta(meta);
        }
        catch (Exception e) {
            System.err.println("Failed to set new CustomModelData: " + e.getMessage());
        }
        return item;
    }

    public static ItemStack setOldCustomModelData(ItemStack item, int intValue) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        try {
            meta.setCustomModelData(Integer.valueOf(intValue));
            item.setItemMeta(meta);
        }
        catch (Exception e) {
            System.err.println("Failed to set old CustomModelData: " + e.getMessage());
        }
        return item;
    }

    private static void setNewApiModelData(ItemMeta meta, String modelId) {
        block12: {
            try {
                CustomModelDataComponent component = meta.getCustomModelDataComponent();
                if (component == null) {
                    component = CustomModelDataUtil.createCustomModelDataComponent(modelId);
                    if (component != null) {
                        meta.setCustomModelDataComponent(component);
                        break block12;
                    }
                    try {
                        Integer intValue = null;
                        if (meta.hasCustomModelData()) {
                            try {
                                intValue = meta.getCustomModelData();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        try {
                            Method setStringsMethod = meta.getClass().getMethod("setCustomModelDataStrings", List.class);
                            if (setStringsMethod != null) {
                                setStringsMethod.invoke((Object)meta, Collections.singletonList(modelId));
                            }
                            break block12;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unable to set CustomModelDataComponent: " + e.getMessage(), e);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to set CustomModelDataComponent: " + e.getMessage(), e);
                    }
                }
                component.setStrings(Collections.singletonList(modelId));
                meta.setCustomModelDataComponent(component);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set new API model data: " + e.getMessage(), e);
            }
        }
    }

    private static CustomModelDataComponent createCustomModelDataComponent(String modelId) {
        try {
            try {
                Method ofMethod = CustomModelDataComponent.class.getMethod("of", String.class);
                if (ofMethod != null) {
                    return (CustomModelDataComponent)ofMethod.invoke(null, modelId);
                }
            }
            catch (NoSuchMethodException ofMethod) {
                // empty catch block
            }
            try {
                Method stringsMethod = CustomModelDataComponent.class.getMethod("strings", List.class);
                if (stringsMethod != null) {
                    return (CustomModelDataComponent)stringsMethod.invoke(null, Collections.singletonList(modelId));
                }
            }
            catch (NoSuchMethodException stringsMethod) {
                // empty catch block
            }
            try {
                Method varargStringsMethod = CustomModelDataComponent.class.getMethod("strings", String[].class);
                if (varargStringsMethod != null) {
                    return (CustomModelDataComponent)varargStringsMethod.invoke(null, new Object[]{new String[]{modelId}});
                }
            }
            catch (NoSuchMethodException varargStringsMethod) {
                // empty catch block
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Failed to create CustomModelDataComponent: " + e.getMessage());
            return null;
        }
    }

    public static ItemStack setCustomModelDataBoth(ItemStack item, String modelId, int intValue) {
        ItemMeta meta;
        block11: {
            if (item == null) {
                return null;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return item;
            }
            boolean newApiSupported = CustomModelDataUtil.isNewApiSupported();
            if (newApiSupported) {
                try {
                    meta.setCustomModelData(Integer.valueOf(intValue));
                }
                catch (Exception e) {
                    System.err.println("Warning: Failed to set integer CustomModelData: " + e.getMessage());
                }
                try {
                    CustomModelDataComponent component = meta.getCustomModelDataComponent();
                    if (component != null) {
                        component.setStrings(Collections.singletonList(modelId));
                        meta.setCustomModelDataComponent(component);
                        break block11;
                    }
                    CustomModelDataUtil.setNewApiModelData(meta, modelId);
                }
                catch (Exception e) {
                    System.err.println("Warning: Failed to set string on CustomModelData component: " + e.getMessage());
                }
            } else {
                try {
                    meta.setCustomModelData(Integer.valueOf(intValue));
                }
                catch (Exception e) {
                    System.err.println("Warning: Failed to set old API CustomModelData: " + e.getMessage());
                }
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    private static CustomModelDataComponent createCustomModelDataComponentWithInt(String modelId, int intValue) {
        return CustomModelDataUtil.createCustomModelDataComponent(modelId);
    }

    public static String getCustomModelDataString(ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        if (CustomModelDataUtil.isNewApiSupported()) {
            try {
                CustomModelDataComponent component = meta.getCustomModelDataComponent();
                if (component != null && !component.getStrings().isEmpty()) {
                    return (String)component.getStrings().get(0);
                }
            }
            catch (Exception component) {
                // empty catch block
            }
        }
        if (meta.hasCustomModelData()) {
            try {
                int intValue = meta.getCustomModelData();
                String modelId = INT_TO_STRING_MAPPING.get(intValue);
                if (modelId != null) {
                    return modelId;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getCustomModelDataInt(ItemStack item) {
        if (item == null) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 0;
        }
        if (meta.hasCustomModelData()) {
            try {
                return meta.getCustomModelData();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (CustomModelDataUtil.isNewApiSupported()) {
            try {
                CustomModelDataComponent component = meta.getCustomModelDataComponent();
                if (component != null && !component.getStrings().isEmpty()) {
                    String modelId = (String)component.getStrings().get(0);
                    return STRING_TO_INT_MAPPING.getOrDefault(modelId, 0);
                }
            }
            catch (Exception e) {
                System.err.println("Warning: Failed to get CustomModelDataInt: " + e.getMessage());
            }
        }
        return 0;
    }

    public static int getIntValueForModelId(String modelId) {
        return STRING_TO_INT_MAPPING.getOrDefault(modelId, 0);
    }

    public static void registerMapping(String modelId, int intValue) {
        STRING_TO_INT_MAPPING.put(modelId, intValue);
        INT_TO_STRING_MAPPING.put(intValue, modelId);
    }

    public static void clearCache() {
        useNewApi = null;
    }

    public static Map<String, Integer> getAllMappings() {
        return new HashMap<String, Integer>(STRING_TO_INT_MAPPING);
    }

    public static Map<Integer, String> getAllReverseMappings() {
        return new HashMap<Integer, String>(INT_TO_STRING_MAPPING);
    }

    public static boolean hasCustomModelData(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        try {
            if (meta.hasCustomModelData()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CustomModelDataUtil.isNewApiSupported()) {
            try {
                CustomModelDataComponent component = meta.getCustomModelDataComponent();
                return component != null && !component.getStrings().isEmpty();
            }
            catch (Exception e) {
                System.err.println("Warning: Failed to check CustomModelData: " + e.getMessage());
            }
        }
        return false;
    }

    public static void registerMappings(Map<String, Integer> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Integer> entry : mappings.entrySet()) {
            CustomModelDataUtil.registerMapping(entry.getKey(), entry.getValue());
        }
    }

    static {
        CustomModelDataUtil.registerMapping("diamond_lattice", 1001);
    }
}

