/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.BlockPackManager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.Little_100.projecte.FuelManager;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.util.MapArtUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Fuel
implements Listener {
    private final ProjectE plugin;
    private final FuelManager fuelManager;
    private final Map<Integer, Map<BlockFace, ItemStack>> fuelBlockMaps = new HashMap<Integer, Map<BlockFace, ItemStack>>();

    public Fuel(ProjectE plugin) {
        this.plugin = plugin;
        this.fuelManager = plugin.getFuelManager();
        this.loadFuelBlockMaps();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadFuelBlockMaps() {
        ItemStack map1 = MapArtUtil.createImageMap("blockpack/Fuelblock/fuels_1.png");
        ItemStack map2 = MapArtUtil.createImageMap("blockpack/Fuelblock/fuels_2.png");
        ItemStack map3 = MapArtUtil.createImageMap("blockpack/Fuelblock/fuels_3.png");
        if (map1 == null || map2 == null || map3 == null) {
            this.plugin.getLogger().severe("Failed to load one or more fuel maps. Aborting.");
            return;
        }
        HashMap<BlockFace, ItemStack> alchemicalCoalMaps = new HashMap<BlockFace, ItemStack>();
        for (BlockFace face : BlockFace.values()) {
            if (!face.isCartesian()) continue;
            alchemicalCoalMaps.put(face, map1);
        }
        this.fuelBlockMaps.put(1, alchemicalCoalMaps);
        HashMap<BlockFace, ItemStack> mobiusFuelMaps = new HashMap<BlockFace, ItemStack>();
        for (BlockFace face : BlockFace.values()) {
            if (!face.isCartesian()) continue;
            mobiusFuelMaps.put(face, map2);
        }
        this.fuelBlockMaps.put(2, mobiusFuelMaps);
        HashMap<BlockFace, ItemStack> aeternalisFuelMaps = new HashMap<BlockFace, ItemStack>();
        for (BlockFace face : BlockFace.values()) {
            if (!face.isCartesian()) continue;
            aeternalisFuelMaps.put(face, map3);
        }
        this.fuelBlockMaps.put(3, aeternalisFuelMaps);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        int fuelType = 0;
        if (this.fuelManager.isAlchemicalCoalBlock(itemInHand)) {
            fuelType = 1;
        } else if (this.fuelManager.isMobiusFuelBlock(itemInHand)) {
            fuelType = 2;
        } else if (this.fuelManager.isAeternalisFuelBlock(itemInHand)) {
            fuelType = 3;
        }
        if (fuelType > 0) {
            Material centerMaterial;
            Map<BlockFace, ItemStack> maps;
            Location location;
            boolean placed;
            event.setCancelled(true);
            Block clickedBlock = event.getClickedBlock();
            if (clickedBlock != null && (placed = MapArtUtil.placeArtBlock(location = clickedBlock.getRelative(event.getBlockFace()).getLocation(), maps = this.fuelBlockMaps.get(fuelType), centerMaterial = fuelType <= 2 ? Material.REDSTONE_BLOCK : Material.DIORITE, fuelType, player)) && player.getGameMode() != GameMode.CREATIVE) {
                itemInHand.setAmount(itemInHand.getAmount() - 1);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block brokenBlock = event.getBlock();
        Location location = brokenBlock.getLocation();
        Collection nearbyEntities = location.getWorld().getNearbyEntities(location, 1.5, 1.5, 1.5, entity -> entity instanceof ItemFrame);
        for (Entity entity2 : nearbyEntities) {
            ItemStack drop;
            ItemFrame frame = (ItemFrame)entity2;
            if (!frame.getPersistentDataContainer().has(MapArtUtil.artFrameKey, PersistentDataType.BYTE)) continue;
            Integer centerX = (Integer)frame.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "center_block_x"), PersistentDataType.INTEGER);
            Integer centerY = (Integer)frame.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "center_block_y"), PersistentDataType.INTEGER);
            Integer centerZ = (Integer)frame.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "center_block_z"), PersistentDataType.INTEGER);
            if (centerX == null || !centerX.equals(brokenBlock.getX()) || centerY == null || !centerY.equals(brokenBlock.getY()) || centerZ == null || !centerZ.equals(brokenBlock.getZ())) continue;
            event.setDropItems(false);
            Integer fuelType = (Integer)frame.getPersistentDataContainer().get(MapArtUtil.fuelTypeKey, PersistentDataType.INTEGER);
            if (fuelType == null || fuelType <= 0) break;
            switch (fuelType) {
                case 1: {
                    drop = this.fuelManager.getAlchemicalCoalBlock();
                    break;
                }
                case 2: {
                    drop = this.fuelManager.getMobiusFuelBlock();
                    break;
                }
                case 3: {
                    drop = this.fuelManager.getAeternalisFuelBlock();
                    break;
                }
                default: {
                    return;
                }
            }
            brokenBlock.getWorld().dropItemNaturally(location, drop);
            break;
        }
    }
}

