/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.Tools;

import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.Tools.Repair_Talisman;
import org.Little_100.projecte.compatibility.SchedulerAdapter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class RepairTalismanListener {
    private final ProjectE plugin;
    private final SchedulerAdapter scheduler;
    private final Repair_Talisman repairTalisman;

    public RepairTalismanListener(ProjectE plugin) {
        this.plugin = plugin;
        this.scheduler = plugin.getSchedulerAdapter();
        this.repairTalisman = plugin.getRepairTalisman();
        this.startRepairTask();
    }

    private void startRepairTask() {
        this.scheduler.runTimer(() -> {
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                this.scheduler.runTaskOnEntity((Entity)player, () -> {
                    boolean hasTalisman = false;
                    for (ItemStack item : player.getInventory().getContents()) {
                        if (!this.repairTalisman.isRepairTalisman(item)) continue;
                        hasTalisman = true;
                        break;
                    }
                    if (hasTalisman) {
                        Damageable meta;
                        for (ItemStack item : player.getInventory().getContents()) {
                            if (item == null || !(item.getItemMeta() instanceof Damageable) || !(meta = (Damageable)item.getItemMeta()).hasDamage() || meta.getDamage() <= 0) continue;
                            meta.setDamage(Math.max(0, meta.getDamage() - 1));
                            item.setItemMeta((ItemMeta)meta);
                        }
                        for (ItemStack item : player.getInventory().getArmorContents()) {
                            if (item == null || !(item.getItemMeta() instanceof Damageable) || !(meta = (Damageable)item.getItemMeta()).hasDamage() || meta.getDamage() <= 0) continue;
                            meta.setDamage(Math.max(0, meta.getDamage() - 1));
                            item.setItemMeta((ItemMeta)meta);
                        }
                    }
                });
            }
        }, 1L, 20L);
    }
}

