/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.util;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.Little_100.projecte.DebugManager;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MapArtUtil
implements Listener {
    private static ProjectE plugin;
    public static NamespacedKey artFrameKey;
    public static NamespacedKey blockPackKey;
    public static NamespacedKey fuelTypeKey;
    private final NamespacedKey centerBlockXKey;
    private final NamespacedKey centerBlockYKey;
    private final NamespacedKey centerBlockZKey;

    public MapArtUtil(ProjectE plugin) {
        MapArtUtil.plugin = plugin;
        artFrameKey = new NamespacedKey((Plugin)plugin, "map_art_frame");
        blockPackKey = new NamespacedKey((Plugin)plugin, "block_pack_type");
        fuelTypeKey = new NamespacedKey((Plugin)plugin, "fuel_type");
        this.centerBlockXKey = new NamespacedKey((Plugin)plugin, "center_block_x");
        this.centerBlockYKey = new NamespacedKey((Plugin)plugin, "center_block_y");
        this.centerBlockZKey = new NamespacedKey((Plugin)plugin, "center_block_z");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public static ItemStack createImageMap(String imagePath) {
        File imageFile = new File(plugin.getDataFolder(), imagePath);
        if (!imageFile.exists()) {
            plugin.saveResource(imagePath, false);
        }
        if (!imageFile.exists()) {
            DebugManager.log("Image file not found: " + imagePath);
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(imageFile);
            if (image != null) {
                MapView mapView = Bukkit.createMap((World)((World)Bukkit.getWorlds().get(0)));
                mapView.getRenderers().forEach(arg_0 -> ((MapView)mapView).removeRenderer(arg_0));
                mapView.addRenderer((MapRenderer)new ImageRenderer(image));
                ItemStack mapItem = new ItemStack(Material.FILLED_MAP);
                MapMeta mapMeta = (MapMeta)mapItem.getItemMeta();
                mapMeta.setMapView(mapView);
                mapItem.setItemMeta((ItemMeta)mapMeta);
                return mapItem;
            }
        }
        catch (IOException e) {
            DebugManager.log("Failed to load image: " + imagePath);
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean placeArtBlock(Location location, Map<BlockFace, ItemStack> maps, Material centerMaterial, Integer fuelType, Player player) {
        if (maps == null || maps.isEmpty()) {
            return false;
        }
        boolean limitEnabled = plugin.getConfig().getBoolean("CustomBlockPack.limit.enabled", true);
        if (limitEnabled) {
            int maxBlocks = plugin.getConfig().getInt("CustomBlockPack.limit.max", 5);
            int currentBlocks = 0;
            Chunk chunk = location.getChunk();
            for (Entity entity : chunk.getEntities()) {
                ItemFrame frame;
                if (!(entity instanceof ItemFrame) || !entity.getPersistentDataContainer().has(artFrameKey, PersistentDataType.BYTE) || (frame = (ItemFrame)entity).getFacing() != BlockFace.UP) continue;
                ++currentBlocks;
            }
            if (currentBlocks >= maxBlocks) {
                if (player != null) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("max", String.valueOf(maxBlocks));
                    player.sendMessage(plugin.getLanguageManager().get("serverside.blockpack.limit_exceeded", placeholders));
                }
                return false;
            }
        }
        Block centerBlock = location.getBlock();
        HashMap<Location, BlockState> originalStates = new HashMap<Location, BlockState>();
        try {
            BlockFace[] faces;
            for (int x = -2; x <= 2; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        Block block = centerBlock.getRelative(x, y, z);
                        if (block.getType().isAir()) continue;
                        originalStates.put(block.getLocation(), block.getState());
                    }
                }
            }
            for (BlockState state : originalStates.values()) {
                state.getBlock().setType(Material.AIR, false);
            }
            centerBlock.setType(centerMaterial, false);
            for (BlockFace face : faces = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                Block adjacentBlock = centerBlock.getRelative(face);
                ItemStack mapItem = maps.get(face);
                if (mapItem == null) continue;
                ItemFrame itemFrame = (ItemFrame)adjacentBlock.getWorld().spawn(adjacentBlock.getLocation(), ItemFrame.class, spawnedFrame -> {
                    spawnedFrame.setSilent(true);
                    spawnedFrame.setFacingDirection(face.getOppositeFace());
                    spawnedFrame.setItem(mapItem.clone());
                    spawnedFrame.setVisible(false);
                    spawnedFrame.setInvulnerable(true);
                    spawnedFrame.setFixed(true);
                    spawnedFrame.getPersistentDataContainer().set(artFrameKey, PersistentDataType.BYTE, (Object)1);
                    spawnedFrame.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, "center_block_x"), PersistentDataType.INTEGER, (Object)centerBlock.getX());
                    spawnedFrame.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, "center_block_y"), PersistentDataType.INTEGER, (Object)centerBlock.getY());
                    spawnedFrame.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, "center_block_z"), PersistentDataType.INTEGER, (Object)centerBlock.getZ());
                    if (fuelType != null) {
                        spawnedFrame.getPersistentDataContainer().set(fuelTypeKey, PersistentDataType.INTEGER, (Object)fuelType);
                    }
                });
            }
        }
        finally {
            for (Map.Entry entry : originalStates.entrySet()) {
                ((BlockState)entry.getValue()).update(true, false);
            }
        }
        return true;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        if (event.getEntity() instanceof ItemFrame && event.getEntity().getPersistentDataContainer().has(artFrameKey, PersistentDataType.BYTE)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!(event.getRightClicked() instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)event.getRightClicked();
        if (!itemFrame.getPersistentDataContainer().has(artFrameKey, PersistentDataType.BYTE)) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getHand() == EquipmentSlot.HAND) {
            player.sendMessage(plugin.getLanguageManager().get("serverside.command.generic.interact_with_map_art_fail"));
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block brokenBlock = event.getBlock();
        int brokenX = brokenBlock.getX();
        int brokenY = brokenBlock.getY();
        int brokenZ = brokenBlock.getZ();
        plugin.getSchedulerAdapter().runTaskLaterAtLocation(brokenBlock.getLocation(), () -> {
            DebugManager.log("\u5f00\u59cb\u6e05\u7406\u5750\u6807 " + String.valueOf(brokenBlock.getLocation()) + " \u5468\u56f4\u7684\u5c55\u793a\u6846");
            int removed = 0;
            for (BlockFace face : new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                Block adjacentBlock = brokenBlock.getRelative(face);
                Location checkLocation = adjacentBlock.getLocation();
                Collection framesOnFace = checkLocation.getWorld().getNearbyEntities(checkLocation, 0.5, 0.5, 0.5, entity -> entity instanceof ItemFrame);
                for (Entity entity2 : framesOnFace) {
                    ItemFrame frame = (ItemFrame)entity2;
                    if (!frame.getPersistentDataContainer().has(artFrameKey, PersistentDataType.BYTE)) continue;
                    Integer centerX = (Integer)frame.getPersistentDataContainer().get(this.centerBlockXKey, PersistentDataType.INTEGER);
                    Integer centerY = (Integer)frame.getPersistentDataContainer().get(this.centerBlockYKey, PersistentDataType.INTEGER);
                    Integer centerZ = (Integer)frame.getPersistentDataContainer().get(this.centerBlockZKey, PersistentDataType.INTEGER);
                    if (centerX == null || centerY == null || centerZ == null || centerX != brokenX || centerY != brokenY || centerZ != brokenZ) continue;
                    frame.remove();
                    ++removed;
                }
            }
            if (removed > 0) {
                DebugManager.log("\u79fb\u9664\u4e86 " + removed + " \u4e2a\u76f8\u5173\u5c55\u793a\u6846");
            }
        }, 1L);
    }

    private static class ImageRenderer
    extends MapRenderer {
        private final BufferedImage image = new BufferedImage(128, 128, 2);
        private boolean rendered = false;

        public ImageRenderer(BufferedImage image) {
            Graphics2D g2d = this.image.createGraphics();
            g2d.setComposite(AlphaComposite.Clear);
            g2d.fillRect(0, 0, 128, 128);
            g2d.setComposite(AlphaComposite.SrcOver);
            g2d.drawImage(image, 0, 0, 128, 128, null);
            g2d.dispose();
        }

        public void render(MapView map, MapCanvas canvas, Player player) {
            if (!this.rendered) {
                canvas.drawImage(0, 0, (Image)this.image);
                this.rendered = true;
            }
        }
    }
}

