/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.AlchemicalBag;

import java.util.HashMap;
import org.Little_100.projecte.AlchemicalBag.InventoryManager;
import org.Little_100.projecte.AlchemicalBag.PlayerInteractListener;
import org.Little_100.projecte.LanguageManager;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;

public class AlchemicalBagManager
implements Listener {
    private final ProjectE plugin;
    private final InventoryManager inventoryManager;
    private final LanguageManager languageManager;
    private static ItemStack alchemicalBag;

    public AlchemicalBagManager(ProjectE plugin) {
        this.plugin = plugin;
        this.inventoryManager = new InventoryManager(plugin, this);
        this.languageManager = plugin.getLanguageManager();
        this.createAlchemicalBag();
    }

    private void createAlchemicalBag() {
        alchemicalBag = new ItemStack(Material.LEATHER_HORSE_ARMOR);
        LeatherArmorMeta meta = (LeatherArmorMeta)alchemicalBag.getItemMeta();
        meta.setDisplayName(this.languageManager.get("clientside.alchemical_bag.name"));
        alchemicalBag.setItemMeta((ItemMeta)meta);
    }

    public static ItemStack getAlchemicalBag() {
        return alchemicalBag;
    }

    public void register() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(this.plugin, this, this.inventoryManager), (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.inventoryManager, (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.removeVanillaRecipes();
    }

    public void unregister() {
    }

    private void removeVanillaRecipes() {
        try {
            Bukkit.removeRecipe((NamespacedKey)NamespacedKey.minecraft((String)"leather_horse_armor"));
            this.plugin.getLogger().info("Successfully removed vanilla leather horse armor recipe.");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not remove vanilla leather horse armor recipe: " + e.getMessage());
        }
    }

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (recipe == null || !(recipe instanceof ShapelessRecipe)) {
            return;
        }
        NamespacedKey key = ((ShapelessRecipe)recipe).getKey();
        if (!key.equals((Object)new NamespacedKey((Plugin)this.plugin, "alchemicalbag_dyeing"))) {
            return;
        }
        CraftingInventory inventory = event.getInventory();
        ItemStack[] matrix = inventory.getMatrix();
        ItemStack bag = null;
        ItemStack dye = null;
        for (ItemStack item : matrix) {
            if (item == null || item.getType().isAir()) continue;
            if (item.getType() == Material.LEATHER_HORSE_ARMOR) {
                bag = item;
                continue;
            }
            if (!item.getType().name().endsWith("_DYE")) continue;
            dye = item;
        }
        if (bag == null || dye == null) {
            inventory.setResult(null);
            return;
        }
        LeatherArmorMeta bagMeta = (LeatherArmorMeta)bag.getItemMeta();
        if (bagMeta == null) {
            inventory.setResult(null);
            return;
        }
        DyeColor dyeColor = this.getDyeColor(dye.getType());
        if (dyeColor == null) {
            inventory.setResult(null);
            return;
        }
        ItemStack result = bag.clone();
        LeatherArmorMeta resultMeta = (LeatherArmorMeta)result.getItemMeta();
        resultMeta.setColor(dyeColor.getColor());
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("color", PlayerInteractListener.getChatColor(dyeColor.name()).toString());
        placeholders.put("color_name", dyeColor.name());
        resultMeta.setDisplayName(this.languageManager.get("clientside.alchemical_bag.colored_name", placeholders));
        result.setItemMeta((ItemMeta)resultMeta);
        inventory.setResult(result);
    }

    private DyeColor getDyeColor(Material material) {
        try {
            return DyeColor.valueOf((String)material.name().replace("_DYE", ""));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

