/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.Armor;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.Little_100.projecte.Armor.ArmorManager;
import org.Little_100.projecte.Armor.GemHelmet;
import org.Little_100.projecte.Armor.GemHelmetGUI;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class ArmorListener
implements Listener {
    private final Map<Location, Material> temporaryBlocks = new HashMap<Location, Material>();
    private final Map<UUID, Boolean> autoStepEnabled = new HashMap<UUID, Boolean>();
    private final NamespacedKey gravitySlamKey;
    private final ProjectE plugin;
    private final ArmorManager armorManager;
    private final NamespacedKey internalVelocityKey;
    private static final Set<EntityDamageEvent.DamageCause> UNPROTECTED_CAUSES = EnumSet.of(EntityDamageEvent.DamageCause.FALL, new EntityDamageEvent.DamageCause[]{EntityDamageEvent.DamageCause.FIRE_TICK, EntityDamageEvent.DamageCause.MAGIC, EntityDamageEvent.DamageCause.POISON, EntityDamageEvent.DamageCause.WITHER, EntityDamageEvent.DamageCause.STARVATION, EntityDamageEvent.DamageCause.SUFFOCATION, EntityDamageEvent.DamageCause.DROWNING, EntityDamageEvent.DamageCause.VOID, EntityDamageEvent.DamageCause.FREEZE});

    public ArmorListener(ProjectE plugin) {
        this.plugin = plugin;
        this.armorManager = plugin.getArmorManager();
        this.gravitySlamKey = new NamespacedKey((Plugin)plugin, "is-gravity-slamming");
        this.internalVelocityKey = new NamespacedKey((Plugin)plugin, "internal-velocity-change");
        this.startArmorEffectTask();
    }

    private void startArmorEffectTask() {
        this.plugin.getSchedulerAdapter().runTimer(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.plugin.getSchedulerAdapter().runTaskOnEntity((Entity)player, () -> {
                    this.checkGemHelmetEffects(player);
                    this.checkGemChestplateEffects(player);
                    this.checkGemLeggingsEffects(player);
                    this.checkGemBootsEffects(player);
                });
            }
        }, 0L, 1L);
    }

    private void checkGemChestplateEffects(Player player) {
        if (this.armorManager.isGemChestplate(player.getInventory().getChestplate()) && player.getFoodLevel() < 20) {
            player.setFoodLevel(player.getFoodLevel() + 1);
        }
    }

    private void checkGemHelmetEffects(Player player) {
        if (this.armorManager.isGemHelmet(player.getInventory().getHelmet())) {
            if (player.getHealth() < player.getMaxHealth()) {
                player.setHealth(Math.min(player.getHealth() + 0.5, player.getMaxHealth()));
            }
            if (player.isInWater()) {
                player.setRemainingAir(player.getMaximumAir());
            }
            GemHelmet.updateNightVision(player);
        } else if (GemHelmet.isNightVisionActive(player)) {
            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        }
    }

    private void checkGemLeggingsEffects(Player player) {
        if (!this.armorManager.isGemLeggings(player.getInventory().getLeggings())) {
            if (player.getPersistentDataContainer().has(this.gravitySlamKey, PersistentDataType.BYTE)) {
                player.getPersistentDataContainer().remove(this.gravitySlamKey);
            }
            return;
        }
        if (player.isSneaking()) {
            for (Entity entity : player.getNearbyEntities(10.0, 10.0, 10.0)) {
                Vector direction;
                if (!(entity instanceof LivingEntity) || entity.equals((Object)player) || !((direction = entity.getLocation().toVector().subtract(player.getLocation().toVector())).lengthSquared() > 0.0)) continue;
                direction.normalize();
                entity.setVelocity(direction.multiply(1.2));
            }
            boolean isAirborne = player.getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType().isAir();
            if (isAirborne) {
                if (player.hasPotionEffect(PotionEffectType.SLOW_FALLING)) {
                    player.removePotionEffect(PotionEffectType.SLOW_FALLING);
                }
                Vector currentVelocity = player.getVelocity();
                currentVelocity.setY(-2.0);
                player.getPersistentDataContainer().set(this.internalVelocityKey, PersistentDataType.BYTE, (Object)1);
                player.setVelocity(currentVelocity);
                player.getPersistentDataContainer().set(this.gravitySlamKey, PersistentDataType.BYTE, (Object)1);
            }
        } else if (player.getPersistentDataContainer().has(this.gravitySlamKey, PersistentDataType.BYTE)) {
            player.getPersistentDataContainer().remove(this.gravitySlamKey);
        }
    }

    private void checkGemBootsEffects(Player player) {
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (this.armorManager.isGemBoots(player.getInventory().getBoots())) {
            if (!player.isFlying()) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 10, 0, true, false));
            }
            player.setAllowFlight(true);
            player.setFlySpeed(0.2f);
        } else {
            PotionEffect slowFall;
            if (player.getAllowFlight() && !player.getGameMode().equals((Object)GameMode.CREATIVE) && !player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
                player.setAllowFlight(false);
                player.setFlying(false);
                player.setFlySpeed(0.1f);
            }
            if (player.hasPotionEffect(PotionEffectType.SLOW_FALLING) && (slowFall = player.getPotionEffect(PotionEffectType.SLOW_FALLING)) != null && slowFall.isAmbient()) {
                player.removePotionEffect(PotionEffectType.SLOW_FALLING);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        player.getPersistentDataContainer().remove(this.gravitySlamKey);
        player.getPersistentDataContainer().remove(this.internalVelocityKey);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        player.getPersistentDataContainer().remove(this.gravitySlamKey);
        player.getPersistentDataContainer().remove(this.internalVelocityKey);
        this.autoStepEnabled.remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.isWearingFullSet(player, "red_matter_")) {
            if (UNPROTECTED_CAUSES.contains(event.getCause())) {
                return;
            }
            event.setCancelled(true);
        } else if (this.isWearingFullSet(player, "dark_matter_")) {
            if (UNPROTECTED_CAUSES.contains(event.getCause())) {
                return;
            }
            if (event.getDamage() <= 20.0) {
                event.setCancelled(true);
                player.getWorld().playSound(player.getLocation(), Sound.ITEM_SHIELD_BLOCK, 1.0f, 1.0f);
            }
        }
        if (this.armorManager.isGemChestplate(player.getInventory().getChestplate()) && (event.getCause() == EntityDamageEvent.DamageCause.FIRE || event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK || event.getCause() == EntityDamageEvent.DamageCause.LAVA)) {
            event.setCancelled(true);
            player.setFireTicks(0);
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            if (this.armorManager.isGemBoots(player.getInventory().getBoots())) {
                event.setCancelled(true);
                return;
            }
            if (player.getPersistentDataContainer().has(this.gravitySlamKey, PersistentDataType.BYTE)) {
                event.setCancelled(true);
                player.getPersistentDataContainer().remove(this.gravitySlamKey);
                float fallDistance = player.getFallDistance();
                if (fallDistance > 10.0f) {
                    double radius = 10.0;
                    double damage = Math.min((double)fallDistance / 2.0, 50.0);
                    player.getWorld().playSound(player.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 1.0f);
                    for (Entity entity : player.getNearbyEntities(radius, radius, radius)) {
                        if (!(entity instanceof LivingEntity) || entity.equals((Object)player) || entity instanceof ArmorStand) continue;
                        LivingEntity livingEntity = (LivingEntity)entity;
                        livingEntity.damage(damage, (Entity)player);
                        Vector knockback = livingEntity.getLocation().toVector().subtract(player.getLocation().toVector()).normalize();
                        knockback.setY(0.8).multiply(Math.min((double)fallDistance / 15.0, 3.0));
                        livingEntity.setVelocity(knockback);
                    }
                }
            }
        }
    }

    private boolean isWearingFullSet(Player player, String armorPrefix) {
        PlayerInventory inventory = player.getInventory();
        ItemStack helmet = inventory.getHelmet();
        ItemStack chestplate = inventory.getChestplate();
        ItemStack leggings = inventory.getLeggings();
        ItemStack boots = inventory.getBoots();
        return this.isArmorPiece(helmet, armorPrefix + "helmet") && this.isArmorPiece(chestplate, armorPrefix + "chestplate") && this.isArmorPiece(leggings, armorPrefix + "leggings") && this.isArmorPiece(boots, armorPrefix + "boots");
    }

    private boolean isArmorPiece(ItemStack item, String expectedId) {
        if (item == null) {
            return false;
        }
        String id = this.armorManager.getArmorId(item);
        return expectedId.equals(id);
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        if (this.armorManager.isDarkMatterArmor(event.getItem()) || this.armorManager.isRedMatterArmor(event.getItem()) || this.armorManager.isGemHelmet(event.getItem()) || this.armorManager.isGemChestplate(event.getItem()) || this.armorManager.isGemLeggings(event.getItem()) || this.armorManager.isGemBoots(event.getItem())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (event.getFrom().getX() != event.getTo().getX() || event.getFrom().getZ() == event.getTo().getZ()) {
            // empty if block
        }
        if (player.isSneaking() && player.getLocation().getY() < 100.0 && this.armorManager.isGemLeggings(player.getInventory().getLeggings())) {
            return;
        }
        if (this.armorManager.isGemChestplate(player.getInventory().getChestplate()) && !player.isSneaking()) {
            Location loc = player.getLocation();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    Location blockLoc;
                    Block block = loc.clone().add((double)x, -1.0, (double)z).getBlock();
                    if (block.getType() != Material.LAVA || this.temporaryBlocks.containsKey(blockLoc = block.getLocation())) continue;
                    this.temporaryBlocks.put(blockLoc, block.getType());
                    block.setType(Material.OBSIDIAN);
                    this.plugin.getSchedulerAdapter().runTaskLaterAtLocation(blockLoc, () -> {
                        if (this.temporaryBlocks.containsKey(blockLoc)) {
                            block.setType(this.temporaryBlocks.remove(blockLoc));
                        }
                    }, 20L);
                }
            }
        }
    }

    public void toggleAutoStep(Player player) {
        boolean enabled = this.autoStepEnabled.getOrDefault(player.getUniqueId(), false);
        this.autoStepEnabled.put(player.getUniqueId(), !enabled);
        if (!enabled) {
            player.sendMessage(this.plugin.getLanguageManager().get("item.gem_boots.autostep_on"));
        } else {
            player.sendMessage(this.plugin.getLanguageManager().get("item.gem_boots.autostep_off"));
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        boolean isFirstItemArmor;
        ItemStack first = event.getInventory().getItem(0);
        ItemStack second = event.getInventory().getItem(1);
        boolean bl = isFirstItemArmor = this.armorManager.isDarkMatterArmor(first) || this.armorManager.isRedMatterArmor(first) || this.armorManager.isGemHelmet(first) || this.armorManager.isGemChestplate(first) || this.armorManager.isGemLeggings(first) || this.armorManager.isGemBoots(first);
        if (isFirstItemArmor) {
            if (event.getInventory().getRenameText() != null && !event.getInventory().getRenameText().isEmpty()) {
                event.setResult(null);
                return;
            }
            if (second != null && second.getType() == Material.ENCHANTED_BOOK) {
                event.setResult(null);
                return;
            }
            if (second != null) {
                event.setResult(null);
                return;
            }
        }
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (player.isSneaking() && this.armorManager.isGemHelmet(player.getInventory().getHelmet()) && (player.getInventory().getItemInMainHand() == null || player.getInventory().getItemInMainHand().getType() == Material.AIR)) {
            event.setCancelled(true);
            GemHelmetGUI.open(player);
        }
    }

    @EventHandler
    public void onPlayerVelocity(PlayerVelocityEvent event) {
        Player player = event.getPlayer();
        if (player.getPersistentDataContainer().has(this.internalVelocityKey, PersistentDataType.BYTE)) {
            player.getPersistentDataContainer().remove(this.internalVelocityKey);
            return;
        }
        if (player.isSneaking() && this.armorManager.isGemLeggings(player.getInventory().getLeggings())) {
            event.setCancelled(true);
        }
    }
}

