/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.Little_100.projecte.BlockDataManager;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.compatibility.SchedulerAdapter;
import org.Little_100.projecte.storage.DatabaseManager;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FuelManager
implements Listener {
    private final ProjectE plugin;
    private final SchedulerAdapter scheduler;
    private final NamespacedKey alchemicalCoalKey;
    private final NamespacedKey mobiusFuelKey;
    private final NamespacedKey aeternalisFuelKey;
    private final NamespacedKey darkMatterKey;
    private final NamespacedKey redMatterKey;
    private ItemStack alchemicalCoal;
    private ItemStack mobiusFuel;
    private ItemStack aeternalisFuel;
    private ItemStack alchemicalCoalBlock;
    private ItemStack mobiusFuelBlock;
    private ItemStack aeternalisFuelBlock;
    private ItemStack darkMatter;
    private ItemStack redMatter;
    private ItemStack darkMatterBlock;
    private ItemStack redMatterBlock;
    private final Map<String, Integer> burnTimes = new HashMap<String, Integer>();
    private final boolean isModernVersion;

    public FuelManager(ProjectE plugin) {
        this.plugin = plugin;
        this.scheduler = plugin.getSchedulerAdapter();
        this.alchemicalCoalKey = new NamespacedKey((Plugin)plugin, "alchemical_coal");
        this.mobiusFuelKey = new NamespacedKey((Plugin)plugin, "mobius_fuel");
        this.aeternalisFuelKey = new NamespacedKey((Plugin)plugin, "aeternalis_fuel");
        this.darkMatterKey = new NamespacedKey((Plugin)plugin, "dark_matter");
        this.redMatterKey = new NamespacedKey((Plugin)plugin, "red_matter");
        this.isModernVersion = this.isVersion1_21_4OrNewer();
        this.burnTimes.put("alchemical_coal", 6400);
        this.burnTimes.put("mobius_fuel", 25600);
        this.burnTimes.put("aeternalis_fuel", 102400);
        this.burnTimes.put("alchemical_coal_block", 57600);
        this.burnTimes.put("mobius_fuel_block", 230400);
        this.burnTimes.put("aeternalis_fuel_block", 921600);
        plugin.getLogger().info("FuelManager: Detected version " + Bukkit.getServer().getBukkitVersion() + (this.isModernVersion ? " (using modern material handling)" : " (using legacy material handling)"));
        this.createFuelItems();
        this.registerCustomBlocks();
    }

    private boolean isVersion1_21_4OrNewer() {
        try {
            String version = Bukkit.getServer().getBukkitVersion().split("-")[0];
            String[] versionParts = version.split("\\.");
            if (versionParts.length >= 2) {
                int major = Integer.parseInt(versionParts[0]);
                int minor = Integer.parseInt(versionParts[1]);
                if (major > 1) {
                    return true;
                }
                if (major == 1 && minor > 21) {
                    return true;
                }
                if (major == 1 && minor == 21 && versionParts.length >= 3) {
                    int patch = Integer.parseInt(versionParts[2]);
                    return patch >= 4;
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not parse version number, using legacy mode: " + e.getMessage());
        }
        return false;
    }

    private void createFuelItems() {
        this.createModernFuelItems();
    }

    private void createModernFuelItems() {
        this.alchemicalCoal = this.createFuelItem(Material.COAL, "item.alchemical_coal.name", 1, Arrays.asList("item.alchemical_coal.lore1", "item.alchemical_coal.lore2"), this.alchemicalCoalKey, (byte)1, "alchemical_coal");
        this.mobiusFuel = this.createFuelItem(Material.COAL, "item.mobius_fuel.name", 2, Arrays.asList("item.mobius_fuel.lore1", "item.mobius_fuel.lore2"), this.mobiusFuelKey, (byte)1, "mobius_fuel");
        this.aeternalisFuel = this.createFuelItem(Material.COAL, "item.aeternalis_fuel.name", 3, Arrays.asList("item.aeternalis_fuel.lore1", "item.aeternalis_fuel.lore2"), this.aeternalisFuelKey, (byte)1, "aeternalis_fuel");
        this.alchemicalCoalBlock = this.createFuelItem(Material.COAL_BLOCK, "item.alchemical_coal_block.name", 1, Arrays.asList("item.alchemical_coal_block.lore1", "item.alchemical_coal_block.lore2"), this.alchemicalCoalKey, (byte)2, "alchemical_coal_block");
        this.mobiusFuelBlock = this.createFuelItem(Material.COAL_BLOCK, "item.mobius_fuel_block.name", 2, Arrays.asList("item.mobius_fuel_block.lore1", "item.mobius_fuel_block.lore2"), this.mobiusFuelKey, (byte)2, "mobius_fuel_block");
        this.aeternalisFuelBlock = this.createFuelItem(Material.COAL_BLOCK, "item.aeternalis_fuel_block.name", 3, Arrays.asList("item.aeternalis_fuel_block.lore1", "item.aeternalis_fuel_block.lore2"), this.aeternalisFuelKey, (byte)2, "aeternalis_fuel_block");
        this.darkMatter = this.createFuelItem(Material.SLIME_BALL, "item.dark_matter.name", 1, Arrays.asList("item.dark_matter.lore1", "item.dark_matter.lore2"), this.darkMatterKey, (byte)1, "dark_matter");
        this.redMatter = this.createFuelItem(Material.SLIME_BALL, "item.red_matter.name", 2, Arrays.asList("item.red_matter.lore1", "item.red_matter.lore2"), this.redMatterKey, (byte)1, "red_matter");
        this.darkMatterBlock = this.createFuelItem(Material.BLACK_CONCRETE, "item.dark_matter_block.name", 1, Arrays.asList("item.dark_matter_block.lore1", "item.dark_matter_block.lore2"), this.darkMatterKey, (byte)2, "dark_matter_block");
        this.redMatterBlock = this.createFuelItem(Material.REDSTONE_BLOCK, "item.red_matter_block.name", 1, Arrays.asList("item.red_matter_block.lore1", "item.red_matter_block.lore2"), this.redMatterKey, (byte)2, "red_matter_block");
    }

    private ItemStack createFuelItem(Material material, String displayNameKey, int customModelData, List<String> loreKeys, NamespacedKey key, byte value, String id) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get(displayNameKey));
            List translatedLore = loreKeys.stream().map(loreKey -> this.plugin.getLanguageManager().get((String)loreKey)).collect(Collectors.toList());
            meta.setLore(translatedLore);
            item.setItemMeta(meta);
            if (this.plugin.getConfig().getBoolean("debug")) {
                System.out.println("Before setting CustomModelData: " + String.valueOf(item));
            }
            item = CustomModelDataUtil.setCustomModelDataBoth(item, id, customModelData);
            if (this.plugin.getConfig().getBoolean("debug")) {
                System.out.println("After setting CustomModelData: " + String.valueOf(item));
            }
            this.addFuelTags(item, key, value, id);
        }
        return item;
    }

    private void addFuelTags(ItemStack item, NamespacedKey key, byte value, String id) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(key, PersistentDataType.BYTE, (Object)value);
            container.set(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING, (Object)id);
            item.setItemMeta(meta);
        }
    }

    public ItemStack getAlchemicalCoal() {
        return this.alchemicalCoal.clone();
    }

    public ItemStack getMobiusFuel() {
        return this.mobiusFuel.clone();
    }

    public ItemStack getAeternalisFuel() {
        return this.aeternalisFuel.clone();
    }

    public ItemStack getAlchemicalCoalBlock() {
        return this.alchemicalCoalBlock.clone();
    }

    public ItemStack getMobiusFuelBlock() {
        return this.mobiusFuelBlock.clone();
    }

    public ItemStack getAeternalisFuelBlock() {
        return this.aeternalisFuelBlock.clone();
    }

    public ItemStack getDarkMatter() {
        return this.darkMatter.clone();
    }

    public ItemStack getRedMatter() {
        return this.redMatter.clone();
    }

    public ItemStack getDarkMatterBlock() {
        return this.darkMatterBlock.clone();
    }

    public ItemStack getRedMatterBlock() {
        return this.redMatterBlock.clone();
    }

    public boolean isAlchemicalCoal(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.alchemicalCoalKey, PersistentDataType.BYTE) && (Byte)container.get(this.alchemicalCoalKey, PersistentDataType.BYTE) == 1;
    }

    public boolean isMobiusFuel(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.mobiusFuelKey, PersistentDataType.BYTE) && (Byte)container.get(this.mobiusFuelKey, PersistentDataType.BYTE) == 1;
    }

    public boolean isAeternalisFuel(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.aeternalisFuelKey, PersistentDataType.BYTE) && (Byte)container.get(this.aeternalisFuelKey, PersistentDataType.BYTE) == 1;
    }

    public boolean isAlchemicalCoalBlock(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.alchemicalCoalKey, PersistentDataType.BYTE) && (Byte)container.get(this.alchemicalCoalKey, PersistentDataType.BYTE) == 2;
    }

    public boolean isMobiusFuelBlock(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.mobiusFuelKey, PersistentDataType.BYTE) && (Byte)container.get(this.mobiusFuelKey, PersistentDataType.BYTE) == 2;
    }

    public boolean isAeternalisFuelBlock(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.aeternalisFuelKey, PersistentDataType.BYTE) && (Byte)container.get(this.aeternalisFuelKey, PersistentDataType.BYTE) == 2;
    }

    public boolean isDarkMatter(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.darkMatterKey, PersistentDataType.BYTE) && (Byte)container.get(this.darkMatterKey, PersistentDataType.BYTE) == 1;
    }

    public boolean isRedMatter(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.redMatterKey, PersistentDataType.BYTE) && (Byte)container.get(this.redMatterKey, PersistentDataType.BYTE) == 1;
    }

    public boolean isDarkMatterBlock(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.darkMatterKey, PersistentDataType.BYTE) && (Byte)container.get(this.darkMatterKey, PersistentDataType.BYTE) == 2;
    }

    public boolean isRedMatterBlock(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.redMatterKey, PersistentDataType.BYTE) && (Byte)container.get(this.redMatterKey, PersistentDataType.BYTE) == 2;
    }

    @EventHandler
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        ItemStack fuel = event.getFuel();
        if (fuel == null) {
            return;
        }
        int burnTime = 0;
        if (this.isAlchemicalCoal(fuel)) {
            burnTime = this.burnTimes.get("alchemical_coal");
        } else if (this.isMobiusFuel(fuel)) {
            burnTime = this.burnTimes.get("mobius_fuel");
        } else if (this.isAeternalisFuel(fuel)) {
            burnTime = this.burnTimes.get("aeternalis_fuel");
        } else if (this.isAlchemicalCoalBlock(fuel)) {
            burnTime = this.burnTimes.get("alchemical_coal_block");
        } else if (this.isMobiusFuelBlock(fuel)) {
            burnTime = this.burnTimes.get("mobius_fuel_block");
        } else if (this.isAeternalisFuelBlock(fuel)) {
            burnTime = this.burnTimes.get("aeternalis_fuel_block");
        }
        if (burnTime > 0) {
            event.setBurnTime(burnTime);
        }
    }

    private String getModelDataForFuelType(String fuelType) {
        switch (fuelType) {
            case "alchemical_coal": {
                return "1";
            }
            case "mobius_fuel": {
                return "2";
            }
            case "aeternalis_fuel": {
                return "3";
            }
            case "alchemical_coal_block": {
                return "1";
            }
            case "mobius_fuel_block": {
                return "2";
            }
            case "aeternalis_fuel_block": {
                return "3";
            }
        }
        return "1";
    }

    private boolean isFuelItem(ItemStack item, String fuelType) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING) && fuelType.equals(container.get(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING));
    }

    private boolean isFuelItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING);
    }

    public String getNbtTagInfo() {
        StringBuilder info = new StringBuilder();
        info.append("Special Fuel NBT Tag Info:\n\n");
        info.append("1. Alchemical Coal (CustomModelData: 1)\n");
        info.append("   - NamespacedKey: ").append(this.alchemicalCoalKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 1\n\n");
        info.append("2. Mobius Fuel (CustomModelData: 2)\n");
        info.append("   - NamespacedKey: ").append(this.mobiusFuelKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 1\n\n");
        info.append("3. Aeternalis Fuel (CustomModelData: 3)\n");
        info.append("   - NamespacedKey: ").append(this.aeternalisFuelKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 1\n\n");
        info.append("4. Alchemical Coal Block (CustomModelData: 1)\n");
        info.append("   - NamespacedKey: ").append(this.alchemicalCoalKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 2\n\n");
        info.append("5. Mobius Fuel Block (CustomModelData: 2)\n");
        info.append("   - NamespacedKey: ").append(this.mobiusFuelKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 2\n\n");
        info.append("6. Aeternalis Fuel Block (CustomModelData: 3)\n");
        info.append("   - NamespacedKey: ").append(this.aeternalisFuelKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 2\n\n");
        info.append("7. Dark Matter (Material: SLIME_BALL, CustomModelData: 1)\n");
        info.append("   - NamespacedKey: ").append(this.darkMatterKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 1\n\n");
        info.append("8. Red Matter (Material: SLIME_BALL, CustomModelData: 2)\n");
        info.append("   - NamespacedKey: ").append(this.redMatterKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 1\n\n");
        info.append("9. Dark Matter Block (Material: SLIME_BALL, CustomModelData: 3)\n");
        info.append("   - NamespacedKey: ").append(this.darkMatterKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 2\n\n");
        info.append("10. Red Matter Block (Material: SLIME_BALL, CustomModelData: 4)\n");
        info.append("   - NamespacedKey: ").append(this.redMatterKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 2\n\n");
        return info.toString();
    }

    public void setFuelEmcValues() {
        DatabaseManager db = this.plugin.getDatabaseManager();
        File configFile = new File(this.plugin.getDataFolder(), "custommoditememc.yml");
        YamlConfiguration config = null;
        if (configFile.exists()) {
            config = YamlConfiguration.loadConfiguration((File)configFile);
            this.plugin.getLogger().info("Loaded custom EMC values from custommoditememc.yml");
        } else {
            this.plugin.getLogger().info("custommoditememc.yml not found, using default EMC values");
        }
        long alchemicalCoalEmc = config != null ? config.getLong("alchemical_coal", 512L) : 512L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getAlchemicalCoal()), alchemicalCoalEmc);
        long mobiusFuelEmc = config != null ? config.getLong("mobius_fuel", 2048L) : 2048L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getMobiusFuel()), mobiusFuelEmc);
        long aeternalisFuelEmc = config != null ? config.getLong("aeternalis_fuel", 8192L) : 8192L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getAeternalisFuel()), aeternalisFuelEmc);
        long alchemicalCoalBlockEmc = config != null ? config.getLong("alchemical_coal_block", 4608L) : 4608L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getAlchemicalCoalBlock()), alchemicalCoalBlockEmc);
        long mobiusFuelBlockEmc = config != null ? config.getLong("mobius_fuel_block", 18432L) : 18432L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getMobiusFuelBlock()), mobiusFuelBlockEmc);
        long aeternalisFuelBlockEmc = config != null ? config.getLong("aeternalis_fuel_block", 73728L) : 73728L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getAeternalisFuelBlock()), aeternalisFuelBlockEmc);
        long darkMatterEmc = config != null ? config.getLong("dark_matter", 139264L) : 139264L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getDarkMatter()), darkMatterEmc);
        long redMatterEmc = config != null ? config.getLong("red_matter", 466944L) : 466944L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getRedMatter()), redMatterEmc);
        long darkMatterBlockEmc = config != null ? config.getLong("dark_matter_block", 557056L) : 557056L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getDarkMatterBlock()), darkMatterBlockEmc);
        long redMatterBlockEmc = config != null ? config.getLong("red_matter_block", 1867776L) : 1867776L;
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getRedMatterBlock()), redMatterBlockEmc);
    }

    private void registerCustomBlocks() {
        BlockDataManager bdm = this.plugin.getBlockDataManager();
        bdm.saveBlock("alchemical_coal_block", this.getAlchemicalCoalBlock(), null);
        bdm.saveBlock("mobius_fuel_block", this.getMobiusFuelBlock(), null);
        bdm.saveBlock("aeternalis_fuel_block", this.getAeternalisFuelBlock(), null);
        bdm.saveBlock("dark_matter_block", this.getDarkMatterBlock(), null);
        bdm.saveBlock("red_matter_block", this.getRedMatterBlock(), null);
        this.plugin.getLogger().info("Registered custom fuel blocks with BlockDataManager.");
    }
}

