/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.Little_100.projecte.ProjectE;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private final ProjectE plugin;
    private final List<FileConfiguration> langConfigs = new ArrayList<FileConfiguration>();
    private final Pattern placeholderPattern = Pattern.compile("\\{([^}]+)}");

    public LanguageManager(ProjectE plugin) {
        this.plugin = plugin;
        this.loadLanguageFiles();
    }

    public void loadLanguageFiles() {
        File langFolder;
        this.langConfigs.clear();
        List langNames = this.plugin.getConfig().getStringList("language");
        if (langNames.isEmpty()) {
            langNames.add("zh_cn");
        }
        if (!(langFolder = new File(this.plugin.getDataFolder(), "lang")).exists()) {
            langFolder.mkdirs();
        }
        for (String lang : langNames) {
            String langFileName = "lang/" + lang + ".yml";
            File langFile = new File(this.plugin.getDataFolder(), langFileName);
            if (!langFile.exists()) {
                this.plugin.saveResource(langFileName, false);
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)langFile);
            try (InputStream defLangStream = this.plugin.getResource(langFileName);){
                if (defLangStream != null) {
                    config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defLangStream, StandardCharsets.UTF_8)));
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Could not load language file: " + langFileName);
                e.printStackTrace();
            }
            this.langConfigs.add((FileConfiguration)config);
        }
    }

    public String get(String key) {
        return this.get(key, new HashMap<String, String>());
    }

    public String get(String key, Map<String, String> placeholders) {
        FileConfiguration config;
        String message = null;
        Iterator<FileConfiguration> iterator = this.langConfigs.iterator();
        while (iterator.hasNext() && (message = (config = iterator.next()).getString(key)) == null) {
        }
        if (message == null) {
            this.plugin.getLogger().warning("\u7f3a\u5c11\u7ffb\u8bd1\u952e: " + key);
            this.plugin.getLogger().warning("\u7f3a\u5c11\u7ffb\u8bd1\u952e: " + key);
            return key;
        }
        Matcher matcher = this.placeholderPattern.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String placeholderKey = matcher.group(1);
            String value = placeholders.getOrDefault(placeholderKey, matcher.group(0));
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)sb.toString().replace("\u00a7", "&"));
    }
}

