/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.Tools;

import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.Tools.ToolChargeGUI;
import org.Little_100.projecte.Tools.ToolManager;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ToolChargeGUIListener
implements Listener {
    private final ProjectE plugin;

    public ToolChargeGUIListener(ProjectE plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int oldMode;
        int newMode;
        NamespacedKey katarModeKey;
        int oldCharge;
        int newCharge;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory clickedInventory = event.getClickedInventory();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedInventory == null || clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        String expectedTitle = this.plugin.getLanguageManager().get("clientside.tool_charge_gui.title");
        if (!event.getView().getTitle().equals(expectedTitle)) {
            return;
        }
        event.setCancelled(true);
        ItemMeta clickedMeta = clickedItem.getItemMeta();
        if (clickedMeta == null) {
            return;
        }
        PersistentDataContainer clickedContainer = clickedMeta.getPersistentDataContainer();
        ItemStack tool = player.getInventory().getItemInMainHand();
        ToolManager toolManager = this.plugin.getToolManager();
        if (!toolManager.isProjectETool(tool)) {
            return;
        }
        ItemMeta toolMeta = tool.getItemMeta();
        if (toolMeta == null) {
            return;
        }
        PersistentDataContainer toolContainer = toolMeta.getPersistentDataContainer();
        NamespacedKey chargeKey = new NamespacedKey((Plugin)this.plugin, "charge_level");
        if (clickedContainer.has(chargeKey, PersistentDataType.INTEGER) && (newCharge = ((Integer)clickedContainer.get(chargeKey, PersistentDataType.INTEGER)).intValue()) != (oldCharge = ((Integer)toolContainer.getOrDefault(new NamespacedKey((Plugin)this.plugin, "projecte_charge"), PersistentDataType.INTEGER, (Object)0)).intValue())) {
            if (toolManager.isDarkMatterShovel(tool) && newCharge > 1) {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            toolContainer.set(new NamespacedKey((Plugin)this.plugin, "projecte_charge"), PersistentDataType.INTEGER, (Object)newCharge);
            tool.setItemMeta(toolMeta);
            this.updateDurability(tool, newCharge);
            toolManager.updateToolEfficiency(tool);
            if (toolManager.isRedMatterHammer(tool)) {
                toolManager.updateHammerAttackDamage(tool);
            }
            if (toolManager.isDarkMatterSword(tool) || toolManager.isRedMatterSword(tool)) {
                toolManager.updateSwordAttackDamage(tool);
            }
            if (toolManager.isRedMatterKatar(tool)) {
                toolManager.updateKatarAttackDamage(tool);
            }
            if (newCharge > oldCharge) {
                player.playSound(player.getLocation(), "projecte:custom.pecharge", 1.0f, 1.0f);
            } else {
                player.playSound(player.getLocation(), "projecte:custom.peuncharge", 1.0f, 1.0f);
            }
            new ToolChargeGUI(this.plugin, player, tool).open();
            player.getInventory().setItemInMainHand(tool);
        }
        if (clickedContainer.has(katarModeKey = new NamespacedKey((Plugin)this.plugin, "katar_mode"), PersistentDataType.INTEGER) && (newMode = ((Integer)clickedContainer.get(katarModeKey, PersistentDataType.INTEGER)).intValue()) != (oldMode = ((Integer)toolContainer.getOrDefault(new NamespacedKey((Plugin)this.plugin, "projecte_katar_mode"), PersistentDataType.INTEGER, (Object)0)).intValue())) {
            toolContainer.set(new NamespacedKey((Plugin)this.plugin, "projecte_katar_mode"), PersistentDataType.INTEGER, (Object)newMode);
            tool.setItemMeta(toolMeta);
            toolManager.updateLore(tool);
            player.getInventory().setItemInMainHand(tool);
            player.playSound(player.getLocation(), Sound.BLOCK_LEVER_CLICK, 1.0f, 1.5f);
            new ToolChargeGUI(this.plugin, player, player.getInventory().getItemInMainHand()).open();
        }
    }

    private void updateDurability(ItemStack tool, int newCharge) {
        ItemMeta meta = tool.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return;
        }
        Damageable damageable = (Damageable)meta;
        ToolManager toolManager = this.plugin.getToolManager();
        short maxDurability = tool.getType().getMaxDurability();
        int newDamage = 0;
        if (toolManager.isRedMatterTool(tool)) {
            switch (newCharge) {
                case 0: {
                    newDamage = maxDurability - 2;
                    break;
                }
                case 1: {
                    newDamage = maxDurability * 2 / 3;
                    break;
                }
                case 2: {
                    newDamage = maxDurability / 3;
                    break;
                }
                case 3: {
                    newDamage = maxDurability / 4;
                    break;
                }
                case 4: {
                    newDamage = 1;
                }
            }
        } else {
            switch (newCharge) {
                case 0: {
                    newDamage = maxDurability - 2;
                    break;
                }
                case 1: {
                    newDamage = maxDurability / 2;
                    break;
                }
                case 2: {
                    newDamage = 1;
                }
            }
        }
        damageable.setDamage(newDamage);
        tool.setItemMeta(meta);
        toolManager.updateLore(tool);
    }
}

