/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.accessories;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.Little_100.projecte.LanguageManager;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MindStone {
    private static final NamespacedKey STORED_XP_KEY = new NamespacedKey((Plugin)ProjectE.getInstance(), "stored_xp");

    public static ItemStack createMindStone() {
        ItemStack item = new ItemStack(Material.GOLDEN_HORSE_ARMOR);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            LanguageManager languageManager = ProjectE.getInstance().getLanguageManager();
            meta.setDisplayName(languageManager.get("item.mind_stone.name"));
            List<String> loreKeys = Arrays.asList("item.mind_stone.lore1", "item.mind_stone.lore2", "item.mind_stone.lore3", "item.mind_stone.lore4");
            List lore = loreKeys.stream().map(languageManager::get).collect(Collectors.toList());
            meta.setLore(lore);
            PersistentDataContainer data = meta.getPersistentDataContainer();
            data.set(new NamespacedKey((Plugin)ProjectE.getInstance(), "projecte_id"), PersistentDataType.STRING, (Object)"mind_stone");
            data.set(STORED_XP_KEY, PersistentDataType.INTEGER, (Object)0);
            item.setItemMeta(meta);
            CustomModelDataUtil.setCustomModelDataBoth(item, "mind_stone", 4);
            MindStone.updateLore(item);
        }
        return item;
    }

    public static void activate(Player player, ItemStack item) {
        if (player.isSneaking()) {
            if (player.getTotalExperience() > 0) {
                int xpToStore = player.getTotalExperience();
                player.setTotalExperience(0);
                player.setLevel(0);
                player.setExp(0.0f);
                MindStone.storeXp(item, MindStone.getStoredXp(item) + xpToStore);
                LanguageManager languageManager = ProjectE.getInstance().getLanguageManager();
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("xp", String.valueOf(xpToStore));
                player.sendMessage(languageManager.get("serverside.message.mind_stone.absorbed_xp", placeholders));
            }
        } else {
            int storedXp = MindStone.getStoredXp(item);
            if (storedXp > 0) {
                int amountToGive = Math.min(50, storedXp);
                player.giveExp(amountToGive);
                MindStone.storeXp(item, storedXp - amountToGive);
                LanguageManager languageManager = ProjectE.getInstance().getLanguageManager();
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("xp", String.valueOf(amountToGive));
                player.sendMessage(languageManager.get("serverside.message.mind_stone.retrieved_xp", placeholders));
            }
        }
    }

    private static int getStoredXp(ItemStack item) {
        ItemMeta meta;
        if (item != null && item.hasItemMeta() && (meta = item.getItemMeta()).getPersistentDataContainer().has(STORED_XP_KEY, PersistentDataType.INTEGER)) {
            return (Integer)meta.getPersistentDataContainer().get(STORED_XP_KEY, PersistentDataType.INTEGER);
        }
        return 0;
    }

    private static void storeXp(ItemStack item, int amount) {
        if (item != null && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            meta.getPersistentDataContainer().set(STORED_XP_KEY, PersistentDataType.INTEGER, (Object)amount);
            item.setItemMeta(meta);
            MindStone.updateLore(item);
        }
    }

    public static void updateLore(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null || lore.size() < 4) {
            return;
        }
        int storedXp = MindStone.getStoredXp(item);
        LanguageManager languageManager = ProjectE.getInstance().getLanguageManager();
        String lore4Template = languageManager.get("item.mind_stone.lore4");
        lore.set(3, lore4Template.replace("{xp}", String.valueOf(storedXp)));
        meta.setLore(lore);
        item.setItemMeta(meta);
    }
}

