/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.util.Map;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.devices.CondenserManager;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class CondenserListener
implements Listener {
    private final ProjectE plugin;
    private final CondenserManager condenserManager;

    public CondenserListener(ProjectE plugin) {
        this.plugin = plugin;
        this.condenserManager = plugin.getCondenserManager();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        CondenserManager.CondenserState condenserState = null;
        for (Map.Entry<Location, CondenserManager.CondenserState> entry : this.condenserManager.getActiveCondensers().entrySet()) {
            if (!entry.getValue().getInventory().equals((Object)clickedInventory)) continue;
            condenserState = entry.getValue();
            break;
        }
        if (condenserState != null) {
            int slot = event.getRawSlot();
            CondenserManager.CondenserType type = condenserState.getType();
            if (slot < clickedInventory.getSize()) {
                if (this.condenserManager.isNonInteractive(type, slot)) {
                    event.setCancelled(true);
                }
                if (this.condenserManager.isTargetSlot(type, slot) || event.getCursor() != null) {
                    // empty if block
                }
            }
        }
    }
}

