/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.AlchemicalBag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.Little_100.projecte.AlchemicalBag.InventoryManager;
import org.Little_100.projecte.AlchemicalBag.PlayerInteractListener;
import org.Little_100.projecte.LanguageManager;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;

public class AlchemicalBagManager
implements Listener {
    private final ProjectE plugin;
    private final List<NamespacedKey> registeredRecipeKeys = new ArrayList<NamespacedKey>();
    private final InventoryManager inventoryManager;
    private final LanguageManager languageManager;

    public AlchemicalBagManager(ProjectE plugin) {
        this.plugin = plugin;
        this.inventoryManager = new InventoryManager(plugin, this);
        this.languageManager = plugin.getLanguageManager();
    }

    public void register() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(this.plugin, this, this.inventoryManager), (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.inventoryManager, (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.removeVanillaRecipes();
        this.registerConfiguredRecipes();
    }

    public void unregister() {
        this.unregisterRecipes();
    }

    private void removeVanillaRecipes() {
        try {
            Bukkit.removeRecipe((NamespacedKey)NamespacedKey.minecraft((String)"leather_horse_armor"));
            this.plugin.getLogger().info("Successfully removed vanilla leather horse armor recipe.");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not remove vanilla leather horse armor recipe: " + e.getMessage());
        }
    }

    public void registerConfiguredRecipes() {
        this.registerBaseBagRecipe();
        this.registerDyeingRecipe();
    }

    private void registerBaseBagRecipe() {
        ConfigurationSection recipeConfig = this.plugin.getConfig().getConfigurationSection("AlchemicalBag.recipe");
        if (recipeConfig == null) {
            this.plugin.getLogger().warning("In config.yml, 'AlchemicalBag.recipe' section not found. Cannot register base Alchemical Bag recipe.");
            return;
        }
        List shape = recipeConfig.getStringList("shape");
        ConfigurationSection ingredients = recipeConfig.getConfigurationSection("ingredients");
        if (shape.size() != 3 || ingredients == null) {
            this.plugin.getLogger().warning("Invalid Alchemical Bag recipe definition in config.yml. It must have a 3-line shape and an ingredients section.");
            return;
        }
        ItemStack resultBag = this.createColoredBagItem("DEFAULT");
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "alchemicalbag_base");
        ShapedRecipe recipe = new ShapedRecipe(key, resultBag);
        recipe.shape(new String[]{(String)shape.get(0), (String)shape.get(1), (String)shape.get(2)});
        String fullShape = String.join((CharSequence)"", shape);
        for (String ingredientKey : ingredients.getKeys(false)) {
            char keyChar = ingredientKey.charAt(0);
            if (fullShape.indexOf(keyChar) == -1) {
                this.plugin.getLogger().warning("Ingredient '" + keyChar + "' is defined in the Alchemical Bag recipe ingredients but not used in the shape. It will be ignored.");
                continue;
            }
            String materialName = ingredients.getString(ingredientKey);
            if (materialName.equalsIgnoreCase("any_wool")) {
                recipe.setIngredient(keyChar, (RecipeChoice)new RecipeChoice.MaterialChoice(Arrays.stream(Material.values()).filter(m -> m.name().endsWith("_WOOL")).collect(Collectors.toList())));
                continue;
            }
            Material material = Material.matchMaterial((String)materialName);
            if (material != null) {
                recipe.setIngredient(keyChar, material);
                continue;
            }
            this.plugin.getLogger().warning("Invalid material '" + materialName + "' in Alchemical Bag recipe. Skipping ingredient '" + keyChar + "'.");
        }
        if (Bukkit.addRecipe((Recipe)recipe)) {
            this.registeredRecipeKeys.add(key);
            this.plugin.getLogger().info("Successfully registered the base Alchemical Bag recipe.");
        } else {
            this.plugin.getLogger().warning("Failed to register the base Alchemical Bag recipe.");
        }
    }

    private void registerDyeingRecipe() {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "alchemicalbag_dyeing");
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(Material.LEATHER_HORSE_ARMOR));
        recipe.addIngredient((RecipeChoice)new RecipeChoice.MaterialChoice(Material.LEATHER_HORSE_ARMOR));
        recipe.addIngredient((RecipeChoice)new RecipeChoice.MaterialChoice(Arrays.stream(Material.values()).filter(m -> m.name().endsWith("_DYE")).collect(Collectors.toList())));
        if (Bukkit.addRecipe((Recipe)recipe)) {
            this.registeredRecipeKeys.add(key);
            this.plugin.getLogger().info("Successfully registered the dynamic Alchemical Bag dyeing recipe.");
        } else {
            this.plugin.getLogger().warning("Failed to register the Alchemical Bag dyeing recipe.");
        }
    }

    public void unregisterRecipes() {
        this.plugin.getLogger().info("Unregistering Alchemical Bag custom recipes...");
        int count = 0;
        for (NamespacedKey key : this.registeredRecipeKeys) {
            if (!Bukkit.removeRecipe((NamespacedKey)key)) continue;
            ++count;
        }
        this.plugin.getLogger().info("Successfully unregistered " + count + " Alchemical Bag recipes.");
        this.registeredRecipeKeys.clear();
    }

    public ItemStack createColoredBagItem(String colorIdentifier) {
        String displayName;
        Color bukkitColor;
        ItemStack bag = new ItemStack(Material.LEATHER_HORSE_ARMOR);
        LeatherArmorMeta meta = (LeatherArmorMeta)bag.getItemMeta();
        if (meta == null) {
            return null;
        }
        if (colorIdentifier.equals("DEFAULT")) {
            bukkitColor = Bukkit.getServer().getItemFactory().getDefaultLeatherColor();
            displayName = this.languageManager.get("clientside.alchemical_bag.default_name");
        } else {
            try {
                DyeColor dye = DyeColor.valueOf((String)colorIdentifier.toUpperCase());
                bukkitColor = dye.getColor();
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("color", PlayerInteractListener.getChatColor(colorIdentifier).toString());
                placeholders.put("color_name", colorIdentifier);
                displayName = this.languageManager.get("clientside.alchemical_bag.colored_name", placeholders);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().severe("Could not parse '" + colorIdentifier + "' as a valid color! Cannot create result item.");
                return null;
            }
        }
        meta.setColor(bukkitColor);
        meta.setDisplayName(displayName);
        bag.setItemMeta((ItemMeta)meta);
        return bag;
    }

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (recipe == null || !(recipe instanceof ShapelessRecipe)) {
            return;
        }
        NamespacedKey key = ((ShapelessRecipe)recipe).getKey();
        if (!key.equals((Object)new NamespacedKey((Plugin)this.plugin, "alchemicalbag_dyeing"))) {
            return;
        }
        CraftingInventory inventory = event.getInventory();
        ItemStack[] matrix = inventory.getMatrix();
        ItemStack bag = null;
        ItemStack dye = null;
        for (ItemStack item : matrix) {
            if (item == null || item.getType().isAir()) continue;
            if (item.getType() == Material.LEATHER_HORSE_ARMOR) {
                bag = item;
                continue;
            }
            if (!item.getType().name().endsWith("_DYE")) continue;
            dye = item;
        }
        if (bag == null || dye == null) {
            inventory.setResult(null);
            return;
        }
        LeatherArmorMeta bagMeta = (LeatherArmorMeta)bag.getItemMeta();
        if (bagMeta == null) {
            inventory.setResult(null);
            return;
        }
        DyeColor dyeColor = this.getDyeColor(dye.getType());
        if (dyeColor == null) {
            inventory.setResult(null);
            return;
        }
        ItemStack result = bag.clone();
        LeatherArmorMeta resultMeta = (LeatherArmorMeta)result.getItemMeta();
        resultMeta.setColor(dyeColor.getColor());
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("color", PlayerInteractListener.getChatColor(dyeColor.name()).toString());
        placeholders.put("color_name", dyeColor.name());
        resultMeta.setDisplayName(this.languageManager.get("clientside.alchemical_bag.colored_name", placeholders));
        result.setItemMeta((ItemMeta)resultMeta);
        inventory.setResult(result);
    }

    private DyeColor getDyeColor(Material material) {
        try {
            return DyeColor.valueOf((String)material.name().replace("_DYE", ""));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

