/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.Little_100.projecte.EmcManager;
import org.Little_100.projecte.LanguageManager;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.TransmutationTable.NoEmcItemGUI;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.util.StringUtil;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final ProjectE plugin;
    private final DatabaseManager databaseManager;
    private final EmcManager emcManager;
    private final LanguageManager languageManager;

    public CommandManager(ProjectE plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
        this.emcManager = plugin.getEmcManager();
        this.languageManager = plugin.getLanguageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "setemc": {
                return this.handleSetEmc(sender, args);
            }
            case "debug": {
                return this.handleDebug(sender);
            }
            case "give": {
                return this.handleGiveEmc(sender, args);
            }
            case "noemcitem": {
                return this.handleNoEmcItem(sender);
            }
            case "bag": {
                return this.handleBag(sender, args);
            }
            case "lang": {
                return this.handleLang(sender, args);
            }
            case "report": {
                return this.handleReport(sender);
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.languageManager.get("serverside.command.help.header"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.reload"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.setemc"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.give"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.debug"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.noemcitem"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.bag_list"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.lang"));
        sender.sendMessage(this.languageManager.get("serverside.command.help.report"));
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("projecte.command.reload")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        this.plugin.reloadPlugin();
        sender.sendMessage(this.languageManager.get("serverside.command.reload_success"));
        return true;
    }

    private boolean handleSetEmc(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        if (!sender.hasPermission("projecte.command.setemc")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        if (args.length != 2) {
            sender.sendMessage(this.languageManager.get("serverside.command.set_emc.usage"));
            return true;
        }
        Player player = (Player)sender;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType().isAir()) {
            sender.sendMessage(this.languageManager.get("serverside.command.set_emc.hold_item"));
            return true;
        }
        try {
            long emc = Long.parseLong(args[1]);
            if (emc <= 0L) {
                sender.sendMessage(this.languageManager.get("serverside.command.set_emc.must_be_positive"));
                return true;
            }
            String itemKey = this.plugin.getVersionAdapter().getItemKey(itemInHand);
            this.databaseManager.setEmc(itemKey, emc);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", itemKey);
            placeholders.put("emc", String.valueOf(emc));
            sender.sendMessage(this.languageManager.get("serverside.command.set_emc.success", placeholders));
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("value", args[1]);
            sender.sendMessage(this.languageManager.get("serverside.command.set_emc.invalid_value", placeholders));
        }
        return true;
    }

    private boolean handleDebug(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        if (!sender.hasPermission("projecte.command.debug")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        Player player = (Player)sender;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType().isAir()) {
            sender.sendMessage(this.languageManager.get("serverside.command.set_emc.hold_item"));
            return true;
        }
        String itemKey = this.plugin.getVersionAdapter().getItemKey(itemInHand);
        long emc = this.emcManager.getEmc(itemKey);
        boolean learned = this.databaseManager.isLearned(player.getUniqueId(), itemKey);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("item", itemKey);
        sender.sendMessage(this.languageManager.get("serverside.command.debug.header", placeholders));
        placeholders.put("emc", String.valueOf(emc));
        sender.sendMessage(this.languageManager.get("serverside.command.debug.emc_value", placeholders));
        placeholders.put("learned", learned ? "\u662f" : "\u5426");
        sender.sendMessage(this.languageManager.get("serverside.command.debug.is_learned", placeholders));
        List recipes = Bukkit.getRecipesFor((ItemStack)itemInHand);
        if (recipes.isEmpty()) {
            sender.sendMessage(this.languageManager.get("serverside.command.debug.no_recipe"));
        } else {
            placeholders.put("count", String.valueOf(recipes.size()));
            sender.sendMessage(this.languageManager.get("serverside.command.debug.recipe_found", placeholders));
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                HashMap<String, String> recipePlaceholders = new HashMap<String, String>();
                recipePlaceholders.put("index", String.valueOf(i + 1));
                sender.sendMessage(this.languageManager.get("serverside.command.debug.recipe_header", recipePlaceholders));
                String divisionStrategy = this.plugin.getConfig().getString("TransmutationTable.EMC.divisionStrategy", "floor").toLowerCase();
                List<String> debugInfo = this.plugin.getVersionAdapter().getRecipeDebugInfo(recipe, divisionStrategy);
                for (String line : debugInfo) {
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + line);
                }
            }
        }
        sender.sendMessage(this.languageManager.get("serverside.command.debug.footer"));
        return true;
    }

    private boolean handleGiveEmc(CommandSender sender, String[] args) {
        long amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        if (!sender.hasPermission("projecte.command.give")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        if (args.length != 3) {
            sender.sendMessage(this.languageManager.get("serverside.command.give_emc.usage"));
            return true;
        }
        Player senderPlayer = (Player)sender;
        Player targetPlayer = Bukkit.getPlayer((String)args[1]);
        if (targetPlayer == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", args[1]);
            sender.sendMessage(this.languageManager.get("serverside.command.give_emc.player_not_found", placeholders));
            return true;
        }
        if (targetPlayer.equals((Object)senderPlayer)) {
            sender.sendMessage(this.languageManager.get("serverside.command.give_emc.cant_give_self"));
            return true;
        }
        try {
            amount = Long.parseLong(args[2]);
            if (amount <= 0L) {
                sender.sendMessage(this.languageManager.get("serverside.command.give_emc.must_be_positive"));
                return true;
            }
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", args[2]);
            sender.sendMessage(this.languageManager.get("serverside.command.give_emc.invalid_amount", placeholders));
            return true;
        }
        double feePercentage = this.plugin.getConfig().getDouble("TransmutationTable.transfer-fee-percentage", 0.0);
        long fee = (long)((double)amount * (feePercentage / 100.0));
        long totalDeduction = amount + fee;
        long senderEmc = this.databaseManager.getPlayerEmc(senderPlayer.getUniqueId());
        if (senderEmc < totalDeduction) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("total", String.valueOf(totalDeduction));
            placeholders.put("fee", String.valueOf(fee));
            sender.sendMessage(this.languageManager.get("serverside.command.give_emc.not_enough_emc", placeholders));
            return true;
        }
        long targetEmc = this.databaseManager.getPlayerEmc(targetPlayer.getUniqueId());
        this.databaseManager.setPlayerEmc(senderPlayer.getUniqueId(), senderEmc - totalDeduction);
        this.databaseManager.setPlayerEmc(targetPlayer.getUniqueId(), targetEmc + amount);
        HashMap<String, String> senderPlaceholders = new HashMap<String, String>();
        senderPlaceholders.put("player", targetPlayer.getName());
        senderPlaceholders.put("amount", String.valueOf(amount));
        senderPlaceholders.put("fee", String.valueOf(fee));
        senderPlayer.sendMessage(this.languageManager.get("serverside.command.give_emc.give_success", senderPlaceholders));
        HashMap<String, String> targetPlaceholders = new HashMap<String, String>();
        targetPlaceholders.put("player", senderPlayer.getName());
        targetPlaceholders.put("amount", String.valueOf(amount));
        targetPlayer.sendMessage(this.languageManager.get("serverside.command.give_emc.receive_success", targetPlaceholders));
        return true;
    }

    private boolean handleNoEmcItem(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        if (!sender.hasPermission("projecte.command.noemcitem")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        Player player = (Player)sender;
        ArrayList<ItemStack> noEmcItems = new ArrayList<ItemStack>();
        for (Material material : Material.values()) {
            if (!material.isItem() || material.isAir() || material.name().startsWith("LEGACY_")) continue;
            ItemStack item = new ItemStack(material);
            String itemKey = this.plugin.getVersionAdapter().getItemKey(item);
            if (this.emcManager.getEmc(itemKey) != 0L) continue;
            noEmcItems.add(item);
        }
        if (noEmcItems.isEmpty()) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_emc_item.all_have_emc"));
            return true;
        }
        new NoEmcItemGUI(noEmcItems, 0).openInventory(player);
        return true;
    }

    private boolean handleBag(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.get("serverside.command.player_only"));
            return true;
        }
        if (!sender.hasPermission("projecte.command.bag")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        if (args.length < 2 || !args[1].equalsIgnoreCase("list")) {
            sender.sendMessage(this.languageManager.get("serverside.command.bag.usage"));
            return true;
        }
        Player player = (Player)sender;
        List<String> bagColors = this.databaseManager.getBagColors(player.getUniqueId());
        if (bagColors.isEmpty()) {
            sender.sendMessage(this.languageManager.get("serverside.command.bag.no_bags"));
            return true;
        }
        sender.sendMessage(this.languageManager.get("serverside.command.bag.list_header"));
        for (String colorName : bagColors) {
            try {
                ChatColor chatColor = ChatColor.valueOf((String)colorName.toUpperCase());
                sender.sendMessage(String.valueOf(chatColor) + "- " + colorName);
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(String.valueOf(ChatColor.WHITE) + "- " + colorName);
            }
        }
        return true;
    }

    private boolean handleLang(CommandSender sender, String[] args) {
        if (!sender.hasPermission("projecte.command.lang")) {
            sender.sendMessage(this.languageManager.get("serverside.command.no_permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.languageManager.get("serverside.command.lang.usage"));
            return true;
        }
        String action = args[1].toLowerCase();
        if (action.equals("list")) {
            sender.sendMessage(this.languageManager.get("serverside.command.lang.list_header"));
            File langFolder = this.plugin.getDataFolder();
            File[] files = langFolder.listFiles((dir, name) -> name.endsWith(".yml") && !name.equals("config.yml"));
            if (files != null) {
                for (File file : files) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "- " + file.getName().replace(".yml", ""));
                }
            }
            return true;
        }
        if (action.equals("set")) {
            if (args.length < 3) {
                sender.sendMessage(this.languageManager.get("serverside.command.lang.usage"));
                return true;
            }
            ArrayList<String> newLangs = new ArrayList<String>(Arrays.asList(args).subList(2, args.length));
            for (String lang : newLangs) {
                File langFile = new File(this.plugin.getDataFolder(), lang + ".yml");
                if (langFile.exists()) continue;
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("file", lang + ".yml");
                sender.sendMessage(this.languageManager.get("serverside.command.lang.file_not_found", placeholders));
                return true;
            }
            this.plugin.getConfig().set("language", newLangs);
            this.plugin.saveConfig();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("languages", String.join((CharSequence)", ", newLangs));
            sender.sendMessage(this.languageManager.get("serverside.command.lang.set_success", placeholders));
            return true;
        }
        sender.sendMessage(this.languageManager.get("serverside.command.lang.usage"));
        return true;
    }

    private boolean handleReport(CommandSender sender) {
        sender.sendMessage(this.languageManager.get("serverside.command.report.message"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("reload", "setemc", "debug", "give", "noemcitem", "bag", "lang", "report");
            return (List)StringUtil.copyPartialMatches((String)args[0], subCommands, new ArrayList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("give")) {
                ArrayList<String> playerNames = new ArrayList<String>();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    playerNames.add(player.getName());
                }
                return (List)StringUtil.copyPartialMatches((String)args[1], playerNames, new ArrayList());
            }
            if (args[0].equalsIgnoreCase("bag")) {
                return (List)StringUtil.copyPartialMatches((String)args[1], Collections.singletonList("list"), new ArrayList());
            }
            if (args[0].equalsIgnoreCase("lang")) {
                return (List)StringUtil.copyPartialMatches((String)args[1], Arrays.asList("list", "set"), new ArrayList());
            }
        }
        if (args.length >= 3 && args[0].equalsIgnoreCase("lang") && args[1].equalsIgnoreCase("set")) {
            ArrayList<String> langFiles = new ArrayList<String>();
            File langFolder = this.plugin.getDataFolder();
            File[] files = langFolder.listFiles((dir, name) -> name.endsWith(".yml") && !name.equals("config.yml"));
            if (files != null) {
                for (File file : files) {
                    langFiles.add(file.getName().replace(".yml", ""));
                }
            }
            return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], langFiles, new ArrayList());
        }
        return new ArrayList<String>();
    }
}

