/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.compatibility.VersionAdapter;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class EmcManager {
    private final ProjectE plugin;
    private final DatabaseManager databaseManager;
    private final VersionAdapter versionAdapter;
    private final String recipeConflictStrategy;
    private final String divisionStrategy;
    private final Set<String> currentlyCalculating = new HashSet<String>();

    public EmcManager(ProjectE plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
        this.versionAdapter = plugin.getVersionAdapter();
        this.recipeConflictStrategy = plugin.getConfig().getString("TransmutationTable.EMC.recipeConflictStrategy", "lowest").toLowerCase();
        this.divisionStrategy = plugin.getConfig().getString("TransmutationTable.EMC.divisionStrategy", "floor").toLowerCase();
    }

    public void calculateAndStoreEmcValues() {
        this.plugin.getLogger().info("\u5f00\u59cb\u8ba1\u7b97EMC\u503c...");
        this.versionAdapter.loadInitialEmcValues();
        for (int i = 0; i < 10; ++i) {
            this.plugin.getLogger().info("EMC\u8ba1\u7b97\u8fed\u4ee3\u7b2c " + (i + 1) + " \u8f6e...");
            boolean changed = false;
            Iterator recipeIterator = Bukkit.recipeIterator();
            while (recipeIterator.hasNext()) {
                Recipe recipe = (Recipe)recipeIterator.next();
                if (!this.calculateEmcForRecipe(recipe)) continue;
                changed = true;
            }
            if (changed) continue;
            this.plugin.getLogger().info("EMC\u503c\u5df2\u7a33\u5b9a\uff0c\u63d0\u524d\u7ed3\u675f\u8ba1\u7b97\u3002");
            break;
        }
        this.plugin.getLogger().info("EMC\u503c\u8ba1\u7b97\u5b8c\u6210\u3002");
    }

    private boolean calculateEmcForRecipe(Recipe recipe) {
        ItemStack result = recipe.getResult();
        if (result == null || result.getType().isAir()) {
            return false;
        }
        String resultKey = this.versionAdapter.getItemKey(result);
        long existingEmc = this.databaseManager.getEmc(resultKey);
        long newEmc = this.versionAdapter.calculateRecipeEmc(recipe, this.divisionStrategy);
        if (newEmc <= 0L) {
            return false;
        }
        if (existingEmc <= 0L) {
            this.databaseManager.setEmc(resultKey, newEmc);
            return true;
        }
        boolean updated = false;
        if ("lowest".equals(this.recipeConflictStrategy) && newEmc < existingEmc) {
            this.databaseManager.setEmc(resultKey, newEmc);
            updated = true;
        } else if ("highest".equals(this.recipeConflictStrategy) && newEmc > existingEmc) {
            this.databaseManager.setEmc(resultKey, newEmc);
            updated = true;
        }
        return updated;
    }

    public long getEmc(String itemKey) {
        long emc = this.databaseManager.getEmc(itemKey);
        if (emc > 0L) {
            return emc;
        }
        if (this.currentlyCalculating.contains(itemKey)) {
            return 0L;
        }
        this.currentlyCalculating.add(itemKey);
        long lowestEmc = -1L;
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            long calculatedEmc;
            Recipe recipe = (Recipe)recipeIterator.next();
            ItemStack result = recipe.getResult();
            if (result == null || !this.versionAdapter.getItemKey(result).equals(itemKey) || (calculatedEmc = this.versionAdapter.calculateRecipeEmc(recipe, this.divisionStrategy)) <= 0L || lowestEmc != -1L && calculatedEmc >= lowestEmc) continue;
            lowestEmc = calculatedEmc;
        }
        this.currentlyCalculating.remove(itemKey);
        if (lowestEmc > 0L) {
            this.databaseManager.setEmc(itemKey, lowestEmc);
            return lowestEmc;
        }
        return 0L;
    }
}

