/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.TransmutationTable.TransmutationGUI;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class PhilosopherStoneListener
implements Listener {
    private final ProjectE plugin;

    public PhilosopherStoneListener(ProjectE plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (this.plugin.isPhilosopherStone(heldItem) && player.isSneaking() && (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK)) {
            event.setCancelled(true);
            player.openWorkbench(null, true);
            player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.PETRIFIED_OAK_SLAB && this.plugin.getConfig().getBoolean("TransmutationTable.enabled", true)) {
            Slab slab;
            if (!player.hasPermission("philosophersstone.interact.transmutationtable")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8f6c\u6362\u684c\u3002");
                return;
            }
            if (event.getClickedBlock().getBlockData() instanceof Slab && (slab = (Slab)event.getClickedBlock().getBlockData()).getType() == Slab.Type.BOTTOM && !player.isSneaking()) {
                event.setCancelled(true);
                new TransmutationGUI(player).open();
            }
        }
    }

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        ShapedRecipe shapedRecipe;
        CraftingInventory inventory = event.getInventory();
        Recipe recipe = event.getRecipe();
        if (recipe instanceof ShapedRecipe && (shapedRecipe = (ShapedRecipe)recipe).getKey().equals((Object)this.plugin.getPhilosopherStoneKey())) {
            inventory.setResult(this.plugin.getPhilosopherStone());
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (event.isCancelled() || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        CraftingInventory inventory = event.getInventory();
        ItemStack[] matrix = inventory.getMatrix();
        ItemStack philosopherStone = null;
        int stoneSlot = -1;
        for (int i = 0; i < matrix.length; ++i) {
            if (!this.plugin.isPhilosopherStone(matrix[i])) continue;
            philosopherStone = matrix[i].clone();
            stoneSlot = i;
            break;
        }
        if (philosopherStone == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        NamespacedKey recipeKey = null;
        if (event.getRecipe() instanceof ShapedRecipe) {
            recipeKey = ((ShapedRecipe)event.getRecipe()).getKey();
        } else if (event.getRecipe() instanceof ShapelessRecipe) {
            recipeKey = ((ShapelessRecipe)event.getRecipe()).getKey();
        }
        if (recipeKey != null && recipeKey.equals((Object)this.plugin.getPhilosopherStoneKey())) {
            if (this.hasPhilosopherStone((HumanEntity)player)) {
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u5df2\u7ecf\u62e5\u6709\u4e00\u4e2a\u8d24\u8005\u4e4b\u77f3\u4e86\uff01");
            }
            return;
        }
        if (event.isShiftClick()) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f7f\u7528\u8d24\u8005\u4e4b\u77f3\u5408\u6210\u65f6\u4e0d\u652f\u6301Shift\u70b9\u51fb\uff01");
            return;
        }
        int finalStoneSlot = stoneSlot + 1;
        ItemStack finalPhilosopherStone = philosopherStone;
        ProjectE.getInstance().getSchedulerAdapter().runTaskLater(() -> {
            inventory.setItem(finalStoneSlot, finalPhilosopherStone);
            player.updateInventory();
        }, 1L);
    }

    private boolean hasPhilosopherStone(HumanEntity player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (!this.plugin.isPhilosopherStone(item)) continue;
            return true;
        }
        return false;
    }
}

