/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.util.HashMap;
import java.util.Map;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

public class RecipeManager {
    private final ProjectE plugin;
    private final Map<String, NamespacedKey> recipeKeys = new HashMap<String, NamespacedKey>();

    public RecipeManager(ProjectE plugin) {
        this.plugin = plugin;
    }

    public void registerAllRecipes() {
        this.registerPhilosopherStoneRecipe();
        this.registerUpgradeRecipes();
        this.registerDowngradeRecipes();
        this.registerTransmutationTableRecipes();
        this.registerOreTransmutationRecipes();
    }

    private void registerTransmutationTableRecipes() {
        Map<String, NamespacedKey> newKeys = this.plugin.getVersionAdapter().registerTransmutationTableRecipes();
        this.recipeKeys.putAll(newKeys);
    }

    private void registerUpgradeRecipes() {
        ItemStack philosopherStone = this.plugin.getPhilosopherStone();
        this.registerUpgradeRecipe("coal_to_copper", Material.COAL, Material.COPPER_INGOT, 4, 1, philosopherStone);
        this.registerUpgradeRecipe("copper_to_iron", Material.COPPER_INGOT, Material.IRON_INGOT, 4, 1, philosopherStone);
        this.registerUpgradeRecipe("iron_to_gold", Material.IRON_INGOT, Material.GOLD_INGOT, 4, 1, philosopherStone);
        this.registerUpgradeRecipe("gold_to_diamond", Material.GOLD_INGOT, Material.DIAMOND, 4, 1, philosopherStone);
        this.registerSpecialUpgradeRecipe("diamond_to_netherite", Material.DIAMOND_BLOCK, Material.NETHERITE_INGOT, 8, 1, philosopherStone);
    }

    private void registerDowngradeRecipes() {
        ItemStack philosopherStone = this.plugin.getPhilosopherStone();
        this.registerDowngradeRecipe("copper_to_coal", Material.COPPER_INGOT, Material.COAL, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("iron_to_copper", Material.IRON_INGOT, Material.COPPER_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("gold_to_iron", Material.GOLD_INGOT, Material.IRON_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("diamond_to_gold", Material.DIAMOND, Material.GOLD_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("netherite_to_diamond", Material.NETHERITE_INGOT, Material.DIAMOND_BLOCK, 1, 8, philosopherStone);
    }

    private void registerUpgradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "upgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("upgrade_" + id, key);
    }

    private void registerSpecialUpgradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "special_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("special_" + id, key);
    }

    private void registerDowngradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "downgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("downgrade_" + id, key);
    }

    private void registerPhilosopherStoneRecipe() {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "philosopher_stone");
        ItemStack philosopherStone = this.plugin.getPhilosopherStone();
        ShapedRecipe recipe = new ShapedRecipe(key, philosopherStone);
        recipe.shape(new String[]{"RGR", "GDG", "RGR"});
        recipe.setIngredient('R', Material.REDSTONE);
        recipe.setIngredient('G', Material.GLOWSTONE_DUST);
        recipe.setIngredient('D', Material.DIAMOND);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("philosopher_stone", key);
    }

    public Map<String, NamespacedKey> getRecipeKeys() {
        return this.recipeKeys;
    }

    public void unregisterAllRecipes() {
        for (NamespacedKey key : this.recipeKeys.values()) {
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        this.recipeKeys.clear();
    }

    private void registerOreTransmutationRecipes() {
        RecipeChoice.ExactChoice catalyst = new RecipeChoice.ExactChoice(this.plugin.getPhilosopherStone());
        RecipeChoice.MaterialChoice fuel = new RecipeChoice.MaterialChoice(new Material[]{Material.COAL, Material.CHARCOAL});
        this.registerOreTransmutationRecipe("iron", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.RAW_IRON}), new ItemStack(Material.IRON_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("gold", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.RAW_GOLD}), new ItemStack(Material.GOLD_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("copper", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.RAW_COPPER}), new ItemStack(Material.COPPER_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("diamond", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE}), new ItemStack(Material.DIAMOND, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("netherite", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.ANCIENT_DEBRIS), new ItemStack(Material.NETHERITE_SCRAP, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
    }

    private void registerOreTransmutationRecipe(String id, RecipeChoice oreChoice, ItemStack result, RecipeChoice catalyst, RecipeChoice fuel) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "transmute_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, result);
        for (int i = 0; i < 7; ++i) {
            recipe.addIngredient(oreChoice);
        }
        recipe.addIngredient(fuel);
        recipe.addIngredient(catalyst);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("transmute_" + id, key);
    }
}

