/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.TransmutationTable;

import java.util.Arrays;
import java.util.HashMap;
import org.Little_100.projecte.LanguageManager;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.TransmutationTable.NoEmcItemGUI;
import org.Little_100.projecte.TransmutationTable.TransmutationGUI;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof NoEmcItemGUI) {
            this.handleNoEmcItemGUIClick(event);
            return;
        }
        if (!(holder instanceof TransmutationGUI)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        TransmutationGUI gui = (TransmutationGUI)holder;
        if (gui.getCurrentState() == TransmutationGUI.GuiState.SELL) {
            if (event.getClickedInventory() == player.getInventory() || this.isTransactionArea(event.getSlot())) {
                event.setCancelled(false);
                this.updateSellButton(gui);
                return;
            }
        } else if (gui.getCurrentState() == TransmutationGUI.GuiState.LEARN && (event.getClickedInventory() == player.getInventory() || this.isTransactionArea(event.getSlot()))) {
            event.setCancelled(false);
            return;
        }
        if (event.getClickedInventory() != gui.getInventory()) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        switch (gui.getCurrentState()) {
            case MAIN: {
                this.handleMainScreenClick(event, gui);
                break;
            }
            case SELL: {
                this.handleSellScreenClick(event, gui);
                break;
            }
            case BUY: {
                this.handleBuyScreenClick(event, gui);
                break;
            }
            case LEARN: {
                this.handleLearnScreenClick(event, gui);
            }
        }
    }

    private void handleMainScreenClick(InventoryClickEvent event, TransmutationGUI gui) {
        int slot = event.getSlot();
        if (slot == 21) {
            gui.setState(TransmutationGUI.GuiState.SELL);
        } else if (slot == 23) {
            gui.setState(TransmutationGUI.GuiState.BUY);
        } else if (slot == 22) {
            gui.setState(TransmutationGUI.GuiState.LEARN);
        }
    }

    private void handleSellScreenClick(InventoryClickEvent event, TransmutationGUI gui) {
        int slot = event.getSlot();
        if (slot == 0) {
            gui.setState(TransmutationGUI.GuiState.MAIN);
        } else if (slot == 49) {
            this.handleTransaction(event.getWhoClicked(), gui);
        }
    }

    private void updateSellButton(TransmutationGUI gui) {
        ProjectE.getInstance().getSchedulerAdapter().runTaskLater(() -> {
            ItemMeta meta;
            Inventory inventory = gui.getInventory();
            long totalEmcChange = 0L;
            for (int i = 0; i < 54; ++i) {
                long itemEmc;
                ItemStack item;
                if (!this.isTransactionArea(i) || (item = inventory.getItem(i)) == null || item.getType().isAir() || (itemEmc = ProjectE.getInstance().getEmcManager().getEmc(ProjectE.getInstance().getVersionAdapter().getItemKey(item))) <= 0L) continue;
                totalEmcChange += itemEmc * (long)item.getAmount();
            }
            ItemStack confirmButton = inventory.getItem(49);
            if (confirmButton != null && (meta = confirmButton.getItemMeta()) != null) {
                String formattedEmc = String.format("%,d", totalEmcChange);
                LanguageManager lang = ProjectE.getInstance().getLanguageManager();
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("emc", formattedEmc);
                meta.setLore(Arrays.asList(lang.get("clientside.transmutation_table.buttons.confirm_transaction_lore"), lang.get("clientside.transmutation_table.buttons.you_will_get", placeholders)));
                confirmButton.setItemMeta(meta);
            }
        }, 1L);
    }

    private void handleBuyScreenClick(InventoryClickEvent event, TransmutationGUI gui) {
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (event.getClickedInventory() != gui.getInventory()) {
            return;
        }
        if (slot == 0) {
            gui.setState(TransmutationGUI.GuiState.MAIN);
            return;
        }
        if (slot == 48) {
            if (gui.getPage() > 0) {
                gui.setPage(gui.getPage() - 1);
            }
            return;
        }
        if (slot == 50) {
            gui.setPage(gui.getPage() + 1);
            return;
        }
        if (slot < 9 || slot > 44 || slot % 9 == 0 || slot % 9 == 8) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && !clickedItem.getType().isAir()) {
            long totalCost;
            int amountToBuy;
            String itemKey = ProjectE.getInstance().getVersionAdapter().getItemKey(clickedItem);
            long itemEmc = ProjectE.getInstance().getEmcManager().getEmc(itemKey);
            if (itemEmc <= 0L) {
                return;
            }
            long playerEmc = ProjectE.getInstance().getDatabaseManager().getPlayerEmc(player.getUniqueId());
            if (ProjectE.getInstance().isPhilosopherStone(clickedItem)) {
                if (player.getInventory().containsAtLeast(ProjectE.getInstance().getPhilosopherStone(), 1)) {
                    player.sendMessage(ProjectE.getInstance().getLanguageManager().get("serverside.command.generic.already_have_philosopher_stone"));
                    return;
                }
                amountToBuy = 1;
                totalCost = itemEmc;
            } else if (event.isLeftClick()) {
                amountToBuy = 1;
                totalCost = itemEmc;
            } else if (event.isRightClick()) {
                amountToBuy = clickedItem.getMaxStackSize();
                totalCost = itemEmc * (long)amountToBuy;
            } else {
                return;
            }
            if (amountToBuy > 0) {
                if (playerEmc >= totalCost) {
                    ItemStack tempItem;
                    ItemMeta tempMeta;
                    ItemStack purchasedItem;
                    ProjectE.getInstance().getDatabaseManager().setPlayerEmc(player.getUniqueId(), playerEmc - totalCost);
                    if (ProjectE.getInstance().isPhilosopherStone(clickedItem)) {
                        purchasedItem = ProjectE.getInstance().getPhilosopherStone();
                        purchasedItem.setAmount(1);
                    } else {
                        purchasedItem = clickedItem.clone();
                        purchasedItem.setAmount(amountToBuy);
                        ItemMeta meta = purchasedItem.getItemMeta();
                        if (meta != null) {
                            meta.setLore(null);
                            meta.setDisplayName(null);
                            purchasedItem.setItemMeta(meta);
                        }
                    }
                    player.getInventory().addItem(new ItemStack[]{purchasedItem});
                    ItemMeta meta = purchasedItem.getItemMeta();
                    String displayName = meta != null && meta.hasDisplayName() ? meta.getDisplayName() : ((tempMeta = (tempItem = new ItemStack(purchasedItem.getType())).getItemMeta()) != null && tempMeta.hasDisplayName() ? tempMeta.getDisplayName() : tempItem.getType().name());
                    LanguageManager lang = ProjectE.getInstance().getLanguageManager();
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("amount", String.valueOf(amountToBuy));
                    placeholders.put("item", displayName);
                    player.sendMessage(lang.get("serverside.command.generic.buy_success", placeholders));
                    this.refreshGui(player, TransmutationGUI.GuiState.BUY, gui.getPage());
                } else {
                    player.sendMessage(ProjectE.getInstance().getLanguageManager().get("serverside.command.generic.not_enough_emc"));
                }
            }
        }
    }

    private void handleTransaction(HumanEntity humanEntity, TransmutationGUI gui) {
        int i;
        Player player = (Player)humanEntity;
        Inventory inventory = gui.getInventory();
        long totalEmcChange = 0L;
        boolean transactionValid = true;
        for (i = 0; i < 54; ++i) {
            ItemStack item;
            if (!this.isTransactionArea(i) || (item = inventory.getItem(i)) == null || item.getType().isAir()) continue;
            String itemKey = ProjectE.getInstance().getVersionAdapter().getItemKey(item);
            long itemEmc = ProjectE.getInstance().getEmcManager().getEmc(itemKey);
            if (itemEmc > 0L) {
                totalEmcChange += itemEmc * (long)item.getAmount();
                ProjectE.getInstance().getDatabaseManager().addLearnedItem(player.getUniqueId(), itemKey);
                continue;
            }
            LanguageManager lang = ProjectE.getInstance().getLanguageManager();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", item.getType().name());
            player.sendMessage(lang.get("serverside.command.generic.no_emc_value_trade", placeholders));
            player.getInventory().addItem(new ItemStack[]{item});
            inventory.setItem(i, null);
            transactionValid = false;
        }
        if (!transactionValid) {
            player.sendMessage(ProjectE.getInstance().getLanguageManager().get("serverside.command.generic.partial_trade_fail"));
            return;
        }
        if (totalEmcChange > 0L) {
            long currentEmc = ProjectE.getInstance().getDatabaseManager().getPlayerEmc(player.getUniqueId());
            long newEmc = currentEmc + totalEmcChange;
            ProjectE.getInstance().getDatabaseManager().setPlayerEmc(player.getUniqueId(), newEmc);
            LanguageManager lang = ProjectE.getInstance().getLanguageManager();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("emc", String.format("%,d", totalEmcChange));
            player.sendMessage(lang.get("serverside.command.generic.sell_success", placeholders));
        }
        for (i = 0; i < 54; ++i) {
            if (!this.isTransactionArea(i)) continue;
            inventory.setItem(i, null);
        }
        this.refreshGui(player, TransmutationGUI.GuiState.SELL, 0);
    }

    private void handleLearnScreenClick(InventoryClickEvent event, TransmutationGUI gui) {
        int slot = event.getSlot();
        if (event.getClickedInventory() != gui.getInventory()) {
            return;
        }
        if (slot == 0) {
            gui.setState(TransmutationGUI.GuiState.MAIN);
        } else if (slot == 49) {
            this.handleLearn(event.getWhoClicked(), gui);
        } else if (this.isTransactionArea(slot)) {
            event.setCancelled(false);
        }
    }

    private void handleLearn(HumanEntity humanEntity, TransmutationGUI gui) {
        ItemStack item;
        int i;
        Player player = (Player)humanEntity;
        Inventory inventory = gui.getInventory();
        boolean learnedSomething = false;
        for (i = 0; i < 54; ++i) {
            if (!this.isTransactionArea(i) || (item = inventory.getItem(i)) == null || item.getType().isAir()) continue;
            String itemKey = ProjectE.getInstance().getVersionAdapter().getItemKey(item);
            long itemEmc = ProjectE.getInstance().getEmcManager().getEmc(itemKey);
            if (itemEmc > 0L) {
                ProjectE.getInstance().getDatabaseManager().addLearnedItem(player.getUniqueId(), itemKey);
                learnedSomething = true;
                continue;
            }
            LanguageManager lang = ProjectE.getInstance().getLanguageManager();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", item.getType().name());
            player.sendMessage(lang.get("serverside.command.generic.no_emc_value_learn", placeholders));
        }
        if (learnedSomething) {
            player.sendMessage(ProjectE.getInstance().getLanguageManager().get("serverside.command.generic.learn_success"));
        }
        for (i = 0; i < 54; ++i) {
            if (!this.isTransactionArea(i) || (item = inventory.getItem(i)) == null || item.getType().isAir()) continue;
            player.getInventory().addItem(new ItemStack[]{item});
            inventory.setItem(i, null);
        }
        player.closeInventory();
    }

    private void refreshGui(Player player, TransmutationGUI.GuiState state, int page) {
        player.closeInventory();
        ProjectE.getInstance().getSchedulerAdapter().runTaskLater(() -> {
            TransmutationGUI newGui = new TransmutationGUI(player);
            newGui.setState(state);
            newGui.setPage(page);
            newGui.open();
        }, 1L);
    }

    private boolean isTransactionArea(int slot) {
        return slot > 9 && slot < 44 && slot % 9 != 0 && slot % 9 != 8;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof TransmutationGUI)) {
            return;
        }
        TransmutationGUI gui = (TransmutationGUI)holder;
        if (gui.getCurrentState() == TransmutationGUI.GuiState.SELL || gui.getCurrentState() == TransmutationGUI.GuiState.LEARN) {
            Inventory inventory = event.getInventory();
            Player player = (Player)event.getPlayer();
            for (int i = 0; i < 54; ++i) {
                ItemStack item;
                if (!this.isTransactionArea(i) || (item = inventory.getItem(i)) == null || item.getType().isAir()) continue;
                player.getInventory().addItem(new ItemStack[]{item});
            }
        }
    }

    private void handleNoEmcItemGUIClick(InventoryClickEvent event) {
        int startIndex;
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        NoEmcItemGUI gui = (NoEmcItemGUI)event.getInventory().getHolder();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 45 && gui.getPage() > 0) {
            new NoEmcItemGUI(gui.getItems(), gui.getPage() - 1).openInventory(player);
        } else if (slot == 53 && (startIndex = (gui.getPage() + 1) * 45) < gui.getItems().size()) {
            new NoEmcItemGUI(gui.getItems(), gui.getPage() + 1).openInventory(player);
        }
    }
}

