/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.managers;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.Little_100.projecte.Debug;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.compatibility.version.VersionAdapter;
import org.Little_100.projecte.devices.AlchemicalChest;
import org.Little_100.projecte.devices.DarkMatterFurnace;
import org.Little_100.projecte.devices.EnergyCondenser;
import org.Little_100.projecte.devices.EnergyCondenserMK2;
import org.Little_100.projecte.devices.RedMatterFurnace;
import org.Little_100.projecte.storage.DatabaseManager;
import org.Little_100.projecte.util.Constants;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class EmcManager {
    private final ProjectE plugin;
    private final DatabaseManager databaseManager;
    private final VersionAdapter versionAdapter;
    private final String recipeConflictStrategy;
    private final String divisionStrategy;
    private final Set<String> currentlyCalculating = new HashSet<String>();

    public EmcManager(ProjectE plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
        this.versionAdapter = plugin.getVersionAdapter();
        this.recipeConflictStrategy = plugin.getConfig().getString("gui.EMC.recipeConflictStrategy", "lowest").toLowerCase();
        this.divisionStrategy = plugin.getConfig().getString("gui.EMC.divisionStrategy", "floor").toLowerCase();
        File customEmcFile = new File(plugin.getDataFolder(), "custommoditememc.yml");
        if (!customEmcFile.exists()) {
            plugin.getLogger().info("custommoditememc.yml not found, creating default file.");
            plugin.saveResource("custommoditememc.yml", false);
        }
    }

    public void calculateAndStoreEmcValues(boolean forceRecalculate) {
        if (!forceRecalculate && this.databaseManager.hasEmcValues()) {
            this.plugin.getLogger().info("EMC values already exist in the database. Skipping calculation.");
            return;
        }
        if (forceRecalculate) {
            this.databaseManager.clearEmcValues();
        }
        this.plugin.getLogger().info("Start calculating EMC values...");
        this.versionAdapter.loadInitialEmcValues();
        for (int i = 0; i < 10; ++i) {
            this.plugin.getLogger().info("EMC calculation iteration " + (i + 1) + "...");
            boolean changed = false;
            Iterator recipeIterator = Bukkit.recipeIterator();
            while (recipeIterator.hasNext()) {
                try {
                    Recipe recipe = (Recipe)recipeIterator.next();
                    if (!this.calculateEmcForRecipe(recipe)) continue;
                    changed = true;
                }
                catch (Exception exception) {}
            }
            if (changed) continue;
            this.plugin.getLogger().info("EMC values stabilized, calculation ended early.");
            break;
        }
        this.plugin.getLogger().info("EMC value calculation completed.");
    }

    private boolean calculateEmcForRecipe(Recipe recipe) {
        ItemStack result = recipe.getResult();
        if (result.getType().isAir()) {
            return false;
        }
        if (this.plugin.isPdcExcluded() && this.isPdcItem(result)) {
            return false;
        }
        if (this.plugin.isOnlyMcItems()) {
            if (recipe instanceof ShapedRecipe) {
                for (ItemStack ingredient : ((ShapedRecipe)recipe).getIngredientMap().values()) {
                    if (!this.isPdcItem(ingredient)) continue;
                    return false;
                }
            } else if (recipe instanceof ShapelessRecipe) {
                for (ItemStack ingredient : ((ShapelessRecipe)recipe).getIngredientList()) {
                    if (!this.isPdcItem(ingredient)) continue;
                    return false;
                }
            } else if (recipe instanceof CookingRecipe && this.isPdcItem(((CookingRecipe)recipe).getInput())) {
                return false;
            }
        }
        NamespacedKey key = null;
        if (recipe instanceof ShapedRecipe) {
            key = ((ShapedRecipe)recipe).getKey();
        } else if (recipe instanceof ShapelessRecipe) {
            key = ((ShapelessRecipe)recipe).getKey();
        } else if (recipe instanceof CookingRecipe) {
            key = ((CookingRecipe)recipe).getKey();
        }
        if (key != null && key.getNamespace().equalsIgnoreCase("projecte")) {
            return false;
        }
        String resultKey = this.getItemKey(result);
        long existingEmc = this.getEmc(resultKey);
        long newEmc = this.versionAdapter.calculateRecipeEmc(recipe, this.divisionStrategy);
        if (newEmc <= 0L) {
            return false;
        }
        if (existingEmc <= 0L) {
            this.databaseManager.setEmc(resultKey, newEmc);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", resultKey);
            placeholders.put("emc", String.valueOf(newEmc));
            Debug.log("debug.emc.item_emc_info", placeholders);
            return true;
        }
        boolean updated = false;
        if ("lowest".equals(this.recipeConflictStrategy) && newEmc < existingEmc) {
            this.databaseManager.setEmc(resultKey, newEmc);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", resultKey);
            placeholders.put("emc", String.valueOf(newEmc));
            Debug.log("debug.emc.item_emc_info", placeholders);
            updated = true;
        } else if ("highest".equals(this.recipeConflictStrategy) && newEmc > existingEmc) {
            this.databaseManager.setEmc(resultKey, newEmc);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", resultKey);
            placeholders.put("emc", String.valueOf(newEmc));
            Debug.log("debug.emc.item_emc_info", placeholders);
            updated = true;
        }
        return updated;
    }

    public long getEmc(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return 0L;
        }
        if (this.plugin.isOnlyMcItems() && item.hasItemMeta() && item.getItemMeta().hasCustomModelData()) {
            return this.databaseManager.getEmc(this.getItemKey(item));
        }
        if (this.plugin.isPdcExcluded() && this.isPdcItem(item)) {
            return this.databaseManager.getEmc(this.getItemKey(item));
        }
        return this.getEmc(this.getItemKey(item));
    }

    public long getEmc(String itemKey) {
        long emc = this.databaseManager.getEmc(itemKey);
        if (emc > 0L) {
            return emc;
        }
        if (this.currentlyCalculating.contains(itemKey)) {
            return 0L;
        }
        this.currentlyCalculating.add(itemKey);
        long lowestEmc = -1L;
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            try {
                long calculatedEmc;
                Recipe recipe = (Recipe)recipeIterator.next();
                ItemStack result = recipe.getResult();
                NamespacedKey key = null;
                if (recipe instanceof ShapedRecipe) {
                    key = ((ShapedRecipe)recipe).getKey();
                } else if (recipe instanceof ShapelessRecipe) {
                    key = ((ShapelessRecipe)recipe).getKey();
                } else if (recipe instanceof CookingRecipe) {
                    key = ((CookingRecipe)recipe).getKey();
                }
                if (key != null && key.getNamespace().equalsIgnoreCase("projecte") || !this.getItemKey(result).equals(itemKey) || (calculatedEmc = this.versionAdapter.calculateRecipeEmc(recipe, this.divisionStrategy)) <= 0L || lowestEmc != -1L && calculatedEmc >= lowestEmc) continue;
                lowestEmc = calculatedEmc;
            }
            catch (Exception exception) {}
        }
        this.currentlyCalculating.remove(itemKey);
        if (lowestEmc > 0L) {
            this.databaseManager.setEmc(itemKey, lowestEmc);
            return lowestEmc;
        }
        return 0L;
    }

    public String getItemKey(ItemStack item) {
        ItemMeta meta;
        if (item == null || item.getType().isAir()) {
            return "minecraft:air";
        }
        if (item.hasItemMeta() && (meta = item.getItemMeta()) != null) {
            String levelName;
            int level;
            PersistentDataContainer container = meta.getPersistentDataContainer();
            if (container.has(Constants.ID_KEY, PersistentDataType.STRING)) {
                String projecteId = (String)container.get(Constants.ID_KEY, PersistentDataType.STRING);
                if ("transmutation_tablet_book".equals(projecteId)) {
                    if (meta.hasCustomModelData() && meta.getCustomModelData() == 1) {
                        return "projecte:" + projecteId;
                    }
                } else {
                    return "projecte:" + projecteId;
                }
            }
            if (container.has(Constants.KLEIN_STAR_KEY, PersistentDataType.INTEGER) && (level = ((Integer)container.get(Constants.KLEIN_STAR_KEY, PersistentDataType.INTEGER)).intValue()) > 0 && (levelName = this.getLevelName(level)) != null) {
                return "projecte:klein_star_" + levelName;
            }
            if (container.has(DarkMatterFurnace.KEY, PersistentDataType.BYTE)) {
                return "projecte:dark_matter_furnace";
            }
            if (container.has(RedMatterFurnace.KEY, PersistentDataType.BYTE)) {
                return "projecte:red_matter_furnace";
            }
            if (container.has(AlchemicalChest.KEY, PersistentDataType.BYTE)) {
                return "projecte:alchemical_chest";
            }
            if (container.has(EnergyCondenser.KEY, PersistentDataType.BYTE)) {
                return "projecte:energy_condenser";
            }
            if (container.has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE)) {
                return "projecte:energy_condenser_mk2";
            }
        }
        return this.versionAdapter.getItemKey(item);
    }

    public String getEffectiveItemKey(ItemStack item) {
        if (this.plugin.isPdcExcluded()) {
            return this.versionAdapter.getItemKey(item);
        }
        return this.getItemKey(item);
    }

    public String getSpecificItemKey(ItemStack item) {
        return this.getItemKey(item);
    }

    public boolean isPdcItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey idKey = Constants.ID_KEY;
        return container.has(idKey, PersistentDataType.STRING);
    }

    private String getLevelName(int level) {
        switch (level) {
            case 1: {
                return "ein";
            }
            case 2: {
                return "zwei";
            }
            case 3: {
                return "drei";
            }
            case 4: {
                return "vier";
            }
            case 5: {
                return "sphere";
            }
            case 6: {
                return "omega";
            }
        }
        return null;
    }

    public long getBaseEmc(ItemStack item) {
        String baseKey = this.versionAdapter.getItemKey(item);
        return this.getEmc(baseKey);
    }

    public String getPdcId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey idKey = Constants.ID_KEY;
        return (String)container.get(idKey, PersistentDataType.STRING);
    }

    public void registerEmc(String itemKey, long emcValue) {
        this.databaseManager.setEmc(itemKey, emcValue);
    }

    public void setEmcValue(ItemStack item, long emc) {
        if (item == null) {
            return;
        }
        String key = this.getItemKey(item);
        this.databaseManager.setEmc(key, emc);
    }
}

