/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.compatibility.SchedulerAdapter;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FuelManager
implements Listener {
    private final ProjectE plugin;
    private final SchedulerAdapter scheduler;
    private final NamespacedKey alchemicalCoalKey;
    private final NamespacedKey mobiusFuelKey;
    private final NamespacedKey aeternalisFuelKey;
    private ItemStack alchemicalCoal;
    private ItemStack mobiusFuel;
    private ItemStack aeternalisFuel;
    private ItemStack alchemicalCoalBlock;
    private ItemStack mobiusFuelBlock;
    private ItemStack aeternalisFuelBlock;
    private final Map<String, Integer> burnTimes = new HashMap<String, Integer>();
    private final boolean isModernVersion;

    public FuelManager(ProjectE plugin) {
        this.plugin = plugin;
        this.scheduler = plugin.getSchedulerAdapter();
        this.alchemicalCoalKey = new NamespacedKey((Plugin)plugin, "alchemical_coal");
        this.mobiusFuelKey = new NamespacedKey((Plugin)plugin, "mobius_fuel");
        this.aeternalisFuelKey = new NamespacedKey((Plugin)plugin, "aeternalis_fuel");
        this.isModernVersion = this.isVersion1_21_4OrNewer();
        this.burnTimes.put("alchemical_coal", 6400);
        this.burnTimes.put("mobius_fuel", 25600);
        this.burnTimes.put("aeternalis_fuel", 102400);
        this.burnTimes.put("alchemical_coal_block", 57600);
        this.burnTimes.put("mobius_fuel_block", 230400);
        this.burnTimes.put("aeternalis_fuel_block", 921600);
        plugin.getLogger().info("FuelManager: Detected version " + Bukkit.getServer().getBukkitVersion() + (this.isModernVersion ? " (using modern material handling)" : " (using legacy material handling)"));
        this.createFuelItems();
    }

    private boolean isVersion1_21_4OrNewer() {
        try {
            String version = Bukkit.getServer().getBukkitVersion().split("-")[0];
            String[] versionParts = version.split("\\.");
            if (versionParts.length >= 2) {
                int major = Integer.parseInt(versionParts[0]);
                int minor = Integer.parseInt(versionParts[1]);
                if (major > 1) {
                    return true;
                }
                if (major == 1 && minor > 21) {
                    return true;
                }
                if (major == 1 && minor == 21 && versionParts.length >= 3) {
                    int patch = Integer.parseInt(versionParts[2]);
                    return patch >= 4;
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not parse version number, using legacy mode: " + e.getMessage());
        }
        return false;
    }

    private void createFuelItems() {
        if (this.isModernVersion) {
            this.createModernFuelItems();
        } else {
            this.createLegacyFuelItems();
        }
    }

    private void createModernFuelItems() {
        this.plugin.getLogger().info("Creating fuel items using modern API (PLAYER_HEAD)...");
        this.alchemicalCoal = this.createFuelItem(Material.COAL, "item.alchemical_coal.name", 1, Arrays.asList("item.alchemical_coal.lore1", "item.alchemical_coal.lore2"), this.alchemicalCoalKey, (byte)1, "alchemical_coal");
        this.mobiusFuel = this.createFuelItem(Material.COAL, "item.mobius_fuel.name", 2, Arrays.asList("item.mobius_fuel.lore1", "item.mobius_fuel.lore2"), this.mobiusFuelKey, (byte)1, "mobius_fuel");
        this.aeternalisFuel = this.createFuelItem(Material.COAL, "item.aeternalis_fuel.name", 3, Arrays.asList("item.aeternalis_fuel.lore1", "item.aeternalis_fuel.lore2"), this.aeternalisFuelKey, (byte)1, "aeternalis_fuel");
        this.alchemicalCoalBlock = this.createFuelItem(Material.COAL_BLOCK, "item.alchemical_coal_block.name", 1, Arrays.asList("item.alchemical_coal_block.lore1", "item.alchemical_coal_block.lore2"), this.alchemicalCoalKey, (byte)2, "alchemical_coal_block");
        this.mobiusFuelBlock = this.createFuelItem(Material.COAL_BLOCK, "item.mobius_fuel_block.name", 2, Arrays.asList("item.mobius_fuel_block.lore1", "item.mobius_fuel_block.lore2"), this.mobiusFuelKey, (byte)2, "mobius_fuel_block");
        this.aeternalisFuelBlock = this.createFuelItem(Material.COAL_BLOCK, "item.aeternalis_fuel_block.name", 3, Arrays.asList("item.aeternalis_fuel_block.lore1", "item.aeternalis_fuel_block.lore2"), this.aeternalisFuelKey, (byte)2, "aeternalis_fuel_block");
    }

    private ItemStack createFuelItem(Material material, String displayNameKey, int customModelData, List<String> loreKeys, NamespacedKey key, byte value, String id) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get(displayNameKey));
            List translatedLore = loreKeys.stream().map(loreKey -> this.plugin.getLanguageManager().get((String)loreKey)).collect(Collectors.toList());
            meta.setLore(translatedLore);
            if (this.isModernVersion) {
                try {
                    CustomModelDataComponent component = meta.getCustomModelDataComponent();
                    if (component == null) {
                        component = meta.getCustomModelDataComponent();
                    }
                    component.setStrings(List.of(String.valueOf(customModelData)));
                    meta.setCustomModelDataComponent(component);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Could not set CustomModelDataComponent: " + e.getMessage());
                    meta.setCustomModelData(Integer.valueOf(customModelData));
                }
            } else {
                meta.setCustomModelData(Integer.valueOf(customModelData));
            }
            item.setItemMeta(meta);
            this.addFuelTags(item, key, value, id);
        }
        return item;
    }

    private void addFuelTags(ItemStack item, NamespacedKey key, byte value, String id) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(key, PersistentDataType.BYTE, (Object)value);
            container.set(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING, (Object)id);
            item.setItemMeta(meta);
        }
    }

    private void createLegacyFuelItems() {
        this.plugin.getLogger().info("Creating fuel items using legacy method...");
        this.alchemicalCoal = this.createFuelItem(Material.PLAYER_HEAD, "item.alchemical_coal.name", 1, Arrays.asList("item.alchemical_coal.lore1", "item.alchemical_coal.lore2"), this.alchemicalCoalKey, (byte)1, "alchemical_coal");
        this.mobiusFuel = this.createFuelItem(Material.PLAYER_HEAD, "item.mobius_fuel.name", 2, Arrays.asList("item.mobius_fuel.lore1", "item.mobius_fuel.lore2"), this.mobiusFuelKey, (byte)1, "mobius_fuel");
        this.aeternalisFuel = this.createFuelItem(Material.PLAYER_HEAD, "item.aeternalis_fuel.name", 3, Arrays.asList("item.aeternalis_fuel.lore1", "item.aeternalis_fuel.lore2"), this.aeternalisFuelKey, (byte)1, "aeternalis_fuel");
        this.alchemicalCoalBlock = this.createFuelItem(Material.PLAYER_HEAD, "item.alchemical_coal_block.name", 4, Arrays.asList("item.alchemical_coal_block.lore1", "item.alchemical_coal_block.lore2"), this.alchemicalCoalKey, (byte)2, "alchemical_coal_block");
        this.mobiusFuelBlock = this.createFuelItem(Material.PLAYER_HEAD, "item.mobius_fuel_block.name", 5, Arrays.asList("item.mobius_fuel_block.lore1", "item.mobius_fuel_block.lore2"), this.mobiusFuelKey, (byte)2, "mobius_fuel_block");
        this.aeternalisFuelBlock = this.createFuelItem(Material.PLAYER_HEAD, "item.aeternalis_fuel_block.name", 6, Arrays.asList("item.aeternalis_fuel_block.lore1", "item.aeternalis_fuel_block.lore2"), this.aeternalisFuelKey, (byte)2, "aeternalis_fuel_block");
    }

    public ItemStack getAlchemicalCoal() {
        return this.alchemicalCoal.clone();
    }

    public ItemStack getMobiusFuel() {
        return this.mobiusFuel.clone();
    }

    public ItemStack getAeternalisFuel() {
        return this.aeternalisFuel.clone();
    }

    public ItemStack getAlchemicalCoalBlock() {
        return this.alchemicalCoalBlock.clone();
    }

    public ItemStack getMobiusFuelBlock() {
        return this.mobiusFuelBlock.clone();
    }

    public ItemStack getAeternalisFuelBlock() {
        return this.aeternalisFuelBlock.clone();
    }

    public boolean isAlchemicalCoal(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.alchemicalCoalKey, PersistentDataType.BYTE) && (Byte)container.get(this.alchemicalCoalKey, PersistentDataType.BYTE) == 1;
    }

    public boolean isMobiusFuel(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.mobiusFuelKey, PersistentDataType.BYTE) && (Byte)container.get(this.mobiusFuelKey, PersistentDataType.BYTE) == 1;
    }

    public boolean isAeternalisFuel(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.aeternalisFuelKey, PersistentDataType.BYTE) && (Byte)container.get(this.aeternalisFuelKey, PersistentDataType.BYTE) == 1;
    }

    public boolean isAlchemicalCoalBlock(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.alchemicalCoalKey, PersistentDataType.BYTE) && (Byte)container.get(this.alchemicalCoalKey, PersistentDataType.BYTE) == 2;
    }

    public boolean isMobiusFuelBlock(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.mobiusFuelKey, PersistentDataType.BYTE) && (Byte)container.get(this.mobiusFuelKey, PersistentDataType.BYTE) == 2;
    }

    public boolean isAeternalisFuelBlock(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.aeternalisFuelKey, PersistentDataType.BYTE) && (Byte)container.get(this.aeternalisFuelKey, PersistentDataType.BYTE) == 2;
    }

    @EventHandler
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        ItemStack fuel = event.getFuel();
        if (fuel == null) {
            return;
        }
        int burnTime = 0;
        if (this.isAlchemicalCoal(fuel)) {
            burnTime = this.burnTimes.get("alchemical_coal");
        } else if (this.isMobiusFuel(fuel)) {
            burnTime = this.burnTimes.get("mobius_fuel");
        } else if (this.isAeternalisFuel(fuel)) {
            burnTime = this.burnTimes.get("aeternalis_fuel");
        } else if (this.isAlchemicalCoalBlock(fuel)) {
            burnTime = this.burnTimes.get("alchemical_coal_block");
        } else if (this.isMobiusFuelBlock(fuel)) {
            burnTime = this.burnTimes.get("mobius_fuel_block");
        } else if (this.isAeternalisFuelBlock(fuel)) {
            burnTime = this.burnTimes.get("aeternalis_fuel_block");
        }
        if (burnTime > 0) {
            event.setBurnTime(burnTime);
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        ItemStack[] matrix = event.getInventory().getMatrix();
        ItemStack result = this.checkFuelRecipe(matrix);
        if (result != null) {
            event.getInventory().setResult(result);
        }
    }

    @EventHandler
    public void onCraftItem(InventoryClickEvent event) {
        if (event.getSlotType() != InventoryType.SlotType.RESULT) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        CraftingInventory inv = (CraftingInventory)event.getInventory();
        ItemStack result = inv.getResult();
        if (result == null) {
            return;
        }
        ItemStack recipeResult = this.checkFuelRecipe(inv.getMatrix());
        if (recipeResult == null || !recipeResult.isSimilar(result)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.isShiftClick()) {
            int numCrafted;
            event.setCancelled(true);
            int maxCrafts = this.calculateMaxCrafts(inv);
            if (maxCrafts <= 0) {
                return;
            }
            ItemStack resultStack = result.clone();
            resultStack.setAmount(result.getAmount() * maxCrafts);
            HashMap leftovers = player.getInventory().addItem(new ItemStack[]{resultStack});
            int craftedAmount = resultStack.getAmount();
            if (!leftovers.isEmpty()) {
                craftedAmount -= ((ItemStack)leftovers.get(0)).getAmount();
            }
            if ((numCrafted = craftedAmount / result.getAmount()) > 0) {
                this.consumeIngredients(inv, numCrafted);
                player.updateInventory();
            }
        } else {
            int canAdd;
            event.setCancelled(true);
            if (player.getItemOnCursor() == null || player.getItemOnCursor().getType() == Material.AIR) {
                this.consumeIngredients(inv, 1);
                player.setItemOnCursor(result);
                player.updateInventory();
            } else if (player.getItemOnCursor().isSimilar(result) && (canAdd = result.getMaxStackSize() - player.getItemOnCursor().getAmount()) >= result.getAmount()) {
                this.consumeIngredients(inv, 1);
                player.getItemOnCursor().setAmount(player.getItemOnCursor().getAmount() + result.getAmount());
                player.updateInventory();
            }
        }
    }

    private int getItemsPerCraft(CraftingInventory inv) {
        ItemStack[] matrix = inv.getMatrix();
        if (this.isRecipe(matrix, Material.COAL, 4)) {
            return 4;
        }
        if (this.isRecipe(matrix, "alchemical_coal", 4)) {
            return 4;
        }
        if (this.isRecipe(matrix, "mobius_fuel", 4)) {
            return 4;
        }
        if (this.isRecipe(matrix, "alchemical_coal", 9)) {
            return 9;
        }
        if (this.isRecipe(matrix, "mobius_fuel", 9)) {
            return 9;
        }
        if (this.isRecipe(matrix, "aeternalis_fuel", 9)) {
            return 9;
        }
        if (this.isSingleItemRecipe(matrix, "alchemical_coal_block")) {
            return 1;
        }
        if (this.isSingleItemRecipe(matrix, "mobius_fuel_block")) {
            return 1;
        }
        if (this.isSingleItemRecipe(matrix, "aeternalis_fuel_block")) {
            return 1;
        }
        if (this.isDowngradeRecipe(matrix, "aeternalis_fuel")) {
            return 1;
        }
        if (this.isDowngradeRecipe(matrix, "mobius_fuel")) {
            return 1;
        }
        if (this.isDowngradeRecipe(matrix, "alchemical_coal")) {
            return 1;
        }
        return 0;
    }

    private int calculateMaxCrafts(CraftingInventory inv) {
        int itemsPerCraft = this.getItemsPerCraft(inv);
        if (itemsPerCraft == 0) {
            return 0;
        }
        int totalIngredients = 0;
        for (ItemStack item : inv.getMatrix()) {
            if (item == null || item.getType() == Material.AIR || this.plugin.isPhilosopherStone(item)) continue;
            totalIngredients += item.getAmount();
        }
        return totalIngredients / itemsPerCraft;
    }

    private void consumeIngredients(CraftingInventory inv, int numCrafts) {
        int itemsPerCraft = this.getItemsPerCraft(inv);
        if (itemsPerCraft == 0) {
            return;
        }
        ItemStack[] matrix = inv.getMatrix();
        if (itemsPerCraft == 9) {
            for (int i = 0; i < matrix.length; ++i) {
                if (matrix[i] == null || matrix[i].getType() == Material.AIR || this.plugin.isPhilosopherStone(matrix[i])) continue;
                int amount = matrix[i].getAmount();
                int consume = Math.min(amount, numCrafts);
                matrix[i].setAmount(amount - consume);
            }
        } else {
            int toConsume = numCrafts * itemsPerCraft;
            for (int i = 0; i < matrix.length; ++i) {
                if (matrix[i] == null || matrix[i].getType() == Material.AIR || this.plugin.isPhilosopherStone(matrix[i])) continue;
                int amount = matrix[i].getAmount();
                int consume = Math.min(amount, toConsume);
                matrix[i].setAmount(amount - consume);
                if ((toConsume -= consume) > 0) {
                    continue;
                }
                break;
            }
        }
        inv.setMatrix(matrix);
    }

    private boolean isSingleItemRecipe(ItemStack[] matrix, String fuelBlockType) {
        int itemCount = 0;
        ItemStack singleItem = null;
        for (ItemStack item : matrix) {
            if (item == null || item.getType() == Material.AIR) continue;
            ++itemCount;
            singleItem = item;
        }
        if (itemCount != 1) {
            return false;
        }
        return this.isFuelItem(singleItem, fuelBlockType);
    }

    private boolean isDowngradeRecipe(ItemStack[] matrix, String inputFuelType) {
        int fuelCount = 0;
        boolean hasPhilosopherStone = false;
        int otherItems = 0;
        for (ItemStack item : matrix) {
            if (item == null || item.getType() == Material.AIR) continue;
            if (this.isFuelItem(item, inputFuelType)) {
                ++fuelCount;
                continue;
            }
            if (this.plugin.isPhilosopherStone(item)) {
                hasPhilosopherStone = true;
                continue;
            }
            ++otherItems;
        }
        return fuelCount == 1 && hasPhilosopherStone && otherItems == 0;
    }

    private ItemStack checkFuelRecipe(ItemStack[] matrix) {
        if (this.isRecipe(matrix, Material.COAL, 4)) {
            return this.getAlchemicalCoal();
        }
        if (this.isRecipe(matrix, "alchemical_coal", 4)) {
            return this.getMobiusFuel();
        }
        if (this.isRecipe(matrix, "mobius_fuel", 4)) {
            return this.getAeternalisFuel();
        }
        if (this.isRecipe(matrix, "alchemical_coal", 9)) {
            return this.getAlchemicalCoalBlock();
        }
        if (this.isRecipe(matrix, "mobius_fuel", 9)) {
            return this.getMobiusFuelBlock();
        }
        if (this.isRecipe(matrix, "aeternalis_fuel", 9)) {
            return this.getAeternalisFuelBlock();
        }
        if (this.isSingleItemRecipe(matrix, "alchemical_coal_block")) {
            ItemStack result = this.getAlchemicalCoal();
            result.setAmount(9);
            return result;
        }
        if (this.isSingleItemRecipe(matrix, "mobius_fuel_block")) {
            ItemStack result = this.getMobiusFuel();
            result.setAmount(9);
            return result;
        }
        if (this.isSingleItemRecipe(matrix, "aeternalis_fuel_block")) {
            ItemStack result = this.getAeternalisFuel();
            result.setAmount(9);
            return result;
        }
        if (this.isDowngradeRecipe(matrix, "aeternalis_fuel")) {
            ItemStack result = this.getMobiusFuel();
            result.setAmount(4);
            return result;
        }
        if (this.isDowngradeRecipe(matrix, "mobius_fuel")) {
            ItemStack result = this.getAlchemicalCoal();
            result.setAmount(4);
            return result;
        }
        if (this.isDowngradeRecipe(matrix, "alchemical_coal")) {
            return new ItemStack(Material.COAL, 4);
        }
        return null;
    }

    private boolean isRecipe(ItemStack[] matrix, Material material, int count) {
        int materialCount = 0;
        boolean hasPhilosopherStone = false;
        for (ItemStack item : matrix) {
            if (item == null || item.getType() == Material.AIR) continue;
            if (item.getType() == material && !this.isFuelItem(item)) {
                ++materialCount;
                continue;
            }
            if (this.plugin.isPhilosopherStone(item)) {
                hasPhilosopherStone = true;
                continue;
            }
            return false;
        }
        return materialCount == count && hasPhilosopherStone;
    }

    private boolean isRecipe(ItemStack[] matrix, String fuelType, int count) {
        int fuelCount = 0;
        boolean hasPhilosopherStone = false;
        for (ItemStack item : matrix) {
            if (item == null || item.getType() == Material.AIR) continue;
            if (this.isFuelItem(item, fuelType)) {
                ++fuelCount;
                continue;
            }
            if (this.plugin.isPhilosopherStone(item)) {
                hasPhilosopherStone = true;
                continue;
            }
            return false;
        }
        return fuelCount == count && (count == 9 || hasPhilosopherStone);
    }

    private String getModelDataForFuelType(String fuelType) {
        switch (fuelType) {
            case "alchemical_coal": {
                return "1";
            }
            case "mobius_fuel": {
                return "2";
            }
            case "aeternalis_fuel": {
                return "3";
            }
            case "alchemical_coal_block": {
                return "1";
            }
            case "mobius_fuel_block": {
                return "2";
            }
            case "aeternalis_fuel_block": {
                return "3";
            }
        }
        return "1";
    }

    private boolean isFuelItem(ItemStack item, String fuelType) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING) && fuelType.equals(container.get(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING));
    }

    private boolean isFuelItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.isFuelItem(event.getItemInHand())) {
            event.setCancelled(true);
        }
    }

    public String getNbtTagInfo() {
        StringBuilder info = new StringBuilder();
        info.append("Special Fuel NBT Tag Info:\n\n");
        info.append("1. Alchemical Coal (CustomModelData: 1)\n");
        info.append("   - NamespacedKey: ").append(this.alchemicalCoalKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 1\n\n");
        info.append("2. Mobius Fuel (CustomModelData: 2)\n");
        info.append("   - NamespacedKey: ").append(this.mobiusFuelKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 1\n\n");
        info.append("3. Aeternalis Fuel (CustomModelData: 3)\n");
        info.append("   - NamespacedKey: ").append(this.aeternalisFuelKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 1\n\n");
        info.append("4. Alchemical Coal Block (CustomModelData: 1)\n");
        info.append("   - NamespacedKey: ").append(this.alchemicalCoalKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 2\n\n");
        info.append("5. Mobius Fuel Block (CustomModelData: 2)\n");
        info.append("   - NamespacedKey: ").append(this.mobiusFuelKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 2\n\n");
        info.append("6. Aeternalis Fuel Block (CustomModelData: 3)\n");
        info.append("   - NamespacedKey: ").append(this.aeternalisFuelKey.toString()).append("\n");
        info.append("   - DataType: BYTE\n");
        info.append("   - DataValue: 2\n\n");
        return info.toString();
    }

    public void setFuelEmcValues() {
        DatabaseManager db = this.plugin.getDatabaseManager();
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getAlchemicalCoal()), 512L);
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getMobiusFuel()), 2048L);
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getAeternalisFuel()), 8192L);
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getAlchemicalCoalBlock()), 4608L);
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getMobiusFuelBlock()), 18432L);
        db.setEmc(this.plugin.getEmcManager().getItemKey(this.getAeternalisFuelBlock()), 73728L);
    }
}

