/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PhilosopherStoneGUI {
    private final ProjectE plugin;
    private final Player player;
    private Inventory inventory;
    private static final int INVENTORY_SIZE = 27;
    private static final int CHARGE_LEVEL_MAX = 4;
    private static final int EMERALD_SLOT = 10;
    private static final int[] REDSTONE_SLOTS = new int[]{11, 12, 13, 14};
    private static final int MODE_PANEL_SLOT = 20;
    private static final int MODE_LINE_SLOT = 21;
    private static final int MODE_CUBE_SLOT = 22;
    public static final int CRAFTING_TABLE_SLOT = 16;
    private static final int[] GLASS_PANE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 15, 17, 18, 19, 23, 24, 25, 26};
    private static final NamespacedKey GUI_ITEM_KEY = new NamespacedKey((Plugin)ProjectE.getInstance(), "gui_item");
    private static final NamespacedKey CHARGE_LEVEL_KEY = new NamespacedKey((Plugin)ProjectE.getInstance(), "charge_level");
    private static final NamespacedKey CURRENT_MODE_KEY = new NamespacedKey((Plugin)ProjectE.getInstance(), "current_mode");
    private static final Map<Player, Integer> playerChargeLevel = new HashMap<Player, Integer>();
    private static final Map<Player, StoneMode> playerCurrentMode = new HashMap<Player, StoneMode>();

    public PhilosopherStoneGUI(ProjectE plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        if (!playerChargeLevel.containsKey(player)) {
            playerChargeLevel.put(player, 0);
        }
        if (!playerCurrentMode.containsKey(player)) {
            playerCurrentMode.put(player, StoneMode.PANEL);
        }
    }

    public void open() {
        String title = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.title");
        this.inventory = Bukkit.createInventory(null, (int)27, (String)title);
        this.setupBackground();
        this.setupChargeSystem();
        this.setupModeSelection();
        this.setupCraftingEntryPoint();
        this.player.openInventory(this.inventory);
    }

    private void setupBackground() {
        ItemStack glassPane = this.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, " ", new ArrayList<String>());
        for (int slot : GLASS_PANE_SLOTS) {
            this.inventory.setItem(slot, glassPane);
        }
    }

    private void setupChargeSystem() {
        int chargeLevel = playerChargeLevel.get(this.player);
        StoneMode currentMode = playerCurrentMode.get(this.player);
        String chargeLevelText = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.charge_levels.level_" + chargeLevel);
        String rangeText = currentMode.getRangeDescription(chargeLevel, this.plugin);
        String clickHint = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.lore.charge_click");
        String currentRangeText = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.lore.current_range").replace("{range}", rangeText);
        List<String> emeraldLore = Arrays.asList(String.valueOf(ChatColor.GRAY) + clickHint, String.valueOf(ChatColor.YELLOW) + currentRangeText);
        ItemStack emeraldItem = this.createGuiItem(Material.EMERALD_BLOCK, String.valueOf(ChatColor.GOLD) + chargeLevelText, emeraldLore);
        ItemMeta emeraldMeta = emeraldItem.getItemMeta();
        if (emeraldMeta != null) {
            emeraldMeta.getPersistentDataContainer().set(CHARGE_LEVEL_KEY, PersistentDataType.INTEGER, (Object)-1);
            emeraldItem.setItemMeta(emeraldMeta);
        }
        this.inventory.setItem(10, emeraldItem);
        for (int i = 0; i < REDSTONE_SLOTS.length; ++i) {
            Material material = i < chargeLevel ? Material.EMERALD_BLOCK : Material.REDSTONE_BLOCK;
            HashMap<String, String> progressPlaceholders = new HashMap<String, String>();
            progressPlaceholders.put("level", String.valueOf(i + 1));
            progressPlaceholders.put("max_level", String.valueOf(4));
            String progressText = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.charge_progress", progressPlaceholders);
            List<String> redstoneLore = Arrays.asList(String.valueOf(ChatColor.GRAY) + clickHint, String.valueOf(ChatColor.YELLOW) + progressText);
            ItemStack redstoneItem = this.createGuiItem(material, String.valueOf(ChatColor.GOLD) + progressText, redstoneLore);
            ItemMeta redstoneMeta = redstoneItem.getItemMeta();
            if (redstoneMeta != null) {
                redstoneMeta.getPersistentDataContainer().set(CHARGE_LEVEL_KEY, PersistentDataType.INTEGER, (Object)(i + 1));
                redstoneItem.setItemMeta(redstoneMeta);
            }
            this.inventory.setItem(REDSTONE_SLOTS[i], redstoneItem);
        }
    }

    private void setupModeSelection() {
        StoneMode currentMode = playerCurrentMode.get(this.player);
        int chargeLevel = playerChargeLevel.get(this.player);
        boolean isPanelMode = StoneMode.PANEL.equals((Object)currentMode);
        ItemStack panelItem = this.createModeItem(Material.STONE_PRESSURE_PLATE, StoneMode.PANEL, isPanelMode, chargeLevel);
        this.inventory.setItem(20, panelItem);
        boolean isLineMode = StoneMode.LINE.equals((Object)currentMode);
        ItemStack lineItem = this.createModeItem(Material.ACACIA_FENCE, StoneMode.LINE, isLineMode, chargeLevel);
        this.inventory.setItem(21, lineItem);
        boolean isCubeMode = StoneMode.CUBE.equals((Object)currentMode);
        ItemStack cubeItem = this.createModeItem(Material.GRASS_BLOCK, StoneMode.CUBE, isCubeMode, chargeLevel);
        this.inventory.setItem(22, cubeItem);
    }

    private ItemStack createModeItem(Material material, StoneMode mode, boolean selected, int chargeLevel) {
        ItemMeta meta;
        Object modeName = mode.getDisplayName(this.plugin);
        String rangeText = mode.getRangeDescription(chargeLevel, this.plugin);
        ArrayList<String> lore = new ArrayList<String>();
        if (selected) {
            String currentModeText = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.modes.current_mode").replace("{mode}", (CharSequence)modeName);
            lore.add(String.valueOf(ChatColor.GREEN) + "\u2713 " + currentModeText);
            lore.add(String.valueOf(ChatColor.YELLOW) + this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.lore.range").replace("{range}", rangeText));
            modeName = String.valueOf(ChatColor.GREEN) + "\u2713 " + (String)modeName;
        } else {
            String clickHint = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.lore.mode_click");
            lore.add(String.valueOf(ChatColor.GRAY) + clickHint);
            lore.add(String.valueOf(ChatColor.YELLOW) + this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.lore.range").replace("{range}", rangeText));
        }
        ItemStack item = this.createGuiItem(material, String.valueOf(ChatColor.GOLD) + (String)modeName, lore);
        if (selected && (meta = item.getItemMeta()) != null) {
            Enchantment enchantment = Enchantment.getByName((String)"unbreaking");
            if (enchantment == null) {
                enchantment = Enchantment.getByName((String)"durability");
            }
            if (enchantment != null) {
                meta.addEnchant(enchantment, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(meta);
        }
        if ((meta = item.getItemMeta()) != null) {
            meta.getPersistentDataContainer().set(CURRENT_MODE_KEY, PersistentDataType.STRING, (Object)mode.name());
            item.setItemMeta(meta);
        }
        return item;
    }

    private void setupCraftingEntryPoint() {
        String name = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.crafting.title");
        String loreText = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.crafting.lore");
        List<String> lore = Arrays.asList(String.valueOf(ChatColor.GRAY) + loreText);
        ItemStack craftingTable = this.createGuiItem(Material.CRAFTING_TABLE, String.valueOf(ChatColor.GOLD) + name, lore);
        this.inventory.setItem(16, craftingTable);
    }

    private ItemStack createGuiItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null) {
                meta.setLore(lore);
            }
            meta.getPersistentDataContainer().set(GUI_ITEM_KEY, PersistentDataType.BYTE, (Object)1);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static int getChargeLevel(Player player) {
        return playerChargeLevel.getOrDefault(player, 0);
    }

    public static void setChargeLevel(Player player, int level) {
        int actualLevel = Math.min(Math.max(0, level), 4);
        playerChargeLevel.put(player, actualLevel);
    }

    public static StoneMode getCurrentMode(Player player) {
        return playerCurrentMode.getOrDefault(player, StoneMode.PANEL);
    }

    public static void setCurrentMode(Player player, StoneMode mode) {
        playerCurrentMode.put(player, mode);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public static TransformationArea getTransformationArea(Player player) {
        StoneMode mode = PhilosopherStoneGUI.getCurrentMode(player);
        int chargeLevel = PhilosopherStoneGUI.getChargeLevel(player);
        return new TransformationArea(mode, chargeLevel);
    }

    public static enum StoneMode {
        PANEL("panel"),
        LINE("line"),
        CUBE("cube");

        private final String configKey;

        private StoneMode(String configKey) {
            this.configKey = configKey;
        }

        public String getConfigKey() {
            return this.configKey;
        }

        public String getRangeDescription(int chargeLevel, ProjectE plugin) {
            String key = "clientside.philosopher_stone_gui.ranges." + this.configKey + "_" + chargeLevel;
            return plugin.getLanguageManager().get(key);
        }

        public String getDisplayName(ProjectE plugin) {
            String key = "clientside.philosopher_stone_gui.modes." + this.configKey;
            return plugin.getLanguageManager().get(key);
        }
    }

    public static class TransformationArea {
        private final StoneMode mode;
        private final int chargeLevel;
        private final int width;
        private final int height;
        private final int depth;

        public TransformationArea(StoneMode mode, int chargeLevel) {
            this.mode = mode;
            this.chargeLevel = chargeLevel;
            int size = 1 + chargeLevel * 2;
            switch (mode.ordinal()) {
                case 0: {
                    this.width = size;
                    this.height = size;
                    this.depth = 1;
                    break;
                }
                case 1: {
                    this.width = 1;
                    this.height = size;
                    this.depth = 1;
                    break;
                }
                case 2: {
                    this.width = size;
                    this.height = size;
                    this.depth = size;
                    break;
                }
                default: {
                    this.width = 1;
                    this.height = 1;
                    this.depth = 1;
                }
            }
        }

        public StoneMode getMode() {
            return this.mode;
        }

        public int getChargeLevel() {
            return this.chargeLevel;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

