/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.Little_100.projecte.AlchemicalBag.AlchemicalBagManager;
import org.Little_100.projecte.BlockListener;
import org.Little_100.projecte.CommandManager;
import org.Little_100.projecte.EmcManager;
import org.Little_100.projecte.FuelManager;
import org.Little_100.projecte.ItemStackLimitListener;
import org.Little_100.projecte.LanguageManager;
import org.Little_100.projecte.PhilosopherStoneGUIListener;
import org.Little_100.projecte.PhilosopherStoneListener;
import org.Little_100.projecte.RecipeManager;
import org.Little_100.projecte.ResourcePackManager;
import org.Little_100.projecte.TransmutationTable.GUIListener;
import org.Little_100.projecte.compatibility.SchedulerAdapter;
import org.Little_100.projecte.compatibility.SchedulerMatcher;
import org.Little_100.projecte.compatibility.VersionAdapter;
import org.Little_100.projecte.compatibility.VersionMatcher;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ProjectE
extends JavaPlugin {
    private static ProjectE instance;
    private ItemStack philosopherStone;
    private NamespacedKey philosopherStoneKey;
    private RecipeManager recipeManager;
    private DatabaseManager databaseManager;
    private EmcManager emcManager;
    private VersionAdapter versionAdapter;
    private AlchemicalBagManager alchemicalBagManager;
    private LanguageManager languageManager;
    private ResourcePackManager resourcePackManager;
    private SchedulerAdapter schedulerAdapter;
    private PhilosopherStoneListener philosopherStoneListener;
    private FuelManager fuelManager;
    private final Map<Material, Material> upgradeMap = new HashMap<Material, Material>();
    private final Map<Material, Material> downgradeMap = new HashMap<Material, Material>();

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.languageManager = new LanguageManager(this);
        try {
            ZipEntry entry;
            ZipInputStream zip = new ZipInputStream(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().openStream());
            while ((entry = zip.getNextEntry()) != null) {
                File outFile;
                String name = entry.getName();
                if (!name.matches("[a-z]{2}_[a-z]{2}\\.yml") || entry.isDirectory() || (outFile = new File(this.getDataFolder(), name)).exists()) continue;
                this.saveResource(name, false);
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("file", name);
                this.getLogger().info(this.languageManager.get("plugin.autofix_language_file", placeholders));
            }
            zip.close();
        }
        catch (Exception e) {
            this.getLogger().warning("Error auto-releasing yml language files: " + e.getMessage());
        }
        this.databaseManager = new DatabaseManager(this.getDataFolder());
        this.versionAdapter = VersionMatcher.getAdapter();
        if (this.versionAdapter == null) {
            this.getLogger().severe("Failed to find a compatible version adapter. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.schedulerAdapter = SchedulerMatcher.getSchedulerAdapter(this);
        this.emcManager = new EmcManager(this);
        try {
            this.getLogger().info("Calculating EMC values...");
            this.emcManager.calculateAndStoreEmcValues();
            this.getLogger().info("EMC calculation complete.");
        }
        catch (Exception e) {
            this.getLogger().severe("An error occurred during EMC calculation. Some items may not have EMC values. Please check your config.yml for formatting errors.");
            e.printStackTrace();
        }
        this.createPhilosopherStone();
        this.fuelManager = new FuelManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.fuelManager, (Plugin)this);
        this.getLogger().info("FuelManager initialized with special fuels.");
        this.fuelManager.setFuelEmcValues();
        this.getLogger().info(this.fuelManager.getNbtTagInfo());
        this.recipeManager = new RecipeManager(this);
        this.recipeManager.registerAllRecipes();
        this.removeVanillaRecipe();
        this.initMaterialMaps();
        this.philosopherStoneListener = new PhilosopherStoneListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.philosopherStoneListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PhilosopherStoneGUIListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ItemStackLimitListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GUIListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BlockListener(), (Plugin)this);
        CommandManager commandManager = new CommandManager(this);
        this.getCommand("projecte").setExecutor((CommandExecutor)commandManager);
        this.getCommand("projecte").setTabCompleter((TabCompleter)commandManager);
        if (this.getConfig().getBoolean("AlchemicalBag.enabled", true)) {
            this.alchemicalBagManager = new AlchemicalBagManager(this);
            this.alchemicalBagManager.register();
            this.getLogger().info("Alchemical Bag feature is enabled.");
        } else {
            this.getLogger().info("Alchemical Bag feature is disabled in the config.");
        }
        this.resourcePackManager = new ResourcePackManager(this);
        this.getLogger().info("Resource Pack Manager initialized.");
        this.getLogger().info("ProjectE plugin has been enabled!");
        this.startContinuousParticleTask();
    }

    public void onDisable() {
        if (this.recipeManager != null) {
            this.recipeManager.unregisterAllRecipes();
        }
        if (this.alchemicalBagManager != null) {
            this.alchemicalBagManager.unregister();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("ProjectE plugin has been disabled!");
    }

    public static ProjectE getInstance() {
        return instance;
    }

    public ItemStack getPhilosopherStone() {
        return this.philosopherStone.clone();
    }

    public boolean isPhilosopherStone(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material stoneMaterial = this.versionAdapter.getMaterial("POPPED_CHORUS_FRUIT");
        if (stoneMaterial == null) {
            stoneMaterial = Material.NETHER_STAR;
        }
        return item.getType() == stoneMaterial;
    }

    public NamespacedKey getPhilosopherStoneKey() {
        return this.philosopherStoneKey;
    }

    private void createPhilosopherStone() {
        Material stoneMaterial = this.versionAdapter.getMaterial("POPPED_CHORUS_FRUIT");
        if (stoneMaterial == null) {
            stoneMaterial = Material.NETHER_STAR;
        }
        this.philosopherStone = new ItemStack(stoneMaterial, 1);
        ItemMeta meta = this.philosopherStone.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Philosopher's Stone");
        meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "A powerful alchemical tool", String.valueOf(ChatColor.YELLOW) + "Can transmute minerals", String.valueOf(ChatColor.YELLOW) + "Sneak + Right-click to open workbench"));
        meta.setUnbreakable(true);
        this.philosopherStoneKey = new NamespacedKey((Plugin)this, "philosopher_stone");
        this.philosopherStone.setItemMeta(meta);
        this.philosopherStone.setAmount(1);
    }

    private void removeVanillaRecipe() {
        try {
            Bukkit.removeRecipe((NamespacedKey)NamespacedKey.minecraft((String)"popped_chorus_fruit"));
        }
        catch (Exception e) {
            this.getLogger().warning("Could not remove vanilla popped chorus fruit recipe: " + e.getMessage());
        }
    }

    private void initMaterialMaps() {
        this.upgradeMap.put(Material.COAL, Material.COPPER_INGOT);
        this.upgradeMap.put(Material.COPPER_INGOT, Material.IRON_INGOT);
        this.upgradeMap.put(Material.IRON_INGOT, Material.GOLD_INGOT);
        this.upgradeMap.put(Material.GOLD_INGOT, Material.DIAMOND);
        this.upgradeMap.put(Material.DIAMOND, Material.NETHERITE_INGOT);
        this.upgradeMap.put(Material.COAL_BLOCK, Material.COPPER_BLOCK);
        this.upgradeMap.put(Material.COPPER_BLOCK, Material.IRON_BLOCK);
        this.upgradeMap.put(Material.IRON_BLOCK, Material.GOLD_BLOCK);
        this.upgradeMap.put(Material.GOLD_BLOCK, Material.DIAMOND_BLOCK);
        this.upgradeMap.put(Material.DIAMOND_BLOCK, Material.NETHERITE_BLOCK);
        this.upgradeMap.put(Material.COAL_ORE, Material.COPPER_ORE);
        this.upgradeMap.put(Material.COPPER_ORE, Material.IRON_ORE);
        this.upgradeMap.put(Material.IRON_ORE, Material.GOLD_ORE);
        this.upgradeMap.put(Material.GOLD_ORE, Material.DIAMOND_ORE);
        this.upgradeMap.put(Material.DIAMOND_ORE, Material.ANCIENT_DEBRIS);
        this.upgradeMap.put(Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_COPPER_ORE);
        this.upgradeMap.put(Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_IRON_ORE);
        this.upgradeMap.put(Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE);
        this.upgradeMap.put(Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_DIAMOND_ORE);
        this.upgradeMap.put(Material.DEEPSLATE_DIAMOND_ORE, Material.ANCIENT_DEBRIS);
        this.downgradeMap.put(Material.COPPER_INGOT, Material.COAL);
        this.downgradeMap.put(Material.IRON_INGOT, Material.COPPER_INGOT);
        this.downgradeMap.put(Material.GOLD_INGOT, Material.IRON_INGOT);
        this.downgradeMap.put(Material.DIAMOND, Material.GOLD_INGOT);
        this.downgradeMap.put(Material.NETHERITE_INGOT, Material.DIAMOND);
        this.downgradeMap.put(Material.COPPER_BLOCK, Material.COAL_BLOCK);
        this.downgradeMap.put(Material.IRON_BLOCK, Material.COPPER_BLOCK);
        this.downgradeMap.put(Material.GOLD_BLOCK, Material.IRON_BLOCK);
        this.downgradeMap.put(Material.DIAMOND_BLOCK, Material.GOLD_BLOCK);
        this.downgradeMap.put(Material.NETHERITE_BLOCK, Material.DIAMOND_BLOCK);
        this.downgradeMap.put(Material.COPPER_ORE, Material.COAL_ORE);
        this.downgradeMap.put(Material.IRON_ORE, Material.COPPER_ORE);
        this.downgradeMap.put(Material.GOLD_ORE, Material.IRON_ORE);
        this.downgradeMap.put(Material.DIAMOND_ORE, Material.GOLD_ORE);
        this.downgradeMap.put(Material.ANCIENT_DEBRIS, Material.DIAMOND_ORE);
        this.downgradeMap.put(Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_COAL_ORE);
        this.downgradeMap.put(Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_COPPER_ORE);
        this.downgradeMap.put(Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_IRON_ORE);
        this.downgradeMap.put(Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_GOLD_ORE);
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public EmcManager getEmcManager() {
        return this.emcManager;
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.languageManager.loadLanguageFiles();
        if (this.recipeManager != null) {
            this.recipeManager.unregisterAllRecipes();
            this.recipeManager.registerAllRecipes();
            this.getLogger().info("All recipes have been reloaded from recipe.yml.");
        }
        this.emcManager = new EmcManager(this);
        this.emcManager.calculateAndStoreEmcValues();
        this.getLogger().info("ProjectE plugin has been reloaded!");
    }

    public VersionAdapter getVersionAdapter() {
        return this.versionAdapter;
    }

    public SchedulerAdapter getSchedulerAdapter() {
        return this.schedulerAdapter;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public ResourcePackManager getResourcePackManager() {
        return this.resourcePackManager;
    }

    public Material getUpgradedMaterial(Material material) {
        return this.upgradeMap.getOrDefault(material, null);
    }

    public Material getDowngradedMaterial(Material material) {
        return this.downgradeMap.getOrDefault(material, null);
    }

    public FuelManager getFuelManager() {
        return this.fuelManager;
    }

    private void startContinuousParticleTask() {
        if (!this.getConfig().getBoolean("philosopher_stone.particle.enabled", true)) {
            return;
        }
        long keepAlive = this.getConfig().getLong("philosopher_stone.particle.keep-alive", 5L);
        long period = keepAlive == -1L ? 10L : keepAlive * 20L;
        this.schedulerAdapter.runTimer(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                ItemStack mainHand = player.getInventory().getItemInMainHand();
                ItemStack offHand = player.getInventory().getItemInOffHand();
                if (!this.isPhilosopherStone(mainHand) && !this.isPhilosopherStone(offHand)) continue;
                Block targetBlock = null;
                try {
                    if (player.getWorld() != null && player.getWorld().isChunkLoaded(player.getLocation().getBlockX() >> 4, player.getLocation().getBlockZ() >> 4)) {
                        targetBlock = player.getTargetBlock(null, 10);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (targetBlock == null || targetBlock.getType().isAir()) continue;
                this.philosopherStoneListener.showContinuousOutline(player, targetBlock);
            }
        }, 1L, period);
    }

    public ItemStack getItemStackFromKey(String key) {
        String materialName;
        Material material;
        Pattern pattern = Pattern.compile("(.+)\\{projecte_id:\"(.+)\"\\}");
        Matcher matcher = pattern.matcher(key);
        if (matcher.matches()) {
            String projecteId;
            switch (projecteId = matcher.group(2)) {
                case "alchemical_coal": {
                    return this.fuelManager.getAlchemicalCoal();
                }
                case "mobius_fuel": {
                    return this.fuelManager.getMobiusFuel();
                }
                case "aeternalis_fuel": {
                    return this.fuelManager.getAeternalisFuel();
                }
                case "alchemical_coal_block": {
                    return this.fuelManager.getAlchemicalCoalBlock();
                }
                case "mobius_fuel_block": {
                    return this.fuelManager.getMobiusFuelBlock();
                }
                case "aeternalis_fuel_block": {
                    return this.fuelManager.getAeternalisFuelBlock();
                }
            }
        }
        if ((material = this.versionAdapter.getMaterial(materialName = key.replace("minecraft:", "").toUpperCase())) != null) {
            return new ItemStack(material);
        }
        return null;
    }
}

