/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.util.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RecipeManager {
    private final ProjectE plugin;
    private final Map<String, NamespacedKey> recipeKeys = new HashMap<String, NamespacedKey>();

    public RecipeManager(ProjectE plugin) {
        this.plugin = plugin;
    }

    public void registerAllRecipes() {
        this.loadRecipesFromYaml();
        this.registerUpgradeRecipes();
        this.registerDowngradeRecipes();
        this.registerOreTransmutationRecipes();
    }

    private void loadRecipesFromYaml() {
        YamlConfiguration config;
        ConfigurationSection recipesSection;
        File recipeFile = new File(this.plugin.getDataFolder(), "recipe.yml");
        if (!recipeFile.exists()) {
            this.plugin.getLogger().info("\u672a\u627e\u5230 recipe.yml\uff0c\u6b63\u5728\u521b\u5efa\u9ed8\u8ba4\u6587\u4ef6\u3002");
            this.plugin.saveResource("recipe.yml", false);
        }
        if ((recipesSection = (config = YamlConfiguration.loadConfiguration((File)recipeFile)).getConfigurationSection("recipes")) == null) {
            List recipeList = config.getMapList("recipes");
            if (recipeList.isEmpty()) {
                this.plugin.getLogger().warning("\u5728 recipe.yml \u4e2d\u672a\u627e\u5230 'recipes' \u533a\u6bb5\u6216\u5217\u8868\u3002");
                return;
            }
            recipesSection = new YamlConfiguration();
            for (Map map : recipeList) {
                if (!map.containsKey("id")) continue;
                recipesSection.set(map.get("id").toString(), (Object)map);
            }
        }
        for (String id : recipesSection.getKeys(false)) {
            if (recipesSection.isConfigurationSection(id)) {
                ConfigurationSection recipeConfig = recipesSection.getConfigurationSection(id);
                if (recipeConfig == null || !recipeConfig.getBoolean("enabled", true)) continue;
                this.parseRecipe(id, recipeConfig);
                continue;
            }
            if (!recipesSection.isList(id)) continue;
            List recipeList = recipesSection.getMapList(id);
            int i = 0;
            for (Map recipeMap : recipeList) {
                ConfigurationSection recipeConfig = new YamlConfiguration().createSection("recipe", recipeMap);
                if (!recipeConfig.getBoolean("enabled", true)) continue;
                this.parseRecipe(id + "_" + i, recipeConfig);
                ++i;
            }
        }
    }

    private void parseRecipe(String id, ConfigurationSection config) {
        String type = config.getString("type", "shaped").toLowerCase();
        if (type.equals("shaped")) {
            this.parseShapedRecipe(id, config);
        } else if (type.equals("shapeless")) {
            this.parseShapelessRecipe(id, config);
        }
    }

    private void parseShapedRecipe(String id, ConfigurationSection config) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, id);
        ItemStack result = this.createResultStack(config.getConfigurationSection("result"));
        if (result == null) {
            this.plugin.getLogger().warning("\u914d\u65b9 " + id + " \u7684\u7ed3\u679c\u65e0\u6548\u3002");
            return;
        }
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(config.getStringList("shape").toArray(new String[0]));
        ConfigurationSection ingredients = config.getConfigurationSection("ingredients");
        if (ingredients != null) {
            for (String ingredientKey : ingredients.getKeys(false)) {
                char keyChar = ingredientKey.charAt(0);
                String ingredientValue = ingredients.getString(ingredientKey);
                RecipeChoice choice = this.getChoice(ingredientValue);
                if (choice != null) {
                    recipe.setIngredient(keyChar, choice);
                    continue;
                }
                this.plugin.getLogger().warning("\u914d\u65b9 " + id + " \u4e2d\u7684\u539f\u6599 '" + ingredientValue + "' \u65e0\u6548\u3002");
            }
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put(id, key);
    }

    private void parseShapelessRecipe(String id, ConfigurationSection config) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, id);
        ItemStack result = this.createResultStack(config.getConfigurationSection("result"));
        if (result == null) {
            this.plugin.getLogger().warning("\u914d\u65b9 " + id + " \u7684\u7ed3\u679c\u65e0\u6548\u3002");
            return;
        }
        ShapelessRecipe recipe = new ShapelessRecipe(key, result);
        List ingredients = config.getStringList("ingredients");
        for (String ingredientValue : ingredients) {
            RecipeChoice choice = this.getChoice(ingredientValue);
            if (choice != null) {
                recipe.addIngredient(choice);
                continue;
            }
            this.plugin.getLogger().warning("\u914d\u65b9 " + id + " \u4e2d\u7684\u539f\u6599 '" + ingredientValue + "' \u65e0\u6548\u3002");
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put(id, key);
    }

    private RecipeChoice getChoice(String ingredient) {
        if (ingredient.equalsIgnoreCase("projecte:philosopher_stone")) {
            return new RecipeChoice.ExactChoice(this.plugin.getPhilosopherStone());
        }
        if (ingredient.equalsIgnoreCase("any_wool")) {
            return new RecipeChoice.MaterialChoice(new Material[]{Material.WHITE_WOOL, Material.ORANGE_WOOL, Material.MAGENTA_WOOL, Material.LIGHT_BLUE_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.PINK_WOOL, Material.GRAY_WOOL, Material.LIGHT_GRAY_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.GREEN_WOOL, Material.RED_WOOL, Material.BLACK_WOOL});
        }
        if (ingredient.equalsIgnoreCase("any_dye")) {
            return new RecipeChoice.MaterialChoice(new Material[]{Material.RED_DYE, Material.GREEN_DYE, Material.BLUE_DYE, Material.WHITE_DYE, Material.BLACK_DYE, Material.YELLOW_DYE, Material.PURPLE_DYE, Material.ORANGE_DYE});
        }
        if (ingredient.equalsIgnoreCase("projecte:alchemical_bag")) {
            return new RecipeChoice.MaterialChoice(Material.LEATHER_HORSE_ARMOR);
        }
        if (ingredient.equalsIgnoreCase("projecte:alchemical_coal")) {
            return new RecipeChoice.ExactChoice(this.plugin.getFuelManager().getAlchemicalCoal());
        }
        if (ingredient.equalsIgnoreCase("projecte:mobius_fuel")) {
            return new RecipeChoice.ExactChoice(this.plugin.getFuelManager().getMobiusFuel());
        }
        if (ingredient.equalsIgnoreCase("projecte:aeternalis_fuel")) {
            return new RecipeChoice.ExactChoice(this.plugin.getFuelManager().getAeternalisFuel());
        }
        if (ingredient.equalsIgnoreCase("projecte:alchemical_coal_block")) {
            return new RecipeChoice.ExactChoice(this.plugin.getFuelManager().getAlchemicalCoalBlock());
        }
        if (ingredient.equalsIgnoreCase("projecte:mobius_fuel_block")) {
            return new RecipeChoice.ExactChoice(this.plugin.getFuelManager().getMobiusFuelBlock());
        }
        if (ingredient.equalsIgnoreCase("projecte:aeternalis_fuel_block")) {
            return new RecipeChoice.ExactChoice(this.plugin.getFuelManager().getAeternalisFuelBlock());
        }
        Material mat = Material.matchMaterial((String)ingredient);
        if (mat != null) {
            return new RecipeChoice.MaterialChoice(mat);
        }
        return null;
    }

    private void registerSpecialFuelRecipes() {
    }

    private ItemStack createResultStack(ConfigurationSection config) {
        if (config == null) {
            return null;
        }
        String materialName = config.getString("material");
        Material material = this.plugin.getVersionAdapter().getMaterial(materialName);
        if (material == null) {
            material = Material.matchMaterial((String)materialName);
        }
        if (material == null) {
            return null;
        }
        ItemStack item = new ItemStack(material, config.getInt("amount", 1));
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (config.contains("display_name")) {
                meta.setDisplayName(this.plugin.getLanguageManager().get(config.getString("display_name")));
            }
            if (config.contains("lore")) {
                List loreKeys = config.getStringList("lore");
                List translatedLore = loreKeys.stream().map(key -> this.plugin.getLanguageManager().get((String)key)).collect(Collectors.toList());
                meta.setLore(translatedLore);
            }
            if (config.contains("custom_model_data")) {
                if (this.plugin.getVersionAdapter().isModern()) {
                    ReflectionUtil.setCustomModelData(meta, List.of("projecte:" + config.getString("custom_model_data")));
                } else {
                    meta.setCustomModelData(Integer.valueOf(config.getInt("custom_model_data")));
                }
            }
            if (config.getBoolean("unbreakable")) {
                meta.setUnbreakable(true);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private void registerUpgradeRecipes() {
        ItemStack philosopherStone = this.plugin.getPhilosopherStone();
        this.registerUpgradeRecipe("copper_to_iron", Material.COPPER_INGOT, Material.IRON_INGOT, 4, 1, philosopherStone);
        this.registerUpgradeRecipe("iron_to_gold", Material.IRON_INGOT, Material.GOLD_INGOT, 4, 1, philosopherStone);
        this.registerUpgradeRecipe("gold_to_diamond", Material.GOLD_INGOT, Material.DIAMOND, 4, 1, philosopherStone);
        this.registerSpecialUpgradeRecipe("diamond_to_netherite", Material.DIAMOND_BLOCK, Material.NETHERITE_INGOT, 8, 1, philosopherStone);
    }

    private void registerDowngradeRecipes() {
        ItemStack philosopherStone = this.plugin.getPhilosopherStone();
        this.registerDowngradeRecipe("copper_to_coal", Material.COPPER_INGOT, Material.COAL, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("iron_to_copper", Material.IRON_INGOT, Material.COPPER_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("gold_to_iron", Material.GOLD_INGOT, Material.IRON_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("diamond_to_gold", Material.DIAMOND, Material.GOLD_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("netherite_to_diamond", Material.NETHERITE_INGOT, Material.DIAMOND_BLOCK, 1, 8, philosopherStone);
    }

    private void registerUpgradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "upgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("upgrade_" + id, key);
    }

    private void registerSpecialUpgradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "special_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("special_" + id, key);
    }

    private void registerDowngradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "downgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("downgrade_" + id, key);
    }

    public Map<String, NamespacedKey> getRecipeKeys() {
        return this.recipeKeys;
    }

    public void unregisterAllRecipes() {
        for (NamespacedKey key : this.recipeKeys.values()) {
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        this.recipeKeys.clear();
    }

    private void registerOreTransmutationRecipes() {
        RecipeChoice.ExactChoice catalyst = new RecipeChoice.ExactChoice(this.plugin.getPhilosopherStone());
        RecipeChoice.MaterialChoice fuel = new RecipeChoice.MaterialChoice(new Material[]{Material.COAL, Material.CHARCOAL});
        this.registerOreTransmutationRecipe("iron", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.RAW_IRON}), new ItemStack(Material.IRON_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("gold", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.RAW_GOLD}), new ItemStack(Material.GOLD_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("copper", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.RAW_COPPER}), new ItemStack(Material.COPPER_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("diamond", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE}), new ItemStack(Material.DIAMOND, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("netherite", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.ANCIENT_DEBRIS), new ItemStack(Material.NETHERITE_SCRAP, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        RecipeChoice.MaterialChoice logChoice = new RecipeChoice.MaterialChoice(new Material[]{Material.OAK_LOG, Material.SPRUCE_LOG, Material.BIRCH_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.MANGROVE_LOG, Material.CHERRY_LOG, Material.STRIPPED_OAK_LOG, Material.STRIPPED_SPRUCE_LOG, Material.STRIPPED_BIRCH_LOG, Material.STRIPPED_JUNGLE_LOG, Material.STRIPPED_ACACIA_LOG, Material.STRIPPED_DARK_OAK_LOG, Material.STRIPPED_MANGROVE_LOG, Material.STRIPPED_CHERRY_LOG});
        this.registerOreTransmutationRecipe("wood_to_charcoal", (RecipeChoice)logChoice, new ItemStack(Material.CHARCOAL, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
    }

    private void registerOreTransmutationRecipe(String id, RecipeChoice oreChoice, ItemStack result, RecipeChoice catalyst, RecipeChoice fuel) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "transmute_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, result);
        for (int i = 0; i < 7; ++i) {
            recipe.addIngredient(oreChoice);
        }
        recipe.addIngredient(fuel);
        recipe.addIngredient(catalyst);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("transmute_" + id, key);
    }
}

