/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.AlchemicalBag;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.Little_100.projecte.AlchemicalBag.AlchemicalBagManager;
import org.Little_100.projecte.ProjectE;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class InventoryManager
implements Listener {
    private final ProjectE plugin;
    private final AlchemicalBagManager alchemicalBagManager;
    private final Map<UUID, Inventory> openInventories = new HashMap<UUID, Inventory>();
    private final Map<UUID, String> openBagColors = new HashMap<UUID, String>();

    public InventoryManager(ProjectE plugin, AlchemicalBagManager alchemicalBagManager) {
        this.plugin = plugin;
        this.alchemicalBagManager = alchemicalBagManager;
    }

    public void openBagInventory(UUID playerUUID, String bagColor, Inventory inventory) {
        this.openInventories.put(playerUUID, inventory);
        this.openBagColors.put(playerUUID, bagColor);
    }

    public void saveAllOpenInventories() {
        this.plugin.getLogger().info("Saving all open Alchemical Bags...");
        HashMap<UUID, Inventory> inventoriesToSave = new HashMap<UUID, Inventory>(this.openInventories);
        for (Map.Entry entry : inventoriesToSave.entrySet()) {
            UUID uuid = (UUID)entry.getKey();
            Inventory inv = (Inventory)entry.getValue();
            String color = this.openBagColors.get(uuid);
            if (color != null) {
                this.plugin.getDatabaseManager().saveBagInventory(uuid, color, inv.getContents());
                this.plugin.getLogger().info("Saved Alchemical Bag for player " + String.valueOf(uuid) + " with color " + color);
                continue;
            }
            this.plugin.getLogger().warning("Could not find bag color for player " + String.valueOf(uuid) + ", cannot save!");
        }
        this.openInventories.clear();
        this.openBagColors.clear();
        this.plugin.getLogger().info("Finished saving all open Alchemical Bags.");
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        Inventory closedInventory = event.getInventory();
        if (this.openInventories.containsKey(playerUUID) && this.openInventories.get(playerUUID) == closedInventory) {
            String closedBagColor = this.openBagColors.remove(playerUUID);
            this.openInventories.remove(playerUUID);
            if (closedBagColor != null) {
                this.plugin.getDatabaseManager().saveBagInventory(playerUUID, closedBagColor, closedInventory.getContents());
                this.plugin.getLogger().info("Player " + player.getName() + " closed Alchemical Bag with color " + closedBagColor + ", contents saved.");
            } else {
                this.plugin.getLogger().warning("Player " + player.getName() + " closed an Alchemical Bag, but its color could not be found!");
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        UUID playerUUID = player.getUniqueId();
        Inventory clickedInventory = event.getInventory();
        if (this.openInventories.containsKey(playerUUID) && this.openInventories.get(playerUUID) == clickedInventory) {
            String currentBagColor = this.openBagColors.get(playerUUID);
            if (currentBagColor == null) {
                event.setCancelled(true);
                this.plugin.getLogger().warning("Player " + player.getName() + " clicked in an Alchemical Bag, but its color could not be found!");
                return;
            }
            ItemStack cursorItem = event.getCursor();
            ItemStack currentItem = event.getCurrentItem();
            if (this.isForbiddenBag(cursorItem, currentBagColor) || event.isShiftClick() && this.isForbiddenBag(currentItem, currentBagColor)) {
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot put an Alchemical Bag inside another!");
            }
        }
    }

    private boolean isForbiddenBag(ItemStack item, String targetColorIdentifier) {
        if (item == null || item.getType() != Material.LEATHER_HORSE_ARMOR || !item.hasItemMeta()) {
            return false;
        }
        LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
        return meta != null;
    }
}

