/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FuelManager
implements Listener {
    private final ProjectE plugin;
    private final NamespacedKey alchemicalCoalKey;
    private final NamespacedKey mobiusFuelKey;
    private final NamespacedKey aeternalisFuelKey;
    private ItemStack alchemicalCoal;
    private ItemStack mobiusFuel;
    private ItemStack aeternalisFuel;
    private ItemStack alchemicalCoalBlock;
    private ItemStack mobiusFuelBlock;
    private ItemStack aeternalisFuelBlock;
    private final Map<String, Integer> burnTimes = new HashMap<String, Integer>();

    public FuelManager(ProjectE plugin) {
        this.plugin = plugin;
        this.alchemicalCoalKey = new NamespacedKey((Plugin)plugin, "alchemical_coal");
        this.mobiusFuelKey = new NamespacedKey((Plugin)plugin, "mobius_fuel");
        this.aeternalisFuelKey = new NamespacedKey((Plugin)plugin, "aeternalis_fuel");
        this.burnTimes.put("alchemical_coal", 6400);
        this.burnTimes.put("mobius_fuel", 25600);
        this.burnTimes.put("aeternalis_fuel", 102400);
        this.burnTimes.put("alchemical_coal_block", 57600);
        this.burnTimes.put("mobius_fuel_block", 230400);
        this.burnTimes.put("aeternalis_fuel_block", 921600);
        this.createFuelItems();
    }

    private void createFuelItems() {
        this.alchemicalCoal = new ItemStack(Material.COAL);
        ItemMeta alchemicalCoalMeta = this.alchemicalCoal.getItemMeta();
        alchemicalCoalMeta.setDisplayName(String.valueOf(ChatColor.RED) + "\u70bc\u91d1\u7164\u70ad");
        alchemicalCoalMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "\u9ad8\u6548\u7684\u71c3\u6599", String.valueOf(ChatColor.YELLOW) + "\u71c3\u70e7\u65f6\u95f4: 320\u79d2"));
        alchemicalCoalMeta.setCustomModelData(Integer.valueOf(1));
        alchemicalCoalMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "custom_model_data"), PersistentDataType.STRING, (Object)"alchemical_coal");
        PersistentDataContainer alchemicalCoalContainer = alchemicalCoalMeta.getPersistentDataContainer();
        alchemicalCoalContainer.set(this.alchemicalCoalKey, PersistentDataType.BYTE, (Object)1);
        this.alchemicalCoal.setItemMeta(alchemicalCoalMeta);
        this.mobiusFuel = new ItemStack(Material.COAL);
        ItemMeta mobiusFuelMeta = this.mobiusFuel.getItemMeta();
        mobiusFuelMeta.setDisplayName(String.valueOf(ChatColor.RED) + "\u83ab\u6bd4\u4e4c\u65af\u71c3\u6599");
        mobiusFuelMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "\u9ad8\u5ea6\u6d53\u7f29\u7684\u71c3\u6599", String.valueOf(ChatColor.YELLOW) + "\u71c3\u70e7\u65f6\u95f4: 1280\u79d2"));
        mobiusFuelMeta.setCustomModelData(Integer.valueOf(2));
        mobiusFuelMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "custom_model_data"), PersistentDataType.STRING, (Object)"mobius_fuel");
        PersistentDataContainer mobiusFuelContainer = mobiusFuelMeta.getPersistentDataContainer();
        mobiusFuelContainer.set(this.mobiusFuelKey, PersistentDataType.BYTE, (Object)1);
        this.mobiusFuel.setItemMeta(mobiusFuelMeta);
        this.aeternalisFuel = new ItemStack(Material.COAL);
        ItemMeta aeternalisFuelMeta = this.aeternalisFuel.getItemMeta();
        aeternalisFuelMeta.setDisplayName(String.valueOf(ChatColor.RED) + "\u6c38\u6052\u71c3\u6599");
        aeternalisFuelMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "\u51e0\u8fd1\u6c38\u6052\u7684\u71c3\u6599", String.valueOf(ChatColor.YELLOW) + "\u71c3\u70e7\u65f6\u95f4: 5120\u79d2"));
        aeternalisFuelMeta.setCustomModelData(Integer.valueOf(3));
        aeternalisFuelMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "custom_model_data"), PersistentDataType.STRING, (Object)"aeternalis_fuel");
        PersistentDataContainer aeternalisFuelContainer = aeternalisFuelMeta.getPersistentDataContainer();
        aeternalisFuelContainer.set(this.aeternalisFuelKey, PersistentDataType.BYTE, (Object)1);
        this.aeternalisFuel.setItemMeta(aeternalisFuelMeta);
        this.alchemicalCoalBlock = new ItemStack(Material.COAL_BLOCK);
        ItemMeta alchemicalCoalBlockMeta = this.alchemicalCoalBlock.getItemMeta();
        alchemicalCoalBlockMeta.setDisplayName(String.valueOf(ChatColor.RED) + "\u70bc\u91d1\u7164\u70ad\u5757");
        alchemicalCoalBlockMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "\u9ad8\u6548\u7684\u71c3\u6599\u5757", String.valueOf(ChatColor.YELLOW) + "\u71c3\u70e7\u65f6\u95f4: 2880\u79d2"));
        alchemicalCoalBlockMeta.setCustomModelData(Integer.valueOf(4));
        alchemicalCoalBlockMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "custom_model_data"), PersistentDataType.STRING, (Object)"alchemical_coal_block");
        PersistentDataContainer alchemicalCoalBlockContainer = alchemicalCoalBlockMeta.getPersistentDataContainer();
        alchemicalCoalBlockContainer.set(this.alchemicalCoalKey, PersistentDataType.BYTE, (Object)2);
        this.alchemicalCoalBlock.setItemMeta(alchemicalCoalBlockMeta);
        this.mobiusFuelBlock = new ItemStack(Material.COAL_BLOCK);
        ItemMeta mobiusFuelBlockMeta = this.mobiusFuelBlock.getItemMeta();
        mobiusFuelBlockMeta.setDisplayName(String.valueOf(ChatColor.RED) + "\u83ab\u6bd4\u4e4c\u65af\u71c3\u6599\u5757");
        mobiusFuelBlockMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "\u9ad8\u5ea6\u6d53\u7f29\u7684\u71c3\u6599\u5757", String.valueOf(ChatColor.YELLOW) + "\u71c3\u70e7\u65f6\u95f4: 11520\u79d2"));
        mobiusFuelBlockMeta.setCustomModelData(Integer.valueOf(5));
        mobiusFuelBlockMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "custom_model_data"), PersistentDataType.STRING, (Object)"mobius_fuel_block");
        PersistentDataContainer mobiusFuelBlockContainer = mobiusFuelBlockMeta.getPersistentDataContainer();
        mobiusFuelBlockContainer.set(this.mobiusFuelKey, PersistentDataType.BYTE, (Object)2);
        this.mobiusFuelBlock.setItemMeta(mobiusFuelBlockMeta);
        this.aeternalisFuelBlock = new ItemStack(Material.COAL_BLOCK);
        ItemMeta aeternalisFuelBlockMeta = this.aeternalisFuelBlock.getItemMeta();
        aeternalisFuelBlockMeta.setDisplayName(String.valueOf(ChatColor.RED) + "\u6c38\u6052\u71c3\u6599\u5757");
        aeternalisFuelBlockMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "\u51e0\u8fd1\u6c38\u6052\u7684\u71c3\u6599\u5757", String.valueOf(ChatColor.YELLOW) + "\u71c3\u70e7\u65f6\u95f4: 46080\u79d2"));
        aeternalisFuelBlockMeta.setCustomModelData(Integer.valueOf(6));
        aeternalisFuelBlockMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "custom_model_data"), PersistentDataType.STRING, (Object)"aeternalis_fuel_block");
        PersistentDataContainer aeternalisFuelBlockContainer = aeternalisFuelBlockMeta.getPersistentDataContainer();
        aeternalisFuelBlockContainer.set(this.aeternalisFuelKey, PersistentDataType.BYTE, (Object)2);
        this.aeternalisFuelBlock.setItemMeta(aeternalisFuelBlockMeta);
    }

    public ItemStack getAlchemicalCoal() {
        return this.alchemicalCoal.clone();
    }

    public ItemStack getMobiusFuel() {
        return this.mobiusFuel.clone();
    }

    public ItemStack getAeternalisFuel() {
        return this.aeternalisFuel.clone();
    }

    public ItemStack getAlchemicalCoalBlock() {
        return this.alchemicalCoalBlock.clone();
    }

    public ItemStack getMobiusFuelBlock() {
        return this.mobiusFuelBlock.clone();
    }

    public ItemStack getAeternalisFuelBlock() {
        return this.aeternalisFuelBlock.clone();
    }

    public boolean isAlchemicalCoal(ItemStack item) {
        if (item == null || item.getType() != Material.COAL) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.alchemicalCoalKey, PersistentDataType.BYTE);
    }

    public boolean isMobiusFuel(ItemStack item) {
        if (item == null || item.getType() != Material.COAL) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.mobiusFuelKey, PersistentDataType.BYTE);
    }

    public boolean isAeternalisFuel(ItemStack item) {
        if (item == null || item.getType() != Material.COAL) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.aeternalisFuelKey, PersistentDataType.BYTE);
    }

    public boolean isAlchemicalCoalBlock(ItemStack item) {
        if (item == null || item.getType() != Material.COAL_BLOCK) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.alchemicalCoalKey, PersistentDataType.BYTE) && (Byte)container.get(this.alchemicalCoalKey, PersistentDataType.BYTE) == 2;
    }

    public boolean isMobiusFuelBlock(ItemStack item) {
        if (item == null || item.getType() != Material.COAL_BLOCK) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.mobiusFuelKey, PersistentDataType.BYTE) && (Byte)container.get(this.mobiusFuelKey, PersistentDataType.BYTE) == 2;
    }

    public boolean isAeternalisFuelBlock(ItemStack item) {
        if (item == null || item.getType() != Material.COAL_BLOCK) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(this.aeternalisFuelKey, PersistentDataType.BYTE) && (Byte)container.get(this.aeternalisFuelKey, PersistentDataType.BYTE) == 2;
    }

    @EventHandler
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        ItemStack fuel = event.getFuel();
        if (fuel == null) {
            return;
        }
        int burnTime = 0;
        if (this.isAlchemicalCoal(fuel)) {
            burnTime = this.burnTimes.get("alchemical_coal");
        } else if (this.isMobiusFuel(fuel)) {
            burnTime = this.burnTimes.get("mobius_fuel");
        } else if (this.isAeternalisFuel(fuel)) {
            burnTime = this.burnTimes.get("aeternalis_fuel");
        } else if (this.isAlchemicalCoalBlock(fuel)) {
            burnTime = this.burnTimes.get("alchemical_coal_block");
        } else if (this.isMobiusFuelBlock(fuel)) {
            burnTime = this.burnTimes.get("mobius_fuel_block");
        } else if (this.isAeternalisFuelBlock(fuel)) {
            burnTime = this.burnTimes.get("aeternalis_fuel_block");
        }
        if (burnTime > 0) {
            event.setBurnTime(burnTime);
        }
    }

    public String getNbtTagInfo() {
        StringBuilder info = new StringBuilder();
        info.append("\u7279\u6b8a\u71c3\u6599NBT\u6807\u7b7e\u4fe1\u606f\uff1a\n\n");
        info.append("1. \u70bc\u91d1\u7164\u70ad (CustomModelData: 1)\n");
        info.append("   - \u547d\u540d\u7a7a\u95f4\u952e: ").append(this.alchemicalCoalKey.toString()).append("\n");
        info.append("   - \u6570\u636e\u7c7b\u578b: BYTE\n");
        info.append("   - \u6570\u636e\u503c: 1\n\n");
        info.append("2. \u83ab\u6bd4\u4e4c\u65af\u71c3\u6599 (CustomModelData: 2)\n");
        info.append("   - \u547d\u540d\u7a7a\u95f4\u952e: ").append(this.mobiusFuelKey.toString()).append("\n");
        info.append("   - \u6570\u636e\u7c7b\u578b: BYTE\n");
        info.append("   - \u6570\u636e\u503c: 1\n\n");
        info.append("3. \u6c38\u6052\u71c3\u6599 (CustomModelData: 3)\n");
        info.append("   - \u547d\u540d\u7a7a\u95f4\u952e: ").append(this.aeternalisFuelKey.toString()).append("\n");
        info.append("   - \u6570\u636e\u7c7b\u578b: BYTE\n");
        info.append("   - \u6570\u636e\u503c: 1\n\n");
        info.append("4. \u70bc\u91d1\u7164\u70ad\u5757 (CustomModelData: 4)\n");
        info.append("   - \u547d\u540d\u7a7a\u95f4\u952e: ").append(this.alchemicalCoalKey.toString()).append("\n");
        info.append("   - \u6570\u636e\u7c7b\u578b: BYTE\n");
        info.append("   - \u6570\u636e\u503c: 2\n\n");
        info.append("5. \u83ab\u6bd4\u4e4c\u65af\u71c3\u6599\u5757 (CustomModelData: 5)\n");
        info.append("   - \u547d\u540d\u7a7a\u95f4\u952e: ").append(this.mobiusFuelKey.toString()).append("\n");
        info.append("   - \u6570\u636e\u7c7b\u578b: BYTE\n");
        info.append("   - \u6570\u636e\u503c: 2\n\n");
        info.append("6. \u6c38\u6052\u71c3\u6599\u5757 (CustomModelData: 6)\n");
        info.append("   - \u547d\u540d\u7a7a\u95f4\u952e: ").append(this.aeternalisFuelKey.toString()).append("\n");
        info.append("   - \u6570\u636e\u7c7b\u578b: BYTE\n");
        info.append("   - \u6570\u636e\u503c: 2\n\n");
        return info.toString();
    }

    public void setFuelEmcValues() {
        DatabaseManager db = this.plugin.getDatabaseManager();
        db.setEmc(this.alchemicalCoalKey.toString(), 512L);
        db.setEmc(this.mobiusFuelKey.toString(), 2048L);
        db.setEmc(this.aeternalisFuelKey.toString(), 8192L);
        db.setEmc(this.alchemicalCoalKey.toString() + "_block", 4608L);
        db.setEmc(this.mobiusFuelKey.toString() + "_block", 18432L);
        db.setEmc(this.aeternalisFuelKey.toString() + "_block", 73728L);
    }
}

