/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.Little_100.projecte.AlchemicalBag.AlchemicalBagManager;
import org.Little_100.projecte.BlockListener;
import org.Little_100.projecte.CommandManager;
import org.Little_100.projecte.EmcManager;
import org.Little_100.projecte.ItemStackLimitListener;
import org.Little_100.projecte.LanguageManager;
import org.Little_100.projecte.PhilosopherStoneListener;
import org.Little_100.projecte.RecipeManager;
import org.Little_100.projecte.ResourcePackManager;
import org.Little_100.projecte.TransmutationTable.GUIListener;
import org.Little_100.projecte.compatibility.SchedulerAdapter;
import org.Little_100.projecte.compatibility.SchedulerMatcher;
import org.Little_100.projecte.compatibility.VersionAdapter;
import org.Little_100.projecte.compatibility.VersionMatcher;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ProjectE
extends JavaPlugin {
    private static ProjectE instance;
    private ItemStack philosopherStone;
    private NamespacedKey philosopherStoneKey;
    private RecipeManager recipeManager;
    private DatabaseManager databaseManager;
    private EmcManager emcManager;
    private VersionAdapter versionAdapter;
    private AlchemicalBagManager alchemicalBagManager;
    private LanguageManager languageManager;
    private ResourcePackManager resourcePackManager;
    private SchedulerAdapter schedulerAdapter;
    private final Map<Material, Material> upgradeMap = new HashMap<Material, Material>();
    private final Map<Material, Material> downgradeMap = new HashMap<Material, Material>();

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        try {
            ZipEntry entry;
            ZipInputStream zip = new ZipInputStream(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().openStream());
            while ((entry = zip.getNextEntry()) != null) {
                File outFile;
                String name = entry.getName();
                if (!name.endsWith(".yml") || entry.isDirectory() || name.equals("plugin.yml") || (outFile = new File(this.getDataFolder(), name.substring(name.lastIndexOf(47) + 1))).exists()) continue;
                this.saveResource(name, false);
                this.getLogger().info("\u81ea\u52a8\u91ca\u653e\u8bed\u8a00\u6587\u4ef6: " + name);
            }
            zip.close();
        }
        catch (Exception e) {
            this.getLogger().warning("\u81ea\u52a8\u91ca\u653e yml \u8bed\u8a00\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
        }
        this.databaseManager = new DatabaseManager(this.getDataFolder());
        this.versionAdapter = VersionMatcher.getAdapter();
        if (this.versionAdapter == null) {
            this.getLogger().severe("Failed to find a compatible version adapter. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.schedulerAdapter = SchedulerMatcher.getSchedulerAdapter(this);
        this.languageManager = new LanguageManager(this);
        this.emcManager = new EmcManager(this);
        try {
            this.getLogger().info("Calculating EMC values...");
            this.emcManager.calculateAndStoreEmcValues();
            this.getLogger().info("EMC calculation complete.");
        }
        catch (Exception e) {
            this.getLogger().severe("An error occurred during EMC calculation. Some items may not have EMC values. Please check your config.yml for formatting errors.");
            e.printStackTrace();
        }
        this.createPhilosopherStone();
        this.recipeManager = new RecipeManager(this);
        this.recipeManager.registerAllRecipes();
        this.removeVanillaRecipe();
        this.initMaterialMaps();
        Bukkit.getPluginManager().registerEvents((Listener)new PhilosopherStoneListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PhilosopherStoneListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ItemStackLimitListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GUIListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BlockListener(), (Plugin)this);
        CommandManager commandManager = new CommandManager(this);
        this.getCommand("projecte").setExecutor((CommandExecutor)commandManager);
        this.getCommand("projecte").setTabCompleter((TabCompleter)commandManager);
        if (this.getConfig().getBoolean("AlchemicalBag.enabled", true)) {
            this.alchemicalBagManager = new AlchemicalBagManager(this);
            this.alchemicalBagManager.register();
            this.getLogger().info("Alchemical Bag feature is enabled.");
        } else {
            this.getLogger().info("Alchemical Bag feature is disabled in the config.");
        }
        this.resourcePackManager = new ResourcePackManager(this);
        this.getLogger().info("Resource Pack Manager initialized.");
        this.getLogger().info("ProjectE\u63d2\u4ef6\u5df2\u542f\u7528!");
    }

    public void onDisable() {
        if (this.recipeManager != null) {
            this.recipeManager.unregisterAllRecipes();
        }
        if (this.alchemicalBagManager != null) {
            this.alchemicalBagManager.unregister();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("ProjectE\u63d2\u4ef6\u5df2\u7981\u7528!");
    }

    public static ProjectE getInstance() {
        return instance;
    }

    public ItemStack getPhilosopherStone() {
        return this.philosopherStone.clone();
    }

    public boolean isPhilosopherStone(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material stoneMaterial = this.versionAdapter.getMaterial("POPPED_CHORUS_FRUIT");
        if (stoneMaterial == null) {
            stoneMaterial = Material.NETHER_STAR;
        }
        return item.getType() == stoneMaterial;
    }

    public NamespacedKey getPhilosopherStoneKey() {
        return this.philosopherStoneKey;
    }

    private void createPhilosopherStone() {
        Material stoneMaterial = this.versionAdapter.getMaterial("POPPED_CHORUS_FRUIT");
        if (stoneMaterial == null) {
            stoneMaterial = Material.NETHER_STAR;
        }
        this.philosopherStone = new ItemStack(stoneMaterial, 1);
        ItemMeta meta = this.philosopherStone.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "\u8d24\u8005\u4e4b\u77f3");
        meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "\u5f3a\u5927\u7684\u70bc\u91d1\u672f\u9053\u5177", String.valueOf(ChatColor.YELLOW) + "\u53ef\u8f6c\u6362\u77ff\u7269", String.valueOf(ChatColor.YELLOW) + "\u6f5c\u884c+\u53f3\u952e\u6253\u5f00\u5de5\u4f5c\u53f0"));
        meta.setUnbreakable(true);
        this.philosopherStoneKey = new NamespacedKey((Plugin)this, "philosopher_stone");
        this.philosopherStone.setItemMeta(meta);
        this.philosopherStone.setAmount(1);
    }

    private void removeVanillaRecipe() {
        try {
            Bukkit.removeRecipe((NamespacedKey)NamespacedKey.minecraft((String)"popped_chorus_fruit"));
        }
        catch (Exception e) {
            this.getLogger().warning("\u65e0\u6cd5\u79fb\u9664\u539f\u7248\u7206\u88c2\u7d2b\u9882\u679c\u914d\u65b9: " + e.getMessage());
        }
    }

    private void initMaterialMaps() {
        this.upgradeMap.put(Material.COAL, Material.COPPER_INGOT);
        this.upgradeMap.put(Material.COPPER_INGOT, Material.IRON_INGOT);
        this.upgradeMap.put(Material.IRON_INGOT, Material.GOLD_INGOT);
        this.upgradeMap.put(Material.GOLD_INGOT, Material.DIAMOND);
        this.upgradeMap.put(Material.DIAMOND_BLOCK, Material.NETHERITE_INGOT);
        this.downgradeMap.put(Material.COPPER_INGOT, Material.COAL);
        this.downgradeMap.put(Material.IRON_INGOT, Material.COPPER_INGOT);
        this.downgradeMap.put(Material.GOLD_INGOT, Material.IRON_INGOT);
        this.downgradeMap.put(Material.DIAMOND, Material.GOLD_INGOT);
        this.downgradeMap.put(Material.NETHERITE_INGOT, Material.DIAMOND);
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public EmcManager getEmcManager() {
        return this.emcManager;
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.languageManager.loadLanguageFiles();
        if (this.recipeManager != null) {
            this.recipeManager.unregisterAllRecipes();
            this.recipeManager.registerAllRecipes();
            this.getLogger().info("All recipes have been reloaded from recipe.yml.");
        }
        this.emcManager = new EmcManager(this);
        this.emcManager.calculateAndStoreEmcValues();
        this.getLogger().info("ProjectE plugin has been reloaded!");
    }

    public VersionAdapter getVersionAdapter() {
        return this.versionAdapter;
    }

    public SchedulerAdapter getSchedulerAdapter() {
        return this.schedulerAdapter;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public ResourcePackManager getResourcePackManager() {
        return this.resourcePackManager;
    }

    public Material getUpgradedMaterial(Material material) {
        return this.upgradeMap.getOrDefault(material, null);
    }

    public Material getDowngradedMaterial(Material material) {
        return this.downgradeMap.getOrDefault(material, null);
    }
}

