/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.Little_100.projecte.ProjectE;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class ResourcePackManager
implements Listener {
    private final ProjectE plugin;
    private final File resourcePackFile;
    private final String resourcePackUrl;
    private final boolean autoSendResourcePack;
    private File resourcePackSourceDir;

    public ResourcePackManager(ProjectE plugin) {
        this.plugin = plugin;
        File resourcePackDir = new File(plugin.getDataFolder(), "resourcepacks");
        if (!resourcePackDir.exists()) {
            resourcePackDir.mkdirs();
        }
        this.resourcePackSourceDir = new File(plugin.getDataFolder(), "ResourcePackSource");
        if (!this.resourcePackSourceDir.exists()) {
            this.resourcePackSourceDir.mkdirs();
        }
        this.resourcePackFile = new File(resourcePackDir, "ProjectE_Resourcepack.zip");
        try {
            this.extractResourcePack();
        }
        catch (IOException e) {
            plugin.getLogger().severe("\u521d\u59cb\u5316\u8d44\u6e90\u5305\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
        this.resourcePackUrl = plugin.getConfig().getString("resourcepack.url", "");
        this.autoSendResourcePack = plugin.getConfig().getBoolean("resourcepack.auto_send", true);
    }

    public void extractResourcePack() throws IOException {
        block8: {
            if (!this.resourcePackFile.exists() || this.plugin.getConfig().getBoolean("resourcepack.force_update", false)) {
                this.plugin.getLogger().info("\u63d0\u53d6\u8d44\u6e90\u5305\u5230: " + this.resourcePackFile.getAbsolutePath());
                try (InputStream inputStream = this.plugin.getResource("pack/ProjectE Resourcepack.zip");){
                    if (inputStream != null) {
                        Files.copy(inputStream, Path.of(this.resourcePackFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        this.plugin.getLogger().info("\u8d44\u6e90\u5305\u63d0\u53d6\u6210\u529f");
                        break block8;
                    }
                    this.plugin.getLogger().warning("\u65e0\u6cd5\u5728JAR\u4e2d\u627e\u5230\u8d44\u6e90\u5305");
                    throw new IOException("\u8d44\u6e90\u5305\u6587\u4ef6\u5728JAR\u4e2d\u4e0d\u5b58\u5728");
                }
            }
        }
    }

    public void sendResourcePack(Player player) {
        if (this.resourcePackUrl.isEmpty()) {
            this.plugin.getLogger().warning("\u65e0\u6cd5\u5411\u73a9\u5bb6 " + player.getName() + " \u53d1\u9001\u8d44\u6e90\u5305: \u672a\u914d\u7f6eURL");
            player.sendMessage("\u00a7c\u65e0\u6cd5\u52a0\u8f7d\u81ea\u5b9a\u4e49\u6750\u8d28: \u670d\u52a1\u5668\u672a\u914d\u7f6e\u8d44\u6e90\u5305URL");
            return;
        }
        this.plugin.getLogger().info("\u5411\u73a9\u5bb6 " + player.getName() + " \u53d1\u9001\u8d44\u6e90\u5305");
        player.sendMessage("\u00a7a\u6b63\u5728\u53d1\u9001\u81ea\u5b9a\u4e49\u6750\u8d28\u5305...");
        player.setResourcePack(this.resourcePackUrl);
    }

    public void rebuildResourcePack() {
        if (!this.resourcePackSourceDir.exists() || !this.resourcePackSourceDir.isDirectory()) {
            this.plugin.getLogger().warning("\u8d44\u6e90\u5305\u6e90\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u91cd\u5efa\u8d44\u6e90\u5305");
            return;
        }
        try {
            this.plugin.getLogger().info("\u6b63\u5728\u4ece\u6e90\u76ee\u5f55\u91cd\u5efa\u8d44\u6e90\u5305...");
            try (final ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(this.resourcePackFile));){
                Files.walkFileTree(this.resourcePackSourceDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String entryPath = ResourcePackManager.this.resourcePackSourceDir.toPath().relativize(file).toString().replace('\\', '/');
                        ZipEntry zipEntry = new ZipEntry(entryPath);
                        zipOut.putNextEntry(zipEntry);
                        Files.copy(file, zipOut);
                        zipOut.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            this.plugin.getLogger().info("\u8d44\u6e90\u5305\u91cd\u5efa\u5b8c\u6210: " + this.resourcePackFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u91cd\u5efa\u8d44\u6e90\u5305\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public File getResourcePackFile() {
        return this.resourcePackFile;
    }

    public String getResourcePackUrl() {
        return this.resourcePackUrl;
    }
}

